/**  FinestraXNS
 *     Finestra per mostrare e aggiornare il contenuto di un Place/Domain Name Service.
 *     Questa  solo l'interfaccia grafica; le richieste dei dati sono fatte al "modello".
 *     Il modello "distinguer" se questa finestra far capo a un DNS o a un PNS.
 *     @author     Luigi Antenucci
 *     @version    2.3
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.PlaceID;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.table.TableModel;


public class FinestraXNS extends Finestra {

      /**
       *  Costanti per il tipo di finestra da aprire: con o senza i bottoni 
       *  che permettono la modifica dei dati.
       */
  public static final  int MODIFICABILE = 0;
  public static final  int MOSTRA_SOLO  = 1;

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_INSERA  = new ImageIcon(PICTURE_PATH+"CartInserisci.gif");
  protected static final ImageIcon IMG_ICO_CANCA   = new ImageIcon(PICTURE_PATH+"CartCancella.gif");
  protected static final ImageIcon IMG_ICO_AGGIO   = new ImageIcon(PICTURE_PATH+"CartAggiorna.gif");
  protected static final ImageIcon IMG_ICO_UPUPUP  = new ImageIcon(PICTURE_PATH+"CartUpdate.gif");
  protected static final ImageIcon IMG_ICO_CHUDEME = new ImageIcon(PICTURE_PATH+"BotKO.gif");
  protected static final ImageIcon IMG_ICO_ZAMPA   = new ImageIcon(PICTURE_PATH+"Zampina.gif");

      /**
       *  Per memorizzare i parametri passati al costruttore, 
       *  in modo che siano visibili anche agli altri metodi.
       */
  protected ModelloXNS modelloXNS;
  protected int modifMostra;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected PanChePlace panChePlace;
  protected JTable      tabella;
  protected TableModel  modelloTabella;
  protected Pannello    panInfoPlus;
  protected JButton     botPut, botDel, botRef,
                        botUpdate, botClose;


      /**
       *  Costruzione della finestra per la visualizzazione e modifica del D/P-NS.
       *  Il {@link SOMA.gui.ModelloXNS} passato specifica il modello che usa questa finestra.
       *  Sar a lui che verranno richiesti i dati da stampare e a cui saranno 
       *  inoltrati i comandi.
       *  Per default la finestra avr tutti i bottoni di modifica.
       */
  public FinestraXNS (ModelloXNS modelloXNS) {
    this (modelloXNS, MODIFICABILE);
  } //costruttore

      /**
       *  Costruzione della finestra per la visualizzazione e modifica del D/P-NS.
       *  Come il precedente costruttore, ma permette di specificare se avere o
       *  meno i bottoni che permettono all'utente di modificare il modello.
       */
  public FinestraXNS (ModelloXNS modelloXNS, int modifMostra) {
    super (50, 30, modelloXNS.cheTipo()+" - "+ modelloXNS.perChePlace());
                     // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE
    this.modelloXNS  = modelloXNS;
    this.modifMostra = modifMostra;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    PlaceID placeID = modelloXNS.perChePlace();
    panChePlace = new PanChePlace (placeID);

    if (modifMostra == MODIFICABILE) {
      botPut = new JButton ();
      botDel = new JButton ();
      botRef = new JButton ();

      botPut.setCursor (cursoreBottone);
      botDel.setCursor (cursoreBottone);
      botRef.setCursor (cursoreBottone);

      botRef.setEnabled (modelloXNS.refreshInvocabile());
    }

    botUpdate= new JButton ();    
    botClose = new JButton ();

    botUpdate.setCursor (cursoreBottone);
    botClose .setCursor (cursoreBottone);

    modelloTabella = modelloXNS.cheTabella();
    tabella = new JTable (modelloTabella);
    tabella.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);

    ListSelectionModel lsm = tabella.getSelectionModel();
    lsm.addListSelectionListener (new TabellaListener());

    JScrollPane tabellaScroll = new JScrollPane (tabella);
    tabella.setPreferredScrollableViewportSize (new Dimension(400, 84));
    tabellaScroll.setMinimumSize (new Dimension(50,30));
    tabellaScroll.updateUI();

    panInfoPlus = modelloXNS.pannelloInfoInPiu();   // Il pannello lo ricrea ogni volta
    // NB: "panInfoPlus" pu anche essere "null"!

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(this, modelloXNS);
    if (modifMostra == MODIFICABILE) {
      botPut .addActionListener (bottoniera);
      botPut .setActionCommand("put");
      botDel .addActionListener (bottoniera);
      botDel .setActionCommand("del");
      botRef .addActionListener (bottoniera);
      botRef .setActionCommand("refresh");
    }
    botClose .addActionListener (bottoniera);
    botClose .setActionCommand("close");
    botUpdate.addActionListener (bottoniera);
    botUpdate.setActionCommand("update");

    if (modifMostra == MODIFICABILE) {
      botPut.setHorizontalAlignment(JLabel.LEFT);
      botDel.setHorizontalAlignment(JLabel.LEFT);

      botPut.setIcon (IMG_ICO_INSERA);
      botDel.setIcon (IMG_ICO_CANCA);
      botRef.setIcon (IMG_ICO_AGGIO);
    }
    botUpdate.setIcon (IMG_ICO_UPUPUP);
    botClose .setIcon (IMG_ICO_CHUDEME);
    botClose.setPressedIcon(IMG_ICO_ZAMPA);

    if (modifMostra == MODIFICABILE)
      botDel.setEnabled (false);  // Per ora  disabilitato (devo selezionare una riga nella tabella)

    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    PanCentro.setLayout (new BorderLayout());

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 5, 8, 5));   // alto,sx,basso,dx

    panChePlace.setBorder (BorderFactory.createEmptyBorder(0, 0, 15, 0));   // alto,sx,basso,dx
    PanCentro.add (panChePlace, BorderLayout.NORTH);

    PanCentro.add (tabellaScroll, BorderLayout.CENTER);

    JPanel panInfoBott = new JPanel(new BorderLayout());

      if (panInfoPlus != null) {
        panInfoPlus.setBorder (BorderFactory.createCompoundBorder(
                               BorderFactory.createBevelBorder(BevelBorder.RAISED, Color.white, Color.gray),
                               BorderFactory.createEmptyBorder(10, 10, 15, 10) ));   // alto,sx,basso,dx
        panInfoBott.add (panInfoPlus, BorderLayout.NORTH);
      }

      JPanel panBott = new JPanel();
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panBott.setLayout (GBL3);
        CC3.fill = GridBagConstraints.BOTH;
        if (modifMostra == MODIFICABILE) {
          CC3.gridx = 1;   CC3.gridy = 1;
          GBL3.setConstraints (botPut, CC3);
          panBott.add (botPut);
          CC3.gridx = 1;   CC3.gridy = 2;
          GBL3.setConstraints (botDel, CC3);
          panBott.add (botDel);
          CC3.gridx = 2;   CC3.gridy = 1;
          GBL3.setConstraints (botRef, CC3);
          panBott.add (botRef);
        }
        CC3.gridx = 2;   CC3.gridy = 2;
        GBL3.setConstraints (botUpdate, CC3);
        panBott.add (botUpdate);
        if (modifMostra == MODIFICABILE) {
          CC3.gridx = 2;   CC3.gridy = 3;
        }
        else {
          CC3.gridx = 3;   CC3.gridy = 2;
        }
        GBL3.setConstraints (botClose, CC3);
        panBott.add (botClose);
        panBott.setBorder (BorderFactory.createEmptyBorder(15, 10, 0, 10));   // alto,sx,basso,dx
      panInfoBott.add (panBott, BorderLayout.SOUTH);

    panInfoBott.setBorder (BorderFactory.createEmptyBorder(15, 0, 0, 0));   // alto,sx,basso,dx
    PanCentro.add (panInfoBott, BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    if (panInfoPlus != null)
      panInfoPlus.distruggimi();
    panChePlace.distruggimi();

    super.distruggiFinestra();
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {
    if (modifMostra == MODIFICABILE) {
      botPut .setText (Lingua.frase("FX_BOT_PUT"));
      botDel .setText (Lingua.frase("FX_BOT_DEL"));
      botRef .setText (Lingua.frase("FX_BOT_REFRESH"));
    }
    botUpdate.setText (Lingua.frase("FX_BOT_UPDATE"));
    botClose .setText (Lingua.frase("FX_BOT_CLOSE"));

    tabella  .setToolTipText (Lingua.frase("FX_TIP_TABLE"));

    if (modifMostra == MODIFICABILE) {
      botPut   .setToolTipText (Lingua.frase("FX_TIP_PUT"));
      botDel   .setToolTipText (Lingua.frase("FX_TIP_DEL"));
      botRef   .setToolTipText (Lingua.frase("FX_TIP_REF"));
    }
    botUpdate.setToolTipText (Lingua.frase("FX_TIP_UPDATE"));
    botClose .setToolTipText (Lingua.frase("FX_TIP_CLOSE"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  Metodo invocato dalla finestra "FinPutPlace" per rendere i dati dell'inserimento.
       *  Tali dati sono passati come parametro in un oggetto Object che sar dato al modello.
       */
  public void eseguiAzionePut (final Object infoPerPut) {
    // Eseguo in un thread separato, per non bloccare la GUI.
    Thread esecutore = new Thread ("XNS:Put") {
        public void run() {
          modelloXNS.invocaPut (infoPerPut);
          tabella.revalidate();
        } //run
    }; //esecutore (Thread)
    esecutore.start();
    OiDialogoi.mostraMessaggio (Lingua.frase("FX_PUTTING"), mioFrame);
  } //eseguiAzionePut


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected FinestraXNS miaFinestraXNS;
    protected ModelloXNS  modelloXNS;

    public ListBottoni (FinestraXNS miaFinestraXNS, ModelloXNS modelloXNS) {
      this.miaFinestraXNS = miaFinestraXNS;
      this.modelloXNS     = modelloXNS;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("put")) {
        FinPutPlace finPutPlace = new FinPutPlace (miaFinestraXNS, modelloXNS);
        // Questa finestra verr bloccata dalla FinPutPlace 
        // fintanto che non verr distrutta.
        // Alla chiusura con "OK" viene invocato il metodo 
        // "eseguiAzionePut" di questa finestra.
      }
      else
        if (azione.equals("del")) {
          int riga = tabella.getSelectedRow();   // I dati li prelevo ora (non voglio che siano alterati)
          if (riga >= 0) {
            final PlaceID placeID = (PlaceID) modelloTabella.getValueAt (riga, 0);
            if (placeID != null) {
              Thread esecutore = new Thread ("XNS:Del") {
                  public void run() {
                    modelloXNS.invocaDel (placeID);
                    tabella.revalidate();
                  } //run
              }; //esecutore (Thread)
              esecutore.start();
              OiDialogoi.mostraMessaggio (Lingua.frase("FX_DELETING"), mioFrame);
            }
          }
        }
        else
          if (azione.equals("refresh")) {
            Thread esecutore = new Thread ("XNS:Refresh") {
                public void run() {
                  modelloXNS.invocaRefresh ();
                  SwingUtilities.invokeLater (new Runnable () {
                      public void run () {
                        tabella.revalidate();
                        tabella.clearSelection();
                        botDel.setEnabled (false);
                      } //run
                  }); //invokeLater
                } //run
            }; //esecutore (Thread)
            esecutore.start();
            OiDialogoi.mostraMessaggio (Lingua.frase("FX_REFRESHING"), mioFrame);
          }
          else
            if (azione.equals("update")) {
              // Richiedo anche il pannello di informazioni
              panInfoPlus = modelloXNS.pannelloInfoInPiu();
              tabella.revalidate();
              tabella.clearSelection();
              if (modifMostra == MODIFICABILE)
                botDel.setEnabled (false);
            }
            else  // in ogni caso considera un "Annulla"
              miaFinestraXNS.distruggiFinestra();   // In ogni caso distruggo questa finestra
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      miaFinestraXNS.distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

      /**
       *  CLASSE INTERNA CHE FUNGE DA ASCOLTATORE DELLE SELEZIONI FATTE SULLA TABELLA.
       */
  public class TabellaListener implements ListSelectionListener {

    public void valueChanged (ListSelectionEvent e) {
      int riga = tabella.getSelectedRow();    // OTTENGO IL N.DELLA RIGA SELEZIONATA
      if (modifMostra == MODIFICABILE)
        botDel.setEnabled (riga >= 0);
    } //valueChanged
  } //TabellaListener


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ModelloXNS modelloXNS = new ModelloXNS() {
        public String  cheTipo() { return "Pippo"; }
        public PlaceID perChePlace () { return new PlaceID("dominietto","plaisetto"); }

        public TableModel cheTabella () {
                TableModel modello = new javax.swing.table.AbstractTableModel () {
                  public int getColumnCount () { return 3; }
                  public int getRowCount ()    { return 6; }
                  public Object getValueAt (int row, int col) {
                    return new Integer (row*col*col); 
                  }
                  public String getColumnName (int col) {
                    switch (col) {
                      case  0: return "CampoN1";
                      case  1: return "Campetto";
                      case  2: return "TestataN3";
                      default: return null;
                    }
                  } //getColumnName
                  public boolean isCellEditable (int r, int c) { return false; }
                  public Class getColumnClass(int col) {
                    return getValueAt(0,col).getClass();
                  } //getColumnClass
                }; //modello (TableModel)
          return modello;
        } //cheTabella
        public Pannello pannelloInfoInPiu () {
          return null;
        } //pannelloInfoInPiu
        public void invocaPut (Object informazioni) { System.out.println("PUT");     }
        public void invocaDel (PlaceID placeID)     { System.out.println("DEL");     }
        public void invocaRefresh ()                { System.out.println("REFRESH"); }
        public boolean refreshInvocabile ()         { return true; }
    };
    new FinestraXNS (modelloXNS);
  } //main
*/

} //FinestraXNS