/**  FinestraPlace
 *     Finestra di un Place (normale o di default).
 *     Tramite un men l'utente pu invocare le principali funzioni messe a disposizione da SOMA.
 *     @author     Luigi Antenucci
 *     @version    5.55
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.gui.lingua.LinguaGui;
import SOMA.gui.remotegui.SportelloRichieste;
import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.explorer.ExplorerThread;
import SOMA.explorer.DirExplorerItem;
import SOMA.mobilePlace.MobileEnvironment;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.mobilePlace.MobilePlaceManager;
import SOMA.security.SecurityEnvironment;
import SOMA.security.infrastructure.ProfileManager;
import SOMA.security.infrastructure.Infrastructure;
import SOMA.security.infrastructure.CertificateCRLList;
import SOMA.security.infrastructure.explorer.ProfileLoginExplorerItem;
import SOMA.security.infrastructure.explorer.ProfileExplorerItem;
import SOMA.security.infrastructure.explorer.PolicyUpdateItem;
import SOMA.security.infrastructure.updatePolicy.UpdateDaemon;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.Enumeration;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeModel;


public class FinestraPlace extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final String  AZIONE_PLACEID     = "PlaceID";
  protected static final String  AZIONE_WIN_DNS     = "FinDomainNS";
  protected static final String  AZIONE_WIN_PNS     = "FinPlaceNS";
  protected static final String  AZIONE_PLTHREAD    = "PlaceThread";
  protected static final String  AZIONE_REM_APPLET  = "RemoteApplet";
  protected static final String  AZIONE_CLRSCR      = "ClrScr";
  protected static final String  AZIONE_LAUNCH      = "LaunchAgent";
  protected static final String  AZIONE_MANIPUL     = "AgentManip";
  protected static final String  AZIONE_POSIT       = "MyAgentPos";
  protected static final String  AZIONE_LOCHOST     = "LocalIP";
  protected static final String  AZIONE_MEMORY      = "MemoryAllAloneInTheMoonlighyt";
  protected static final String  AZIONE_CALLGC      = "GarbageCollector";
  protected static final String  AZIONE_ALLTHREAD   = "AllThread";
  protected static final String  AZIONE_PROPER      = "Properties";
  protected static final String  AZIONE_AGENTPATH   = "AgentPath";
  protected static final String  AZIONE_CACHEPATH   = "CachePath";
  protected static final String  AZIONE_DELCACHE    = "CancellaCache";
  protected static final String  AZIONE_EXPERT      = "Esperto";
  protected static final String  AZIONE_MOBILE_CONN = "ConnectDisconnect";
  protected static final String  AZIONE_CAADDRESS   = "CAAddress";
  protected static final String  AZIONE_PRO_LOGIN   = "ProfileLogin";
  protected static final String  AZIONE_PRO_LOGOFF  = "ProfileLogoff";
  protected static final String  AZIONE_PRO_CREREC  = "ProfileCreRec";
  protected static final String  AZIONE_PRO_DISTIN  = "ProfileDisting";
  protected static final String  AZIONE_PRO_CHPASS  = "ProfileCambPass";
  protected static final String  AZIONE_POLI_CRL    = "ProfileShowCRL";
  protected static final String  AZIONE_POLI_UPDATE  = "PolicyUpdate";

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_AGENTE  = new ImageIcon(PICTURE_PATH+"Agente.gif");
  protected static final ImageIcon IMG_ICO_EXPERT  = new ImageIcon(PICTURE_PATH+"Regia.gif");
  protected static final ImageIcon IMG_ICO_MANIPO  = new ImageIcon(PICTURE_PATH+"Manipola.gif");
  protected static final ImageIcon IMG_ICO_CLRSCR  = new ImageIcon(PICTURE_PATH+"Pulisci.gif");
  protected static final ImageIcon IMG_ICO_DNS     = new ImageIcon(PICTURE_PATH+"DomainNS.gif");
  protected static final ImageIcon IMG_ICO_PNS     = new ImageIcon(PICTURE_PATH+"PlaceNS.gif");
  protected static final ImageIcon IMG_ICO_CLOSE   = new ImageIcon(PICTURE_PATH+"BotKO.gif");
  protected static final ImageIcon IMG_ICO_ZAMPA   = new ImageIcon(PICTURE_PATH+"Zampina.gif");

  protected static final ImageIcon IMG_ICO_M_PLACE = new ImageIcon(PICTURE_PATH+"PlaceIDMini.gif");
  protected static final ImageIcon IMG_ICO_M_DNS   = new ImageIcon(PICTURE_PATH+"DomainNSMini.gif");
  protected static final ImageIcon IMG_ICO_M_PNS   = new ImageIcon(PICTURE_PATH+"PlaceNSMini.gif");
  protected static final ImageIcon IMG_ICO_M_CONNC = new ImageIcon(PICTURE_PATH+"ConnIco.gif");
  protected static final ImageIcon IMG_ICO_M_APPLT = new ImageIcon(PICTURE_PATH+"Applet.gif");
  protected static final ImageIcon IMG_ICO_M_TREDPL= new ImageIcon(PICTURE_PATH+"ThreadVari.gif");
  protected static final ImageIcon IMG_ICO_M_CLEAR = new ImageIcon(PICTURE_PATH+"PulisciMini.gif");
  protected static final ImageIcon IMG_ICO_M_CLOSE = new ImageIcon(PICTURE_PATH+"CloseIco.gif");
  protected static final ImageIcon IMG_ICO_M_EXIT  = new ImageIcon(PICTURE_PATH+"ExitIco.gif");
  protected static final ImageIcon IMG_ICO_M_AGENT = new ImageIcon(PICTURE_PATH+"AgenteMini.gif");
  protected static final ImageIcon IMG_ICO_M_MANIP = new ImageIcon(PICTURE_PATH+"ManipolaMini.gif");
  protected static final ImageIcon IMG_ICO_M_POSIZ = new ImageIcon(PICTURE_PATH+"Radar.gif");
  protected static final ImageIcon IMG_ICO_M_INDIP = new ImageIcon(PICTURE_PATH+"IndirIP.gif");
  protected static final ImageIcon IMG_ICO_M_MOON  = new ImageIcon(PICTURE_PATH+"Memory.gif");
  protected static final ImageIcon IMG_ICO_M_GC    = new ImageIcon(PICTURE_PATH+"GC.gif");
  protected static final ImageIcon IMG_ICO_M_TREDAL= new ImageIcon(PICTURE_PATH+"ThreadVari.gif");
  protected static final ImageIcon IMG_ICO_M_PROP  = new ImageIcon(PICTURE_PATH+"Prop.gif");
  protected static final ImageIcon IMG_ICO_M_OPZIO = new ImageIcon(PICTURE_PATH+"Opzioni.gif");
  protected static final ImageIcon IMG_ICO_M_CLCACH= new ImageIcon(PICTURE_PATH+"ClearCache.gif");
  protected static final ImageIcon IMG_ICO_M_EXPERT= new ImageIcon(PICTURE_PATH+"RegiaMini.gif");
  protected static final ImageIcon IMG_ICO_M_ADVCFG= new ImageIcon(PICTURE_PATH+"AdvCfg.gif");
  protected static final ImageIcon IMG_ICO_M_HELP  = new ImageIcon(PICTURE_PATH+"HelpIco.gif");
  protected static final ImageIcon IMG_ICO_M_CAADDR= new ImageIcon(PICTURE_PATH+"CAAddressMini.gif");
  protected static final ImageIcon IMG_ICO_M_PLOGIN= new ImageIcon(PICTURE_PATH+"ProfLoginMini.gif");
  protected static final ImageIcon IMG_ICO_M_PLOGOF= new ImageIcon(PICTURE_PATH+"ProfLogoffMini.gif");
  protected static final ImageIcon IMG_ICO_M_PCRERE= new ImageIcon(PICTURE_PATH+"ProfCreMini.gif");
  protected static final ImageIcon IMG_ICO_M_PDIST = new ImageIcon(PICTURE_PATH+"ProfDistMini.gif");
  protected static final ImageIcon IMG_ICO_M_PCHPAS= new ImageIcon(PICTURE_PATH+"ProfChPassMini.gif");
  protected static final ImageIcon IMG_ICO_M_PCRL  = new ImageIcon(PICTURE_PATH+"PoliCRLMini.gif");
  protected static final ImageIcon IMG_ICO_M_PUPD  = new ImageIcon(PICTURE_PATH+"PoliUpdateMini.gif");

      /**
       *  COSTANTI per la modifica del menu della SICUREZZA
       */
  protected static final int VOCE_CAADDRESS = 1;
  protected static final int VOCE_LOGIN     = 2;
  protected static final int VOCE_RESTANTI  = 4;

      /**
       *  RIFERIMENTO AL PROPRIO {@link SOMA.gui.ActionPlace}
       */
  protected ActionPlace mioActionPlace;

      /**
       *  Input/Output/Error-stream originali del place.
       *  La finestra devia tali input su particolari oggetti dela GUI,
       *  ma alla chiusura della finestra occorre ripristinarli.
       */
  protected InputStream oriIn  = null;
	protected PrintStream oriOut = null;
  protected PrintStream oriErr = null;

      /**
       *  Input/Output-stream della mia finestra.
       */
  protected TextAreaOutputStream2 mioOutStrTxtArea;
  protected PrintStream           finOut;
  protected BufferedReader        inBufReader;
  protected TextFieldInputStream2 finIn;

      /**
       *  Modalit "esperto" attivata o meno.
       */
  protected boolean modoEsperto = false;

      /**
       *  Il thread di "esplorazione" del men a linea ci comando.
       */
  protected ExplorerThread indyJones = null;

      /**
       *  Oggetti contenenti del testo dipendente dalla lingua.
       */
  protected JButton  botLancia, botManipola,
                     botDNS, botPNS,
                     botExpert, botClrScr,
                     botChiudi;
  protected PanFontDim panFontDim = null;
  protected JCheckBoxMenuItem menuCheckExpert,
                              menuRemoteApplet;
  protected JMenuItem         menuItemConnect,
                              menuCAAddress,
                              menuProfileLogin,
                              menuProfileLogoff,
                              menuProfileCreRec,
                              menuProfileDist,
                              menuProfileChPass,
                              menuPolicyCRL,
                              menuPolicyUpdate;

  protected PanTestoSC testata;

      /**
       *  Riferimento alle "text-area" e "text-field" di I/O.
       */
  protected JTextArea  textArea;
  protected JTextField commandLine;

      /**
       *  Propriet di "Config" per ricordarsi la dimensione del font della finestra.
       */
  protected static final String CONFIG_TXT_DIM = "FontTxtDim";
  protected static final int    CONFIG_TXT_INT = 11;
  

      /**
       *  Costruisce una FinestraPlace che far riferimento 
       *  all'{@link SOMA.gui.ActionPlace} passato.
       */
  public FinestraPlace (ActionPlace mioActionPlace) {
    // advanced = true  se la si chiama dalla "advanced configuration"
    super (50, 40, mioActionPlace.chePlaceID().toString());
                  // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE
                  // col titolo finestra = ID del place

    this.mioActionPlace = mioActionPlace;

    Config.defPropVariabile (CONFIG_TXT_DIM, String.valueOf(CONFIG_TXT_INT));

    Environment env = mioActionPlace.cheEnv();

    oriIn  = env.in;        // Salvo l'Input/Output di default
    oriOut = env.out;
    oriErr = env.err;

    costruisciFinestra();   // Costruisce la finestra deviando l'I/O

    env.in  = finIn;        // Devio l'output sulla mia finestra
    env.out = finOut;
    env.err = finOut;
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    testata     = new PanTestoSC (mioActionPlace.chePlaceID().toString());

    botLancia   = new JButton ();
    botManipola = new JButton ();
    botDNS      = new JButton ();
    botPNS      = new JButton ();
    botExpert   = new JButton (); 
    botClrScr   = new JButton ();
    botChiudi   = new JButton ();

    textArea = new JTextArea (4,80);             // CREA AREA DI OUTPUT (STREAM) <righe,colonne>
		textArea.setEnabled (false);
    JScrollPane scrollTextArea = new JScrollPane (textArea);
    scrollTextArea.setPreferredSize (new Dimension(250,100));
    scrollTextArea.setMinimumSize (new Dimension(50,30));
    scrollTextArea.setVerticalScrollBarPolicy (JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    scrollTextArea.setHorizontalScrollBarPolicy (JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

    commandLine = new JTextField (60);
    commandLine.setEditable(false);      // Disabilita input da barra

    scrollTextArea.updateUI();

    mioOutStrTxtArea = new TextAreaOutputStream2 (textArea);
		finOut           = new PrintStream (mioOutStrTxtArea);
		finIn            = new TextFieldInputStream2 (commandLine);
    inBufReader      = new BufferedReader (new InputStreamReader(finIn), 1);

    if (Config.chePropBool("SliderModiFont")) {
      panFontDim = new PanFontDim (Config.chePropInt(CONFIG_TXT_DIM));
      panFontDim.addChangeListener (new ChangeListener () {
                                      public void stateChanged (ChangeEvent e) {
                                        int dim = ( (JSlider)e.getSource() ).getValue();
                                        impostaFontTxt (dim);
                                      }
                                    });
    }
    impostaFontTxt (Config.chePropInt(CONFIG_TXT_DIM));

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(mioActionPlace, this);

    botLancia.addActionListener (bottoniera);
    botLancia.setActionCommand (AZIONE_LAUNCH);
    botManipola.addActionListener (bottoniera);
    botManipola.setActionCommand (AZIONE_MANIPUL);
    botDNS.addActionListener (bottoniera);
    botDNS.setActionCommand (AZIONE_WIN_DNS);
    botPNS.addActionListener (bottoniera);
    botPNS.setActionCommand (AZIONE_WIN_PNS);
    botExpert.addActionListener (bottoniera);
    botExpert.setActionCommand (AZIONE_EXPERT);
    botClrScr.addActionListener (bottoniera);
    botClrScr.setActionCommand (AZIONE_CLRSCR);

    botLancia  .setCursor (cursoreBottone);
    botExpert  .setCursor (cursoreBottone);
    botManipola.setCursor (cursoreBottone);
    botClrScr  .setCursor (cursoreBottone);
    botDNS     .setCursor (cursoreBottone);
    botPNS     .setCursor (cursoreBottone);
    botChiudi  .setCursor (cursoreBottone);

    botLancia  .setIcon (IMG_ICO_AGENTE);
    botExpert  .setIcon (IMG_ICO_EXPERT);
    botManipola.setIcon (IMG_ICO_MANIPO);
    botClrScr  .setIcon (IMG_ICO_CLRSCR);
    botDNS     .setIcon (IMG_ICO_DNS);
    botPNS     .setIcon (IMG_ICO_PNS);
    botChiudi  .setIcon (IMG_ICO_CLOSE);
    botChiudi.setPressedIcon(IMG_ICO_ZAMPA);

    botLancia  .setHorizontalAlignment(JLabel.LEFT);
    botExpert  .setHorizontalAlignment(JLabel.LEFT);
    botManipola.setHorizontalAlignment(JLabel.LEFT);
    botClrScr  .setHorizontalAlignment(JLabel.LEFT);

    botChiudi.setVerticalTextPosition   (JButton.BOTTOM);
    botChiudi.setHorizontalTextPosition (JButton.CENTER);
    
    ListChiusura listChiusura = new ListChiusura();
    mioFrame.addWindowListener (listChiusura);
    botChiudi.addActionListener (listChiusura);

    PlaceID meMedesimo = mioActionPlace.chePlaceID();
    if (! meMedesimo.isDomain())
      if (! (meMedesimo instanceof MobilePlaceID))
        botDNS.setEnabled (false);  // Disabilita il bottone DNS se non  un place di default!

    PanCentro.setLayout (new BorderLayout());
    PanCentro.setBorder (BorderFactory.createEmptyBorder(6, 5, 3, 5));   // alto,sx,basso,dx

    testata.setBorder (BorderFactory.createEmptyBorder(0, 4, 4, 0));   // alto,sx,basso,dx
    PanCentro.add (testata, BorderLayout.NORTH);

    JPanel panInOut = new JPanel (new BorderLayout());
      JPanel panOutSpa = new JPanel (new BorderLayout());
        Component spazio = Box.createRigidArea(new Dimension(10,10));
        panOutSpa.add (scrollTextArea, BorderLayout.CENTER);
        panOutSpa.add (spazio,         BorderLayout.SOUTH);

      panInOut.add (panOutSpa,   BorderLayout.CENTER);
      panInOut.add (commandLine, BorderLayout.SOUTH);

    PanCentro.add (panInOut, BorderLayout.CENTER);

    JPanel panBottoni = new JPanel ();
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();

      panBottoni.setLayout (GBL2);

      CC2.fill = GridBagConstraints.BOTH;

      CC2.gridx = 1;   CC2.gridy = 1;
      GBL2.setConstraints (botLancia, CC2);
      panBottoni.add (botLancia);

      CC2.gridx = 1;   CC2.gridy = 2;
      GBL2.setConstraints (botManipola, CC2);
      panBottoni.add (botManipola);

      CC2.gridx = 2;   CC2.gridy = 1;
      GBL2.setConstraints (botDNS, CC2);
      panBottoni.add (botDNS);

      CC2.gridx = 2;   CC2.gridy = 2;
      GBL2.setConstraints (botPNS, CC2);
      panBottoni.add (botPNS);

      CC2.gridx = 3;   CC2.gridy = 1;
      GBL2.setConstraints (botClrScr, CC2);
      panBottoni.add (botClrScr);

      CC2.gridx = 3;   CC2.gridy = 2;
      GBL2.setConstraints (botExpert, CC2);
      panBottoni.add (botExpert);

      spazio = Box.createRigidArea(new Dimension(10,4));
      CC2.gridx = 4;   CC2.gridy = 1;
      GBL2.setConstraints (spazio, CC2);
      panBottoni.add (spazio);

      CC2.fill = GridBagConstraints.NONE;
      CC2.anchor = GridBagConstraints.SOUTH;

      if (Config.chePropBool("SliderModiFont")) {
        CC2.gridx = 5;   CC2.gridy = 1;
        CC2.gridheight = 2;
        GBL2.setConstraints (panFontDim, CC2);
        panBottoni.add (panFontDim);
        CC2.gridheight = 1;
      }

      spazio = Box.createRigidArea(new Dimension(10,4));
      CC2.gridx = 6;   CC2.gridy = 1;
      GBL2.setConstraints (spazio, CC2);
      panBottoni.add (spazio);

      CC2.gridx = 7;   CC2.gridy = 1;
      CC2.gridheight = 2;
      GBL2.setConstraints (botChiudi, CC2);
      panBottoni.add (botChiudi);

      panBottoni.setBorder (BorderFactory.createEmptyBorder(10, 0, 0, 0));   // alto,sx,basso,dx

    PanCentro.add (panBottoni, BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    Environment env = mioActionPlace.cheEnv();
    env.in  = oriIn;   // Ripristino l'Input/Output di default
    env.out = oriOut;
    env.err = oriErr;

    // Distruggo il thread, ma non sempre riesce bene.
    // Per non restare bloccato troppo a lungo, creo un thread che chiede
    // al thread di esplorazione di terminare (e rester lui in attesa!).
    if (indyJones != null) 
      if (indyJones.isAlive()) {
        ThreadGroup threadGroup = env.threadGroup;      //Prendo il gruppo definito nell'ENVIRONMENT!
        Thread killer = new Thread (threadGroup, "Killer for Explorer Thread") {
          public void run() {
/*          try {
              finIn.close();     // CHIUDO IL FLUSSO DI INPUT! PER UCCIDERLO "DOLCEMENTE"..
            }
            catch (Exception E) { System.out.println (E); }
*/
            indyJones.Stop();  //NB: con la maiuscola (non lo "stop" invalidato dal JDK1.2)
            // NOTA BENE: IN OGNI CASO QUESTO BENEDETTO "ExplorerThread" NON VUOLE MUORIRE!
            // ALL'INVOCAZIONE DELLA "Stop()" CI SI BLOCCA (PRIMITIVA SOSPENSIVA) IN ATTESA
            // DI UNA MORTE CHE MAI AVVERRA'.
            // QUINDI QUESTO THREAD MUORIRA' ALLA CHIUSURA DELLA MACCHINA VIRTUALE JAVA.
            // SPERO CHE L'UTENTE NON FACCIA TROPPE RICHIESTE DI "MODALITA' ESPERTO"!
          } //run
        }; //killer (Thread)
        killer.start();
      } //if

    super.distruggiFinestra();
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    // Crea la barra dei menu'

    Environment env = mioActionPlace.cheEnv();  // Usata da pi voci di men

    ListBottoni bottoniera = new ListBottoni(mioActionPlace, this);

    JMenuItem menuItem;
    JMenu     menuVoce, menuSub;
    JMenuBar  menuBarra = new JMenuBar();
    String    mnemoBarra, mnemoSub;
    String    spazi = "       ";   // per sicurezza

    mnemoBarra = Lingua.frase("FP_MENU_BAR_MNEMO") + spazi;  // = "PAICU" (mnemonici)

    menuVoce = new JMenu (Lingua.frase("FP_MENU_PLACE"));    // men "place"
    menuVoce.setMnemonic (mnemoBarra.charAt(0));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("FP_MENU_P_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_PLACEID"));
        menuItem.setIcon (IMG_ICO_M_PLACE);
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_PLACEID);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_WIN_DNS"));
        menuItem.setIcon (IMG_ICO_M_DNS);
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_WIN_DNS);
        PlaceID meStesso = mioActionPlace.chePlaceID();
        if (! meStesso.isDomain())
          if (! (meStesso instanceof MobilePlaceID))
          menuItem.setEnabled (false);    // Disabilita l'opzione se non  un place di default!
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_WIN_PNS"));
        menuItem.setIcon (IMG_ICO_M_PNS);
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_WIN_PNS);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_THREAD"));
        menuItem.setIcon (IMG_ICO_M_TREDPL);
        menuItem.setMnemonic (mnemoSub.charAt(3));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_PLTHREAD);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_CLRSCR"));
        menuItem.setIcon (IMG_ICO_M_CLEAR);
        menuItem.setMnemonic (mnemoSub.charAt(4));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_CLRSCR);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_CLOSE"));
        menuItem.setIcon (IMG_ICO_M_CLOSE);
        menuItem.setMnemonic (mnemoSub.charAt(5));
        menuItem.addActionListener (new ListChiusura());
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_P_EXIT"));
        menuItem.setIcon (IMG_ICO_M_EXIT);
        menuItem.setMnemonic (mnemoSub.charAt(6));
        menuItem.setAccelerator (KeyStroke.getKeyStroke(KeyEvent.VK_X, ActionEvent.CTRL_MASK));  //imposta "Ctrl-X"
        menuItem.addActionListener (new ListExit (mioFrame, this, ListExit.EXIT_SOMA));
        menuVoce.add (menuItem);


    menuVoce = new JMenu (Lingua.frase("FP_MENU_APPLET"));    // men "applet"
    menuVoce.setMnemonic (mnemoBarra.charAt(1));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("FP_MENU_L_MNEMO") + spazi;  // (mnemonici)

        menuRemoteApplet = new JCheckBoxMenuItem (Lingua.frase("FP_MENU_L_OPEN_CON"));
        menuRemoteApplet.setMnemonic (mnemoSub.charAt(0));
        menuRemoteApplet.setIcon (IMG_ICO_M_APPLT);
        menuRemoteApplet.addActionListener (bottoniera);
        menuRemoteApplet.setActionCommand (AZIONE_REM_APPLET);
        menuVoce.add (menuRemoteApplet);

        impostaVoceApplet();


    menuVoce = new JMenu (Lingua.frase("FP_MENU_MOBILITY"));    // men "MobilePlace"
    menuVoce.setMnemonic (mnemoBarra.charAt(2));
    menuBarra.add (menuVoce);
    menuVoce.setEnabled (env instanceof MobileEnvironment);

        mnemoSub = Lingua.frase("FP_MENU_M_MNEMO") + spazi;  // (mnemonici)

        menuItemConnect = new JMenuItem (Lingua.frase("FP_MENU_M_CONN_ON"));
        menuItemConnect.setIcon (IMG_ICO_M_CONNC);
        if (env instanceof MobileEnvironment) {
          PlaceID placeAtt = mioActionPlace.mobileCurrentDomainID();
          if (placeAtt != MobilePlaceManager.DISCONNECTED) {
            menuItemConnect.setText (Lingua.frase("FP_MENU_M_CONN_OFF"));
            menuItemConnect.setMnemonic (mnemoSub.charAt(1));
          }
          else
            menuItemConnect.setMnemonic (mnemoSub.charAt(0));

          menuItemConnect.addActionListener (bottoniera);
          menuItemConnect.setActionCommand (AZIONE_MOBILE_CONN);
        }
        else
          menuItemConnect.setEnabled(false);
        menuVoce.add (menuItemConnect);

    
    menuVoce = new JMenu (Lingua.frase("FP_MENU_SECURITY"));   // men "Sicurezza"
    menuVoce.setMnemonic (mnemoBarra.charAt(3));
    menuBarra.add (menuVoce);
    menuVoce.setEnabled (env instanceof SecurityEnvironment);

        mnemoSub = Lingua.frase("FP_MENU_S_MNEMO") + spazi;  // (mnemonici)

        menuCAAddress = new JMenuItem (Lingua.frase("FP_MENU_S_CAADDRESS"));
        menuCAAddress.setIcon (IMG_ICO_M_CAADDR);
        menuCAAddress.setMnemonic (mnemoSub.charAt(0));
        menuCAAddress.addActionListener (bottoniera);
        menuCAAddress.setActionCommand (AZIONE_CAADDRESS);
        menuVoce.add (menuCAAddress);

        menuVoce.addSeparator();

        menuProfileLogin = new JMenuItem (Lingua.frase("FP_MENU_S_PROLOGIN"));
        menuProfileLogin.setIcon (IMG_ICO_M_PLOGIN);
        menuProfileLogin.setMnemonic (mnemoSub.charAt(1));
        menuProfileLogin.addActionListener (bottoniera);
        menuProfileLogin.setActionCommand (AZIONE_PRO_LOGIN);
        menuVoce.add (menuProfileLogin);

        menuVoce.addSeparator();

        menuProfileLogoff = new JMenuItem (Lingua.frase("FP_MENU_S_PROLOGOFF"));
        menuProfileLogoff.setIcon (IMG_ICO_M_PLOGOF);
        menuProfileLogoff.setMnemonic (mnemoSub.charAt(2));
        menuProfileLogoff.addActionListener (bottoniera);
        menuProfileLogoff.setActionCommand (AZIONE_PRO_LOGOFF);
        menuVoce.add (menuProfileLogoff);

        menuProfileCreRec = new JMenuItem (Lingua.frase("FP_MENU_S_PROCREREC"));
        menuProfileCreRec.setIcon (IMG_ICO_M_PCRERE);
        menuProfileCreRec.setMnemonic (mnemoSub.charAt(3));
        menuProfileCreRec.addActionListener (bottoniera);
        menuProfileCreRec.setActionCommand (AZIONE_PRO_CREREC);
        menuVoce.add (menuProfileCreRec);

        menuProfileDist = new JMenuItem (Lingua.frase("FP_MENU_S_PRODIST"));
        menuProfileDist.setIcon (IMG_ICO_M_PDIST);
        menuProfileDist.setMnemonic (mnemoSub.charAt(4));
        menuProfileDist.addActionListener (bottoniera);
        menuProfileDist.setActionCommand (AZIONE_PRO_DISTIN);
        menuVoce.add (menuProfileDist);

        menuProfileChPass = new JMenuItem (Lingua.frase("FP_MENU_S_PROCHPASS"));
        menuProfileChPass.setIcon (IMG_ICO_M_PCHPAS);
        menuProfileChPass.setMnemonic (mnemoSub.charAt(5));
        menuProfileChPass.addActionListener (bottoniera);
        menuProfileChPass.setActionCommand (AZIONE_PRO_CHPASS);
        menuVoce.add (menuProfileChPass);

        menuVoce.addSeparator();

        menuPolicyCRL = new JMenuItem (Lingua.frase("FP_MENU_S_POLCRL"));
        menuPolicyCRL.setIcon (IMG_ICO_M_PCRL);
        menuPolicyCRL.setMnemonic (mnemoSub.charAt(6));
        menuPolicyCRL.addActionListener (bottoniera);
        menuPolicyCRL.setActionCommand (AZIONE_POLI_CRL);
        menuVoce.add (menuPolicyCRL);

        menuPolicyUpdate = new JMenuItem (Lingua.frase("FP_MENU_S_POLUP"));
        menuPolicyUpdate.setIcon (IMG_ICO_M_PUPD);
        menuPolicyUpdate.setMnemonic (mnemoSub.charAt(7));
        menuPolicyUpdate.addActionListener (bottoniera);
        menuPolicyUpdate.setActionCommand (AZIONE_POLI_UPDATE);
        menuVoce.add (menuPolicyUpdate);

        // ABILITAZIONE INIZIALE DELLE VOCI
        if (env instanceof SecurityEnvironment) {
          int livello = VOCE_CAADDRESS;
          ProfileManager envProfile = ((SecurityEnvironment)env).profile;
          if (envProfile == null) {
            Infrastructure pki = envProfile.getEntrustInfrastructure();
            if (pki != null) {
              if (! pki.getOnLine())
                livello = VOCE_LOGIN;  // Abilita la sola opzione di "login"
              else
                livello = VOCE_RESTANTI;  // Funzioni "restanti" (sono gia' in "login")
            }
          }
          abilitaVociSicurezza(livello);
        }

    
    menuVoce = new JMenu (Lingua.frase("FP_MENU_AGENT"));    // men "Agenti"
    menuVoce.setMnemonic (mnemoBarra.charAt(4));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("FP_MENU_A_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_A_LAUNCH"));
        menuItem.setIcon (IMG_ICO_M_AGENT);
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_LAUNCH);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_A_MANIPUL"));
        menuItem.setIcon (IMG_ICO_M_MANIP);
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_MANIPUL);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_A_POSIT"));
        menuItem.setIcon (IMG_ICO_M_POSIZ);
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_POSIT);
        menuVoce.add (menuItem);


    menuVoce = new JMenu (Lingua.frase("FP_MENU_INFO"));     // men "Informazioni"
    menuVoce.setMnemonic (mnemoBarra.charAt(5));
    menuBarra.add (menuVoce);

        mnemoSub = Lingua.frase("FP_MENU_I_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_I_LOCHOST"));
        menuItem.setIcon (IMG_ICO_M_INDIP);
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_LOCHOST);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_I_MEMORY"));
        menuItem.setIcon (IMG_ICO_M_MOON);
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_MEMORY);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_I_CALLGC"));
        menuItem.setIcon (IMG_ICO_M_GC);
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_CALLGC);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_I_THREADS"));
        menuItem.setIcon (IMG_ICO_M_TREDAL);
        menuItem.setMnemonic (mnemoSub.charAt(3));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_ALLTHREAD);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_I_PROPER"));
        menuItem.setIcon (IMG_ICO_M_PROP);
        menuItem.setMnemonic (mnemoSub.charAt(4));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_PROPER);
        menuVoce.add (menuItem);


    menuVoce = new JMenu (Lingua.frase("FP_MENU_CONFIG"));   // men "Configurazione"
    menuVoce.setMnemonic (mnemoBarra.charAt(6));
    menuBarra.add (menuVoce);

        menuSub = LinguaGui.menuSceltaLingua(mioFrame);      // sotto-menu' "lingua"
        menuVoce.add (menuSub);

        menuSub = Apparenza.menuSceltaApparenza(mioFrame);   // sotto-menu' "apparenza"
        menuVoce.add (menuSub);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_C_OPTION"));
        menuItem.setIcon (IMG_ICO_M_OPZIO);
        menuItem.addActionListener (new ActionListener() {
                                      public void actionPerformed (ActionEvent e) {
                                        FinOpzioni fin = new FinOpzioni();
                                      }
                                    });
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        mnemoSub = Lingua.frase("FP_MENU_C_MNEMO") + spazi;  // (mnemonici)

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_C_AGEPATH"));
        menuItem.setToolTipText (mioActionPlace.cheAgentPath());
        menuItem.setMnemonic (mnemoSub.charAt(0));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_AGENTPATH);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_C_CACPATH"));
        menuItem.setToolTipText (mioActionPlace.cheCachePath());
        menuItem.setMnemonic (mnemoSub.charAt(1));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_CACHEPATH);
        menuVoce.add (menuItem);

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_C_DELCACH"));
        menuItem.setIcon (IMG_ICO_M_CLCACH);
        menuItem.setMnemonic (mnemoSub.charAt(2));
        menuItem.addActionListener (bottoniera);
        menuItem.setActionCommand (AZIONE_DELCACHE);
        menuVoce.add (menuItem);

        menuVoce.addSeparator();

        menuCheckExpert = new JCheckBoxMenuItem (Lingua.frase("FP_MENU_C_EXPERT"));
        menuCheckExpert.setIcon (IMG_ICO_M_EXPERT);
        menuCheckExpert.setState (modoEsperto);
        menuCheckExpert.setMnemonic (mnemoSub.charAt(3));
        menuCheckExpert.addActionListener (bottoniera);
        menuCheckExpert.setActionCommand (AZIONE_EXPERT);
        menuVoce.add (menuCheckExpert);

        menuVoce.addSeparator();

        menuItem = new JMenuItem (Lingua.frase("FP_MENU_C_ADVCFG"));
        menuItem.setIcon (IMG_ICO_M_ADVCFG);
        menuItem.setMnemonic (mnemoSub.charAt(4));
        menuItem.addActionListener (new ActionListener() {
                      public void actionPerformed(ActionEvent e) {
                        // Se esiste gi un AdvConfig aperta a video,
                        if (AdvConfig.esisteFinAperta()) {
                          AdvConfig vecchiaFin = AdvConfig.rendiFinAperta();
                          vecchiaFin.inPrimoPiano();
                        }
                        else {  // Altrimenti ne crea una nuova
                          AdvConfig nuovaFin = new AdvConfig ();
                          // NB: user l'Anagrafe con cui fu creata
                          // precedentemente la finestra stessa.
                        }
                      }
        });
        menuVoce.add (menuItem);

    menuBarra.add (Box.createHorizontalGlue());              // aggiunge della colla

    menuVoce = new JMenu (Lingua.frase("FP_MENU_HELP"));     // men "Aiuto"
    menuVoce.setMnemonic (mnemoBarra.charAt(7));
    menuBarra.add (menuVoce);

      mnemoSub = Lingua.frase("FP_MENU_H_MNEMO") + spazi;  // (mnemonici)

      menuItem = new JMenuItem (Lingua.frase("FP_MENU_H_ABOUT"));
      menuItem.setIcon (IMG_ICO_M_HELP);
      menuItem.setMnemonic (mnemoSub.charAt(0));
      menuItem.addActionListener ( new ActionListener() {
                                     public void actionPerformed(ActionEvent e) {
                                       FinAbout fin = new FinAbout(mioFrame);
                                   }} );
      menuVoce.add (menuItem);

    // Definisco la barra (ATTENZIONE: al JFrame!)
    mioFrame.setJMenuBar (menuBarra);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       */
  protected void impostaFrasi () {
    botLancia   .setText (Lingua.frase("FP_BOT_LAUNCH"));
    botManipola .setText (Lingua.frase("FP_BOT_MANIPUL"));
    botDNS      .setText (Lingua.frase("FP_BOT_WIN_DNS"));
    botPNS      .setText (Lingua.frase("FP_BOT_WIN_PNS"));
    if (modoEsperto)
      botExpert .setText (Lingua.frase("FP_BOT_BASIC"));    // Stampa la scritta OPPOSTA!
    else {
      botExpert .setText (Lingua.frase("FP_BOT_EXPERT"));
      commandLine.setText(Lingua.frase("FP_CL_DISAB"));
    }
    botClrScr   .setText (Lingua.frase("FP_BOT_CLRSCR"));
    botChiudi   .setText (Lingua.frase("FP_BOT_CLOSE"));
    

    botLancia  .setToolTipText (Lingua.frase("FP_TIP_LAUNCH"));
    botManipola.setToolTipText (Lingua.frase("FP_TIP_MANIP"));
    botDNS     .setToolTipText (Lingua.frase("FP_TIP_DNS"));
    botPNS     .setToolTipText (Lingua.frase("FP_TIP_PNS"));
    if (modoEsperto)
      botExpert.setToolTipText (Lingua.frase("FP_TIP_BASIC"));
    else
      botExpert.setToolTipText (Lingua.frase("FP_TIP_EXPERT"));
    botClrScr  .setToolTipText (Lingua.frase("FP_TIP_CLRSCR"));
    botChiudi  .setToolTipText (Lingua.frase("FP_TIP_CLOSE"));
    testata    .setToolTipText (Lingua.frase("FP_TIP_TESTATA")+
                                mioActionPlace.chePlaceID().toString());

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Interna,  l'effetto del tasto "esperto/base".
       *  Crea un "ExplorerThread" collegato in input al TextField e in output alla TextArea.
       *  Tale thread  creato una sola volta alla prima commutazione in modalit "esperto" e
       *  rimosso alla chiusura della finestra.
       *  Il TextField viene abilitato/disabilitato a seconda della modalit in cui si .
       */
  protected void attivaModalitaEspertoBase (boolean modoEsperto) {
    // CREO UN THREAD "ExplorerThread" (che ha l'input da finIn e output su finOut)
    // Ma solo se non ne ho gi creato uno.
    if (modoEsperto && (indyJones == null)) {
      Environment env = mioActionPlace.cheEnv();
      ThreadGroup threadGroup = env.threadGroup;      //Prendo il gruppo definito nell'ENVIRONMENT!
      DirExplorerItem dir = Creatore.cheRootDir();
      indyJones = new ExplorerThread (threadGroup, dir, finIn, finOut, true);  //true=EchoOn
      indyJones.start();
    }

    if (menuCheckExpert != null)
      menuCheckExpert.setState (modoEsperto);
    if (modoEsperto) {          // Stampa la scritta OPPOSTA al "modo" coorente!
      commandLine.setEditable(true); // Abilita barra
      botExpert.setText (Lingua.frase("FP_BOT_BASIC"));
      commandLine.setText ("");
    }
    else {
      commandLine.setEditable(false); // Disabilita barra
      botExpert.setText (Lingua.frase("FP_BOT_EXPERT"));
      commandLine.setText (Lingua.frase("FP_CL_DISAB"));
    }
    mioFrame.invalidate();
  } //attivaModalitaEspertoBase

      /**
       *  Interna,  l'effetto del tasto "connessioni con applet ON/OFF".
       *  Pone in "ON" o "OFF" lo "SportelloRichieste".
       */
  protected void commutaConnessioniApplet () {
    Environment env = mioActionPlace.cheEnv();
    SportelloRichieste sportello = env.sportelloRichieste;
    Object statoAtt = sportello.getStatus();

    try {
  
      if (statoAtt == SportelloRichieste.ON)  // Se  ON, commuta in OFF
      
        sportello.stop ();

      else {

        FinStartApplet fin = new FinStartApplet (FinestraPlace.this, sportello);
        // questa finestra invocher il metodo seguente: "avviaConnessioniApplet()"
      }

    }
    catch (Exception e) { }

    impostaVoceApplet ();

  } //commutaConnessioniApplet

      /**
       *  Viene chiamata da "FinStartApplet"
       */
  public void avviaConnessioniApplet (SportelloRichieste sportello, int numPorta) throws Exception {
    // Viene chiamata da "FinStartApplet"

    Debug.outln ("FinestraPlace - aprendo connessioni con Applet su porta "+numPorta);

    sportello.defPorta (numPorta);

    // Prova a creare la socket: se non riesce genera eccezione
    ServerSocket serSock = new ServerSocket (numPorta,5);
    serSock.setSoTimeout(1);
    try {
      Socket cliSock = serSock.accept();  // Testo se posso farlo.
      cliSock.close();
    }
    catch (java.io.InterruptedIOException eheheh) {
      // se si interrompe, tutto ok
    }
    catch (Exception eccezzzzione) {
      throw eccezzzzione;  // Rigenero l'eccezione all'esterno
    }
    finally {
      try {
        serSock.close();
      }
      catch (Exception e) { }
    }

    sportello.start ();

    impostaVoceApplet();
  } //avviaConnessioniApplet

      /**
       *  Interna, serve per far scegliere all'utente una directory da usare.
       */
  protected String scegliDirectory (String dirAttuale) {
    JFileChooser scegli = new JFileChooser();
    scegli.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);

    File dir = new File (dirAttuale);
    scegli.setCurrentDirectory (dir);
    scegli.changeToParentDirectory();
    scegli.setSelectedFile (dir);
    scegli.setDialogTitle(Lingua.frase("FP_DIA_DIR"));
    int scelta = scegli.showDialog (mioFrame, Lingua.frase("FP_DIA_BOT"));

    if (scelta == JFileChooser.APPROVE_OPTION)
      return scegli.getSelectedFile().getAbsolutePath();
    else
      return dirAttuale;
  } //scegliDirectory

      /**
       *  Interna, serve per far impostare la nuova dimensione del font delle zone di testo.
       */
  protected void impostaFontTxt (final int nuovaDim) {
    SwingUtilities.invokeLater (new Runnable () {
      public void run () {
        Config.modifPropInt (CONFIG_TXT_DIM, nuovaDim);
        Font txtFont = new Font ("DialogInput", Font.PLAIN, nuovaDim);
        textArea.setFont (txtFont);
        commandLine.setFont (txtFont);
      } //run
    }); //invokeLater
  } //impostaFontTxt

      /**
       *  Abilita lo stato della voce delle comunicazioni con le applet
       */
  public void impostaVoceApplet () {
    SwingUtilities.invokeLater (new Runnable () {
      public void run () {
        Environment env = mioActionPlace.cheEnv();
        Object statoAtt = env.sportelloRichieste.getStatus();

        boolean aperte = statoAtt == SportelloRichieste.ON;
        menuRemoteApplet.setState (aperte);
        if (aperte)
          menuRemoteApplet.setText (Lingua.frase("FP_MENU_L_CLOSE_CON"));
        else
          menuRemoteApplet.setText (Lingua.frase("FP_MENU_L_OPEN_CON"));

        mioFrame.invalidate();
      } //run
    }); //invokeLater
  } //impostaVoceApplet

      /**
       *  Abilita lo stato delle voci di men della sicurezza;
       *  Si deve passare una delle costanti "VOCE_XXX":
       *  VOCE_CAADDRESS = CAAddress
       *  VOCE_LOGIN     = Login
       *  VOCE_RESTANTI  = le restanti opzioni di Profilo
       */
  public void abilitaVociSicurezza (final int codiceAbilitazione) {
    SwingUtilities.invokeLater (new Runnable () {
      public void run () {
        menuCAAddress.setEnabled (codiceAbilitazione == VOCE_CAADDRESS);
        menuProfileLogin.setEnabled (codiceAbilitazione == VOCE_LOGIN);
        boolean altre = (codiceAbilitazione == VOCE_RESTANTI);
        menuProfileLogoff.setEnabled (altre);
        menuProfileCreRec.setEnabled (altre);
        menuProfileDist  .setEnabled (altre);
        menuProfileChPass.setEnabled (altre);
        menuPolicyCRL    .setEnabled (altre);
        menuPolicyUpdate .setEnabled (altre);
      } //run
    }); //invokeLater

    // Riperquote il tutto sul MENU A LINEA DI COMANDO:
    DirExplorerItem placeDir = chePlaceDir();
    Environment env = mioActionPlace.cheEnv();
    ProfileManager profile = ((SecurityEnvironment)env).profile;
    switch (codiceAbilitazione) {
      case VOCE_CAADDRESS: { break; }
      case     VOCE_LOGIN: { String newKey = "ProfileLogon";
                             placeDir.addItem(newKey,
                                              new ProfileLoginExplorerItem(profile, newKey, placeDir));
                             placeDir.removeItem("CA_address");
                             break; 
                           }
      case  VOCE_RESTANTI: { String newKey = "ProfileManager";
                             placeDir.addItem(newKey, new ProfileExplorerItem(newKey, profile , placeDir));
                             // Crea automaticamente la sottodir. "UpdatePolicy"
                             placeDir.removeItem("ProfileLogon");
                             break;
                           }
    } //switch
  } //abilitaVociSicurezza

      /**
       *  Rende il riferimento al "direttorio" del men corrispondente al
       *  Place passato (accede a "rootDir" di Creatore).
       */
  public DirExplorerItem chePlaceDir () {
    PlaceID placeID = mioActionPlace.chePlaceID();
    return Creatore.chePlaceDir (placeID);
  } //chePlaceDir

      /**
       *  Apre finestra con CRL (sicurezza).
       */
  public void apriFinCRL (ProfileManager profile) {
    JTextArea miaArea = new JTextArea (15,80);
    miaArea.setFont (new Font("DialogInput", Font.PLAIN, 11));
    miaArea.setEditable(false);
    miaArea.append (Lingua.frase("FP_FIN_CRL")+"\n");
    
    boolean fatto = false;
    if (profile != null) {
      Infrastructure pki = profile.getEntrustInfrastructure();
      if (pki != null) {
        CertificateCRLList CRLs = pki.getCertificateCRLList();
        if (CRLs != null) {
          Enumeration[] enCRL = CRLs.listRevockedCertificates();
          if (enCRL != null) {
            fatto = true;
            for (int i=0; i<enCRL.length; i++)
              while (enCRL[i].hasMoreElements())
                miaArea.append (enCRL[i].nextElement().toString()+"\n");
          }
        }
      }
    }
    if (! fatto)
      miaArea.append (Lingua.frase("FP_FIN_CRL_NONO"));

    FinConContainer finProp = new FinConContainer (miaArea, Lingua.frase("FP_FIN_CRL"));
  } //apriFinCRL


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni implements ActionListener {

    protected ActionPlace   actionPlace;
    protected FinestraPlace finestraPlace;

    public ListBottoni (ActionPlace actionPlace, FinestraPlace finestraPlace) {
      this.actionPlace   = actionPlace;
      this.finestraPlace = finestraPlace;
    } //costruttore

    public void actionPerformed (ActionEvent e) {

      final String azione = e.getActionCommand();   // PRELEVO L'AZIONE DA ESEGUIRE

      try {
        if (azione.equals(AZIONE_PLACEID)) {
          PlaceID placeID = actionPlace.chePlaceID();        //NB: CHIEDO ALL'ActionPlace E POI IL RISULTATO
          FinPlaceInfo fin = new FinPlaceInfo (placeID);     //    LO VISUALIZZO IN UNA FINESTRA "SPECIALE"!
        }
        else if (azione.equals(AZIONE_WIN_DNS)) {
          Environment env = actionPlace.cheEnv();
          // Crea modello DNS - con finestra (con tutti i bottoni)!
          ModelloDNS modDNS = new ModelloDNS (env, FinestraXNS.MODIFICABILE);
        }
        else if (azione.equals(AZIONE_WIN_PNS)) {
          Environment env = actionPlace.cheEnv();
          // Crea modello PNS - con finestra (con tutti i bottoni)!
          ModelloPNS modPNS = new ModelloPNS (env, FinestraXNS.MODIFICABILE);
        }
        else if (azione.equals(AZIONE_PLTHREAD)) {
          DefaultTreeModel modelloThread = actionPlace.alberoPlaceThread ();
          FinThread fin = new FinThread (modelloThread);
        }
        else if (azione.equals(AZIONE_REM_APPLET)) {
          commutaConnessioniApplet ();
        }
        else if (azione.equals(AZIONE_CLRSCR)) {
          textArea.setText("");
        }
        else if (azione.equals(AZIONE_LAUNCH)) {
          LancioAgente LA = new LancioAgente (actionPlace, finestraPlace);
        }
        else if (azione.equals(AZIONE_MANIPUL)) {
          Environment env = actionPlace.cheEnv();
          ManipolaAgenti fin = new ManipolaAgenti (env);
        }
        else if (azione.equals(AZIONE_POSIT)) {
          Environment env = actionPlace.cheEnv();
          PosizioneAgenti fin = new PosizioneAgenti (env);
        }
        else if (azione.equals(AZIONE_LOCHOST)) {
          InetAddress indLocale = actionPlace.indirizzoLocale();
          boolean errUnk = (indLocale == null);
          FinLocalHost fin = new FinLocalHost (indLocale, errUnk);
        }
        else if (azione.equals(AZIONE_MEMORY)) {
          long memTotale = actionPlace.memTotale();
          long memLibera = actionPlace.memLibera();
          long memUsata  = actionPlace.memUsata();
          FinMemory fin = new FinMemory (memTotale, memLibera, memUsata);
        }
        else if (azione.equals(AZIONE_CALLGC)) {
          actionPlace.chiamaGarbageCollector ();
          OiDialogoi.mostraMessaggio (Lingua.frase("FP_FIN_GC_CALLED"), mioFrame);
        }
        else if (azione.equals(AZIONE_ALLTHREAD)) {
          DefaultTreeModel modelloThread = actionPlace.alberoAllThread ();
          FinThread fin = new FinThread (modelloThread);
        }
        else if (azione.equals(AZIONE_PROPER)) {
          final Properties prop = actionPlace.cheProprieta ();
          SwingUtilities.invokeLater (new Runnable () {
                  public void run () {

                      JTextArea miaArea = new JTextArea (15,80);
                      miaArea.setFont (new Font("DialogInput", Font.PLAIN, 11));
                      miaArea.setEditable(false);
                      TextAreaOutputStream2 myOut = new TextAreaOutputStream2 (miaArea);

                      PrintWriter printer = new PrintWriter (myOut, true);  // true=autoFlush
                      prop.list(printer);
                      FinConContainer finProp = new FinConContainer (miaArea, Lingua.frase("FP_FIN_PROP"));

                  } //run
          }); //invokeLater
        }
        else if (azione.equals(AZIONE_AGENTPATH) ||
                 azione.equals(AZIONE_CACHEPATH)   ) {
                    SwingUtilities.invokeLater (new Runnable () {
                            public void run () {
                              String dirAtt;
                              if (azione.equals(AZIONE_AGENTPATH))
                                dirAtt = actionPlace.cheAgentPath();
                              else
                                dirAtt = actionPlace.cheCachePath();
                              String dirCam = scegliDirectory (dirAtt);
                              if (! dirAtt.equals(dirCam))
                                try {
                                  if (azione.equals(AZIONE_AGENTPATH))
                                    actionPlace.defAgentPath(dirCam);
                                  else
                                    actionPlace.defCachePath(dirCam);
                                }
                                catch (Exception E) {
                                  Exception E2 = new Exception(Lingua.frase("FP_ERR_CH_DIR")+": "+dirCam);
                                  OiDialogoi.mostraErrore (E2, mioFrame);
                                }
                            } //run
                    }); //invokeLater
        }
        else if (azione.equals(AZIONE_DELCACHE)) {
          Thread esecutore = new Thread ("Cache Eraser") {
              public void run() {
                actionPlace.cancellaCache();   // Cancello la cache (in background)
              } //run
          }; //esecutore (Thread)
          esecutore.start();
          OiDialogoi.mostraMessaggio (Lingua.frase("FP_FIN_CACHE_CANC"), mioFrame);
        }
        else if (azione.equals(AZIONE_EXPERT)) {
          modoEsperto = ! modoEsperto;
          attivaModalitaEspertoBase (modoEsperto);
        }
        else if (azione.equals(AZIONE_MOBILE_CONN)) {  // CONNECT/DISCONNECT
          PlaceID placeAtt = actionPlace.mobileCurrentDomainID();
          if (placeAtt == MobilePlaceManager.DISCONNECTED) {
            menuItemConnect.setText (Lingua.frase("FP_MENU_M_CONN_OFF"));
            FinConnect finC = new FinConnect(FinestraPlace.this, mioActionPlace);
            // SARA' LA FINESTRA A FARE LE AZIONI SULL'ActionPlace
          }
          else {  //  connesso
            menuItemConnect.setText (Lingua.frase("FP_MENU_M_CONN_ON"));
            mioActionPlace.mobileDisconnect ();
          }
        }
        else if (azione.equals(AZIONE_CAADDRESS)  ||    // CA-ADDRESS
                 azione.equals(AZIONE_PRO_LOGIN)  ||    // PROFILE LOGIN
                 azione.equals(AZIONE_PRO_LOGOFF) ||    // PROFILE LOGOFF
                 azione.equals(AZIONE_PRO_CREREC) ||    // PROFILE CREATE/RECOVER
                 azione.equals(AZIONE_PRO_DISTIN) ||    // PROFILE DISTINGUISH
                 azione.equals(AZIONE_PRO_CHPASS) ||    // PROFILE CAMBIO PASSWORD
                 azione.equals(AZIONE_POLI_CRL)   ||
                 azione.equals(AZIONE_POLI_UPDATE)  ) { // PROFILE MOSTRA CRL

          Environment env = actionPlace.cheEnv();
          if (env instanceof SecurityEnvironment) {
            ProfileManager profile = ((SecurityEnvironment)env).profile;

            Finestra fin;
            if (azione.equals(AZIONE_CAADDRESS))          // CA-ADDRESS
              fin = new FinCAAddress (finestraPlace, profile);

            else if (azione.equals(AZIONE_PRO_LOGIN))     // PROFILE LOGIN
              fin = new FinProfileLogin (finestraPlace, profile);

            else if (azione.equals(AZIONE_PRO_LOGOFF))    // PROFILE LOGOFF
              fin = new FinProfileLogoff (finestraPlace, profile);

            else if (azione.equals(AZIONE_PRO_CREREC))    // PROFILE CREATE/RECOVER
              fin = new FinProfileCreRec (finestraPlace, profile);

            else if (azione.equals(AZIONE_PRO_DISTIN))    // PROFILE DISTINGUISH
              fin = new FinProfileDisting (profile);
        
            else if (azione.equals(AZIONE_PRO_CHPASS))   // PROFILE CAMBIO PASSWORD
              fin = new FinProfileChPass (finestraPlace, profile);

            else if (azione.equals(AZIONE_POLI_CRL))     // POLICY MOSTRA CRL
              finestraPlace.apriFinCRL (profile);

            else if (azione.equals(AZIONE_POLI_UPDATE)) {  // POLICY FINESTRA UPDATE
              DirExplorerItem dirPlace   = chePlaceDir();
              // System.out.println("1 - "+dirPlace.toString());
              DirExplorerItem dirUpdate1 = (DirExplorerItem) dirPlace.getItem ("UpdatePolicy");
              // System.out.println("2 - "+dirUpdate1.toString());
              PolicyUpdateItem dirUpdate2 = (PolicyUpdateItem) dirUpdate1.getItem ("UpdatePolicy");
              // System.out.println("3 - "+dirUpdate2.toString());
              // IO ODIO QUESTO MENU!
              UpdateDaemon updateDaemon  = dirUpdate2.getUpdateDaemon();
              fin = new FinPolicyUpdate (finestraPlace, profile, updateDaemon);
            }

          } //if SecurityEnvironment
        }
        else
          System.err.println ("ERROR: UNKNOWN ACTION '"+azione+"'");

      }
      catch (Exception eccezione) {
        OiDialogoi.mostraErrore (eccezione, mioFrame);
      }

    } //actionPerformed
  } //ListBottoni

      /**
       *  CLASSE INTERNA PER ASCOLTARE LA CHIUSURA DELLA FINESTRA.
       *  NON VOGLIO CHE SI INVOCHI LA "distruggiFinestra" da qui, poich
       *  deve farlo l'oggetto {@link SOMA.gui.ActionPlace} proprietario della finestra
       *  e "ricordarsi" che l'ha chiusa!
       */
  class ListChiusura extends WindowAdapter implements ActionListener {

    public void windowClosing (WindowEvent e)   {
      Uccidimi();
    } //windowClosing
    
    public void actionPerformed (ActionEvent e) {
      Uccidimi();
    } //actionPerformed

    protected void Uccidimi () {
      try {
        // FACCIO AGIRE IL "MODELLO" (l'ActionPlace) che chiamer la "distruggiFinestra()".
        mioActionPlace.stop();
      }
      catch (Exception E) { }
    } //Uccidimi
  } //ListChiusura

} //FinestraPlace