/**  FinThread
 *     Finestra per mostrare l'albero con l'elenco ti tutti i thread.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.DefaultTreeCellRenderer;


public class FinThread extends Finestra {

      /**
       *  Oggetti passati al costruttore
       */
  protected DefaultTreeModel mioTreeModel;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labThread;
  protected JButton    botOk;

      /**
       *  Costruisce e mostra la finestra della traccia dello stack.
       */ 
  public FinThread (DefaultTreeModel mioTreeModel) {
    super (50, 50);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE (Finestra!)
    this.mioTreeModel = mioTreeModel;

    costruisciFinestra();
  } //costruttore

  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labThread = new JLabel ();
    botOk     = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botOk.setCursor (cursoreBottone);
    botOk.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botOk.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    PanCentro.setLayout (new BorderLayout());

    JTree albero = new JTree (mioTreeModel);
    albero.getSelectionModel().setSelectionMode (TreeSelectionModel.SINGLE_TREE_SELECTION);
    albero.setShowsRootHandles (true);

    // CAMBIO LE PROPRIETA' DI DEFAULT DEL JTree CREATO
    albero.putClientProperty("JTree.lineStyle", "Angled");
    albero.setScrollsOnExpand (true);

    // DEFINISCO IL "RENDERER" DEL JTree CREATO (disegno icone diverse)
    DefaultTreeCellRenderer myRenderer = new DefaultTreeCellRenderer();
    myRenderer.setClosedIcon (new ImageIcon(Finestra.PICTURE_PATH+"ThreadVari.gif"));
    myRenderer.setOpenIcon   (new ImageIcon(Finestra.PICTURE_PATH+"ThreadSolo.gif"));
    myRenderer.setLeafIcon   (new ImageIcon(Finestra.PICTURE_PATH+"ThreadSolo.gif"));
    myRenderer.setFont (new Font("DialogInput", Font.PLAIN, 12));
    albero.setCellRenderer (myRenderer);

    // Creo il JScrollPane in cui inserisco l'albero
    JScrollPane alberoScorrevole = new JScrollPane (albero);
    Dimension dim = new Dimension(600,400);
    alberoScorrevole.setMinimumSize (dim);
    alberoScorrevole.setPreferredSize (dim);

    PanCentro.add (alberoScorrevole, BorderLayout.CENTER);

    PanCentro.add (labThread, BorderLayout.NORTH);

    JPanel pannOkkia = new JPanel ();
    pannOkkia.add (botOk);
    PanCentro.add (pannOkkia, BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FTHR_WIN_TITLE"));

    labThread.setText (Lingua.frase("FTHR_TXT_INFO"));

    botOk.setText (Lingua.frase("FTHR_BOT_OK"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

} //FinThread