/**  FinStartApplet
 *     Una finestrella tramite cui inserire il numero di porta a cui
 *     connettere lo SportelloRichieste per le comunicazioni con le applet remote.
 *     @author     Luigi Antenucci
 *     @version    1.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.gui.remotegui.SportelloRichieste;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class FinStartApplet extends Finestra {

  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraPlace      finestraPlace;
  protected SportelloRichieste sportelloRichieste;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel       labSpiega;
  protected JTextField   txtPorta;
  protected JButton      botOK, botKO;


      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinStartApplet (FinestraPlace finestraPlace, SportelloRichieste sportelloRichieste) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace  = finestraPlace;
    this.sportelloRichieste = sportelloRichieste;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega     = new JLabel ();

    txtPorta = new JTextField (8);
    int nPorta = sportelloRichieste.chePorta();
    txtPorta.setText (String.valueOf(nPorta));
    botOK = new JButton ();
    botKO = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botOK.setCursor (cursoreBottone);
    botOK.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botOK.addActionListener (bottoniera);
    botOK.setActionCommand("ok");
    botKO.setCursor (cursoreBottone);
    botKO.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO.addActionListener (bottoniera);
    botKO.setActionCommand("cancel");
    botKO.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    txtPorta.setActionCommand("ok");
    txtPorta.addActionListener (bottoniera);    // PRESSIONE "INVIO" SU TextField

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    JPanel panTxt = new JPanel();
    panTxt.add(txtPorta);
    panTxt.setBorder (BorderFactory.createEmptyBorder(10, 40, 15, 0));   // alto,sx,basso,dx
    CC.gridx = 1;   CC.gridy = 9;
    GBL.setConstraints (panTxt, CC);
    PanCentro.add (panTxt);

    CC.fill = GridBagConstraints.VERTICAL;

    CC.gridx = 1;   CC.gridy = 11;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botOK, CC);
    PanCentro.add (botOK);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 11;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FSTAPP_WINTITLE"));

    labSpiega.setText (Lingua.frase("FSTAPP_SPIEGAZ"));

    botOK.setText (Lingua.frase("FSTAPP_BOT_START"));
    botKO.setText (Lingua.frase("FSTAPP_BOT_CANC"));

    botOK     .setToolTipText (Lingua.frase("FSTAPP_TIP_OK"));
    botKO     .setToolTipText (Lingua.frase("FSTAPP_TIP_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("ok")) {

        // PRELEVA I DATI DAL PANNELLO:
        try {

         int portaN;
         try {
            String campoTxt = txtPorta.getText();
            portaN = Integer.parseInt (campoTxt);
            if ((portaN < 1024) || (portaN > 65535))
              throw new Exception ("CheCheCheCheBauBauBau");
          }
          catch (Exception ecc) {
            throw new Exception (Lingua.frase("FSTAPP_ERR_WRONG_NUMBER"));
          }

          // lo "start" viene fatto richiamando la finestraPlace
          finestraPlace.avviaConnessioniApplet(sportelloRichieste, portaN);

          // Se tutto ok, distruggo questa finestra
          distruggiFinestra();

        }
        catch (Exception eccezione) {
          OiDialogoi.mostraErrore (eccezione, mioFrame);    // STAMPA L'ECCEZIONE GENERATA!
        }
      }
      else
        // Altrimenti, distruggo questa finestra!
        distruggiFinestra();
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

} //FinStartApplet