/**  FinPutPlace
 *     Una finestrella tramite cui inserire i dati per un D/P-NS.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.PlaceID;
import SOMA.naming.place.PlaceInfo;
import SOMA.naming.domain.DomainInfo;

import java.net.InetAddress;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class FinPutPlace extends Finestra {

  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraXNS finestraXNS;
  protected ModelloXNS  modelloXNS;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labSpiega;
  protected PanLocRem  panLocRem;
  protected JButton    botOK, botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinPutPlace (FinestraXNS finestraXNS, ModelloXNS modelloXNS) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraXNS = finestraXNS;
    this.modelloXNS  = modelloXNS;
    if (finestraXNS != null)
      finestraXNS.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega = new JLabel ();

    PlaceID placeID = modelloXNS.perChePlace ();

    if (modelloXNS instanceof ModelloDNS)                        // input di un DOMINIO per il DNS (senza "locale")
      panLocRem = new PanLocRem (PanLocRem.PAN_LOC_REM_DOM);
    else                                                         // e input di un place per il PNS (senza "locale")
      panLocRem = new PanLocRem (PanLocRem.PAN_LOC_REM_ALL);

    botOK = new JButton ();
    botKO = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni(this, finestraXNS);

    botOK.setCursor (cursoreBottone);
    botOK.setIcon (new ImageIcon(PICTURE_PATH+"CartInserisci.gif"));
    botOK.addActionListener (bottoniera);
    botOK.setActionCommand("ok");
    botKO.setCursor (cursoreBottone);
    botKO.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO.addActionListener (bottoniera);
    botKO.setActionCommand("cancel");
    botKO.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (panLocRem, CC);
    PanCentro.add (panLocRem);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.fill = GridBagConstraints.VERTICAL;

    CC.gridx = 1;   CC.gridy = 10;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botOK, CC);
    PanCentro.add (botOK);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panLocRem.distruggimi();

    super.distruggiFinestra();

    if (finestraXNS != null) {
      finestraXNS.abilitaFinestra();
      finestraXNS.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPP_WINTITLE"));

    labSpiega.setText (Lingua.frase("FPP_SPIEGAZ"));

    botOK.setText (Lingua.frase("FPP_BOT_PUT"));
    botKO.setText (Lingua.frase("FPP_BOT_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected FinPutPlace miaFinPutPlace;
    protected FinestraXNS miaFinestraXNS;

    public ListBottoni (FinPutPlace miaFinPutPlace, FinestraXNS miaFinestraXNS) {
      this.miaFinPutPlace = miaFinPutPlace;
      this.miaFinestraXNS = miaFinestraXNS;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("ok")) {

        // PRELEVA I DATI DAL PANNELLO:
        String domNome    = panLocRem.cheNomePlace();  // Rende un place o un place di default: tutto ok!
        String regAddr    = panLocRem.cheIndirIP();
        String regPorta   = panLocRem.chePorta();

        try {
          if (domNome.equals("")) throw new Exception (Lingua.frase("FPP_ERR_PLA_EMPTY"));
          PlaceID placeID;
          try {
            placeID = new PlaceID (domNome);
          }
          catch (Exception E) { throw new Exception (Lingua.frase("FPP_ERR_PLA_SYNTAX")); }

          if (regAddr.equals("")) throw new Exception (Lingua.frase("FPP_ERR_ADD_EMPTY"));
          InetAddress indIP;
          try {
            indIP = InetAddress.getByName (regAddr);
          }
          catch (Exception E) { throw new Exception (Lingua.frase("FPP_ERR_ADD_UNKNOW")); }

          int porta;

          try {
            porta = Integer.parseInt(regPorta);
          }
          catch (Exception E) { throw new Exception (Lingua.frase("FPP_ERR_PPOR_MALF")); }

          if (porta < 1024)   throw new Exception (Lingua.frase("FPP_ERR_PPRO_1024"));
          if (porta > 65535)  throw new Exception (Lingua.frase("FPP_ERR_PPRO_64K"));

          Object infoRese;
          if (modelloXNS instanceof ModelloDNS) {
            if (! placeID.isDomain()) throw new Exception (Lingua.frase("FPP_ERR_NEED_DOM"));
            infoRese = new DomainInfo (placeID, indIP, porta);  // PER CHI SONO I DATI?
          }
          else
            infoRese = new PlaceInfo (placeID, indIP, porta);

          // ESEGUE L'AZIONE SULLA FINESTRA XNS PASSANDO LE "infoRese":
          miaFinestraXNS.eseguiAzionePut (infoRese);  // NB: invoca la finestra che invocher il modello!

          // Se tutto ok, distruggo questa finestra
          miaFinPutPlace.distruggiFinestra();
        }
        catch (Exception eccezione) {
          OiDialogoi.mostraErrore (eccezione, mioFrame);
        }
      }
      else
        // Altrimenti, distruggo questa finestra!
        miaFinPutPlace.distruggiFinestra();
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      miaFinPutPlace.distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

} //FinPutPlace