/**  FinProfileLogoff
 *     Una finestrella tramite cui chiedere e fare il "logoff"
 *     @author     Luigi Antenucci
 *     @version    1.3
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.security.infrastructure.ProfileManager;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class FinProfileLogoff extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_LOGOFF    = "Logoffete";
  protected static final  String AZIONE_CANCEL    = "Annulla";


  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraPlace  finestraPlace;
  protected ProfileManager profile;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel       labSpiega;
  protected JButton      botLogoff,
                         botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinProfileLogoff (FinestraPlace finestraPlace, ProfileManager profile) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.profile       = profile;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega = new JLabel ();

    botLogoff = new JButton ();
    botKO     = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botLogoff.setCursor (cursoreBottone);
    botKO   .setCursor (cursoreBottone);

    botLogoff    .setCursor (cursoreBottone);
    botLogoff    .setIcon (new ImageIcon(PICTURE_PATH+"ProfLogoff.gif"));
    botLogoff    .addActionListener (bottoniera);
    botLogoff    .setActionCommand(AZIONE_LOGOFF);
    botKO        .setCursor (cursoreBottone);
    botKO        .setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO        .addActionListener (bottoniera);
    botKO        .setActionCommand(AZIONE_CANCEL);
    botKO        .setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.anchor = GridBagConstraints.CENTER;

    CC.gridx = 1;   CC.gridy = 1;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.fill   = GridBagConstraints.VERTICAL;
    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botLogoff, CC);
    PanCentro.add (botLogoff);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPROLOFF_WINTITLE"));

    labSpiega.setText (Lingua.frase("FPROLOFF_SPIEGAZ"));

    botLogoff.setText (Lingua.frase("FPROLOFF_BOT_LOGOFF"));
    botKO    .setText (Lingua.frase("FPROLOFF_BOT_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      try {

        if (azione.equals(AZIONE_LOGOFF)) {
          try {

            profile.logoffProfile();

            // e riattiva la possibilit il Login!
            finestraPlace.abilitaVociSicurezza(FinestraPlace.VOCE_LOGIN);
            
            distruggiFinestra();    // Altrimenti, distruggo questa finestra!
          }
          catch (Exception ec2) {
           throw ec2;
          }
        }
        else // ANNULLA
          distruggiFinestra();    // Altrimenti, distruggo questa finestra!

      }
      catch (Exception eccezione) {
        OiDialogoi.mostraErrore (eccezione, mioFrame);    // STAMPA L'ECCEZIONE GENERATA!
      }
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager profile = new ProfileManager();
    FinProfileLogoff fin = new FinProfileLogoff(null, profile);
  } //main
*/

} //FinProfileLogoff