/**  FinPolicyUpdate
 *     La finestra di "Policy Update" (usa un "ProfileManager")
 *     @author     Luigi Antenucci
 *     @version    1.4
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.security.infrastructure.ProfileManager;
import SOMA.security.infrastructure.Infrastructure;
import SOMA.security.infrastructure.CertificateCRLList;
import SOMA.security.infrastructure.updatePolicy.UpdateDaemon;
import SOMA.security.infrastructure.updatePolicy.UpdatePolicyCRL;
import SOMA.security.infrastructure.updatePolicy.UpdatePolicyTime;

import java.util.Date;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class FinPolicyUpdate extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_UP_CRL    = "UpCRL";
  protected static final  String AZIONE_UP_CERT   = "UpCert";
  protected static final  String AZIONE_TIME      = "TimeForMe";
  protected static final  String AZIONE_DEMONE    = "StartStop";
  protected static final  String AZIONE_ANNULLA   = "Annulla";

  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraPlace      finestraPlace;
  protected ProfileManager     profile;
  protected UpdateDaemon       updateDaemon;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel       labSpiega,
                         labAttPol,
                         labLastUp,
                         labUpCRL, labUpCert,
                         labTime;
  protected JTextField   txtAttPol,
                         txtUpCRL, txtUpCert,
                         txtTime;
  protected JButton      botUpCRL, botUpCert,
                         botTime,
                         botDemone,
                         botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinPolicyUpdate (FinestraPlace finestraPlace, ProfileManager profile, 
                          UpdateDaemon updateDaemon) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.profile       = profile;
    this.updateDaemon  = updateDaemon;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega = new JLabel ();
    labAttPol = new JLabel ();
    labLastUp = new JLabel ();
    labUpCRL  = new JLabel ();
    labUpCert = new JLabel ();
    labTime   = new JLabel ();

    txtAttPol = new JTextField (25);
    txtUpCRL  = new JTextField (20);
    txtUpCert = new JTextField (20);
    txtTime   = new JTextField (10);

    txtAttPol.setEditable(false);
    txtUpCRL .setEditable(false);
    txtUpCert.setEditable(false);

    botUpCRL  = new JButton ();
    botUpCert = new JButton ();
    botTime   = new JButton ();
    botDemone = new JButton ();
    botKO     = new JButton ();

    aggiornaSchermata();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botUpCRL .setCursor (cursoreBottone);
    botUpCRL .setIcon (new ImageIcon(PICTURE_PATH+"PoliUpdate.gif"));
    botUpCRL .addActionListener (bottoniera);
    botUpCRL .setActionCommand(AZIONE_UP_CRL);
    botUpCert.setCursor (cursoreBottone);
    botUpCert.setIcon (new ImageIcon(PICTURE_PATH+"PoliUpdate.gif"));
    botUpCert.addActionListener (bottoniera);
    botUpCert.setActionCommand(AZIONE_UP_CERT);
    botTime  .setCursor (cursoreBottone);
    botTime  .setIcon (new ImageIcon(PICTURE_PATH+"PoliSetTime.gif"));
    botTime  .addActionListener (bottoniera);
    botTime  .setActionCommand(AZIONE_TIME);
    botDemone.setCursor (cursoreBottone);
    botDemone.setIcon (new ImageIcon(PICTURE_PATH+"PoliDemone.gif"));
    botDemone.addActionListener (bottoniera);
    botDemone.setActionCommand(AZIONE_DEMONE);
    botKO    .setCursor (cursoreBottone);
    botKO    .setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO    .addActionListener (bottoniera);
    botKO    .setActionCommand(AZIONE_ANNULLA);
    botKO    .setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    botUpCRL .setHorizontalAlignment(JLabel.LEFT);
    botUpCert.setHorizontalAlignment(JLabel.LEFT);
    botTime  .setHorizontalAlignment(JLabel.LEFT);

    txtTime    .setActionCommand(AZIONE_TIME);

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(2,10));
    CC.gridx = 1;   CC.gridy = 3;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panDat = new JPanel ();                       // PLACE ID
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();
      panDat.setLayout (GBL2);

      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 1;   CC2.gridy = 2;
      GBL2.setConstraints (labAttPol, CC2);
      panDat.add (labAttPol);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 2;   CC2.gridy = 2;
      CC2.gridwidth = 3;
      GBL2.setConstraints (txtAttPol, CC2);
      panDat.add (txtAttPol);
      CC2.gridwidth = 1;

      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 1;   CC2.gridy = 4;
      GBL2.setConstraints (labLastUp, CC2);
      panDat.add (labLastUp);

      CC2.gridx = 1;   CC2.gridy = 6;
      GBL2.setConstraints (labUpCRL, CC2);
      panDat.add (labUpCRL);
      CC2.gridx = 1;   CC2.gridy = 8;
      GBL2.setConstraints (labUpCert, CC2);
      panDat.add (labUpCert);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 2;   CC2.gridy = 6;
      GBL2.setConstraints (txtUpCRL, CC2);
      panDat.add (txtUpCRL);
      CC2.gridx = 2;   CC2.gridy = 8;
      GBL2.setConstraints (txtUpCert, CC2);
      panDat.add (txtUpCert);

      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 1;   CC2.gridy = 10;
      GBL2.setConstraints (labTime, CC2);
      panDat.add (labTime);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 2;   CC2.gridy = 10;
      GBL2.setConstraints (txtTime, CC2);
      panDat.add (txtTime);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 3;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 7;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);

      spazio = Box.createRigidArea (new Dimension(2,4));
      CC2.gridx = 2;   CC2.gridy = 9;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);

      spazio = Box.createRigidArea (new Dimension(10,2));
      CC2.gridx = 3;   CC2.gridy = 6;
      GBL2.setConstraints (spazio, CC2);
      panDat.add (spazio);

      CC2.fill = GridBagConstraints.HORIZONTAL;
      CC2.gridx = 4;   CC2.gridy = 6;
      GBL2.setConstraints (botUpCRL, CC2);
      panDat.add (botUpCRL);

      CC2.gridx = 4;   CC2.gridy = 8;
      GBL2.setConstraints (botUpCert, CC2);
      panDat.add (botUpCert);

      CC2.gridx = 4;   CC2.gridy = 10;
      GBL2.setConstraints (botTime, CC2);
      panDat.add (botTime);

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 5;
    GBL.setConstraints (panDat, CC);
    PanCentro.add (panDat);

    spazio = Box.createRigidArea (new Dimension(2,10));
    CC.gridx = 1;   CC.gridy = 6;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.fill   = GridBagConstraints.VERTICAL;
    CC.gridx = 1;   CC.gridy = 10;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (botDemone, CC);
    PanCentro.add (botDemone);
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPOLIUP_WINTITLE"));

    labSpiega.setText (Lingua.frase("FPOLIUP_SPIEGAZ"));
    labAttPol.setText (Lingua.frase("FPOLIUP_CURRENT"));
    labLastUp.setText (Lingua.frase("FPOLIUP_LAST_UP")); 
    labUpCRL .setText (Lingua.frase("FPOLIUP_UP_CRL"));
    labUpCert.setText (Lingua.frase("FPOLIUP_UP_CERT"));
    labTime  .setText (Lingua.frase("FPOLIUP_TIME"));

    botUpCRL .setText (Lingua.frase("FPOLIUP_BOT_UP_CRL"));
    botUpCert.setText (Lingua.frase("FPOLIUP_BOT_UP_CERT"));
    botTime  .setText (Lingua.frase("FPOLIUP_BOT_TIME"));
    botKO    .setText (Lingua.frase("FPOLIUP_BOT_CANCEL"));

    Object statoAtt = updateDaemon.getStatus();
    if (statoAtt == UpdateDaemon.ON)    // Se  ON, commuta in OFF
      botDemone.setText (Lingua.frase("FPOLIUP_BOT_D_STOP"));
    else
      botDemone.setText (Lingua.frase("FPOLIUP_BOT_D_START"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Riempie i dati della finestra
       */
  protected void aggiornaSchermata () {
    txtAttPol.setText ("");
    txtUpCRL .setText ("");
    txtUpCert.setText ("");

    if (updateDaemon != null) {
      txtAttPol.setText (updateDaemon.toString());
    }

    if (profile != null) {
      Infrastructure pki = profile.getEntrustInfrastructure();
      if (pki != null) {
        CertificateCRLList CRLList = pki.getCertificateCRLList();
        if (CRLList != null) {
          Date CRLDate  = CRLList.getLastCRLUpdate();
          Date CertDate = CRLList.getLastCertUpdate();
          txtUpCRL .setText (CRLDate.toString());
          txtUpCert.setText (CRLDate.toString());
        } 
      }
    }

  } //aggiornaSchermata


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();

      try {

        if (azione.equals(AZIONE_UP_CRL)) {
          Infrastructure pki = profile.getEntrustInfrastructure();
          if (pki != null) {
            UpdatePolicyCRL UpCRL = new UpdatePolicyCRL(pki);
            updateDaemon.setUpdatePolicy (UpCRL);
          }
        }
        else if (azione.equals(AZIONE_UP_CERT)) {
          profile.getEntrustInfrastructure().updateCertificateCRLList();
        }
        else if (azione.equals(AZIONE_TIME)) {
          long tempo = Long.parseLong(txtTime.getText());
          UpdatePolicyTime UpTime = new UpdatePolicyTime(tempo);
          updateDaemon.setUpdatePolicy (UpTime);
        }
        else if (azione.equals(AZIONE_DEMONE)) {
          Thread esecutore = new Thread ("MammaCara") {
              public void run() {
                try {
                  Object statoAtt = updateDaemon.getStatus();
                  if (statoAtt == UpdateDaemon.ON)    // Se  ON, commuta in OFF
                    updateDaemon.stop ();
                  else
                    updateDaemon.start ();

                  final Object statoDopo = updateDaemon.getStatus();

                  SwingUtilities.invokeLater (new Runnable () {
                      public void run () {
                        if (statoDopo == UpdateDaemon.ON)    // Se  ON, commuta in OFF
                          botDemone.setText (Lingua.frase("FPOLIUP_BOT_D_STOP"));
                        else
                          botDemone.setText (Lingua.frase("FPOLIUP_BOT_D_START"));
                      } //run
                   }); //invokeLater
                }
                catch (Exception eccez) {
                  OiDialogoi.mostraErrore (eccez, mioFrame);
                }
              } //run
          }; //esecutore (Thread)
          esecutore.start();
        }
        else //AZIONE_CANCEL
          // Altrimenti, distruggo questa finestra!
          distruggiFinestra();

      }
      catch (Exception eccez) {
        OiDialogoi.mostraErrore (eccez, mioFrame);
      }
      aggiornaSchermata();

    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager myProfile = new ProfileManager();
    UpdateDaemon upDem = new UpdateDaemon ((new UpdatePolicyCRL(myProfile.getEntrustInfrastructure())),
                                           myProfile.getEntrustInfrastructure(),
                                           System.out );
    FinPolicyUpdate fin = new FinPolicyUpdate (null, myProfile, upDem);
  } //main
*/

} //FinPolicyUpdate