/**  FinOpzioni
 *     Una finestra tramite cui definire alcune opzioni di configurazione utili in tutto il programma.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinOpzioni extends Finestra {

  // Costanti:
      /**
       *  Costanti per le opzioni che hanno tre valori: chiedi a utente, sempre s o sempre no.
       */
  public static final int OPZIONE_CHIEDI_UT = 0;
  public static final int OPZIONE_SEMPRE_SI = 1;
  public static final int OPZIONE_SEMPRE_NO = 2;

  // Variabili d'istanza:
      /**
       *  Costanti per le stringhe dei tre valori precedenti.
       */
  protected String[] arrTreVal = new String[3];

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel     labSpiega, 
                       labCaricaPlace, labApriFinPlace,
                       labApriInfo,    labEsciUltima, 
                       labUsaSC,       labUsaFont, labFinDebug,
                       labDelPlace,    labDelConfig;
  protected JComboBox  outCaricaPlace, outApriFinPlace;
  protected JCheckBox  chkApriInfo,    chkEsciUltima, 
                       chkUsaSC,       chkUsaFont, chkFinDebug;
  protected PanFontDim panFontDim;
  protected JButton    botDelPlace,    botDelConfig,
                       botOk, botDef, botCan;

      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinOpzioni () {
    super (0, 30);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    // Le "defProp" di tutte le propriet sono fatte nella classe "Inizio", 
    // responsabile di inizializzare l'intero ambiente per la gestione della GUI.

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    Config.defPropVariabile (FinestraPlace.CONFIG_TXT_DIM, 
                             String.valueOf(FinestraPlace.CONFIG_TXT_INT));

    labSpiega       = new JLabel ();
    labCaricaPlace  = new JLabel ();
    labApriFinPlace = new JLabel ();
    labApriInfo     = new JLabel ();
    labEsciUltima   = new JLabel ();
    labUsaSC        = new JLabel ();
    labUsaFont      = new JLabel ();
    labFinDebug     = new JLabel ();
    labDelPlace     = new JLabel ();
    labDelConfig    = new JLabel ();
    
    int dimDonDan   = Config.chePropInt(FinestraPlace.CONFIG_TXT_DIM);
    panFontDim      = new PanFontDim (dimDonDan);
    panFontDim.addChangeListener (new ChangeListener () {
                                    public void stateChanged (ChangeEvent e) {
                                      int dim = ( (JSlider)e.getSource() ).getValue();
                                      Config.modifPropInt (FinestraPlace.CONFIG_TXT_DIM, dim);
                                    }
                                  });
    botOk  = new JButton ();
    botDef = new JButton ();
    botCan = new JButton ();

    botDelPlace  = new JButton ();
    botDelConfig = new JButton ();

    chkApriInfo   = new JCheckBox ();
    chkEsciUltima = new JCheckBox ();
    chkUsaSC      = new JCheckBox ();
    chkUsaFont    = new JCheckBox ();
    chkFinDebug   = new JCheckBox ();

    // L'impostazione dei combo-box  fatta nella "impostaFrasi"

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    impostaCampiVariabili();

    ListBottoni listBott = new ListBottoni();

    botOk .setCursor (cursoreBottone);
    botDef.setCursor (cursoreBottone);
    botCan.setCursor (cursoreBottone);
    botDelPlace .setCursor (cursoreBottone);
    botDelConfig.setCursor (cursoreBottone);

    botOk .setIcon (new ImageIcon(PICTURE_PATH+"OpzMod.gif"));
    botDef.setIcon (new ImageIcon(PICTURE_PATH+"OpzDef.gif"));
    botCan.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botCan.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    botOk .setActionCommand("imposta");
    botOk .addActionListener (listBott);
    botDef.setActionCommand("default");
    botDef.addActionListener (listBott);
    botCan.setActionCommand("annulla");
    botCan.addActionListener (listBott);
 
    botDelPlace .setActionCommand("delPlace");
    botDelPlace .addActionListener (listBott);
    botDelConfig.setActionCommand("delConfig");
    botDelConfig.addActionListener (listBott);

    if (! Creatore.esisteConfigSalvata()) {
      botDelPlace.setEnabled(false);
      labDelPlace.setEnabled(false);
    }

    mioFrame.addWindowListener (listBott);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);
    
    spazio = Box.createRigidArea (new Dimension(5,14));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panOpz = new JPanel();
    GridBagLayout GBL3     = new GridBagLayout();
    GridBagConstraints CC3 = new GridBagConstraints();
    panOpz.setLayout (GBL3);

      CC3.gridx = 1;   CC3.gridy = 1;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labCaricaPlace, CC3);
      panOpz.add (labCaricaPlace);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (outCaricaPlace, CC3);
      panOpz.add (outCaricaPlace);

      CC3.gridx = 1;   CC3.gridy = 2;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labApriFinPlace, CC3);
      panOpz.add (labApriFinPlace);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (outApriFinPlace, CC3);
      panOpz.add (outApriFinPlace);

      CC3.gridx = 1;   CC3.gridy = 3;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labApriInfo, CC3);
      panOpz.add (labApriInfo);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (chkApriInfo, CC3);
      panOpz.add (chkApriInfo);

      CC3.gridx = 1;   CC3.gridy = 4;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labEsciUltima, CC3);
      panOpz.add (labEsciUltima);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (chkEsciUltima, CC3);
      panOpz.add (chkEsciUltima);

      CC3.gridx = 1;   CC3.gridy = 5;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labUsaSC, CC3);
      panOpz.add (labUsaSC);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (chkUsaSC, CC3);
      panOpz.add (chkUsaSC);

      CC3.gridx = 1;   CC3.gridy = 6;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labUsaFont, CC3);
      panOpz.add (labUsaFont);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (chkUsaFont, CC3);
      panOpz.add (chkUsaFont);
      CC3.gridx = 3;   CC3.gridy = 5;
      CC3.gridheight = 3;
      GBL3.setConstraints (panFontDim, CC3);
      panOpz.add (panFontDim);
      CC3.gridheight = 1;

      CC3.gridx = 1;   CC3.gridy = 7;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labFinDebug, CC3);
      panOpz.add (labFinDebug);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (chkFinDebug, CC3);
      panOpz.add (chkFinDebug);

      CC3.gridx = 1;   CC3.gridy = 10;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labDelPlace, CC3);
      panOpz.add (labDelPlace);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (botDelPlace, CC3);
      panOpz.add (botDelPlace);

      CC3.gridx = 1;   CC3.gridy = 12;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labDelConfig, CC3);
      panOpz.add (labDelConfig);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (botDelConfig, CC3);
      panOpz.add (botDelConfig);

    CC.gridx = 1;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (panOpz, CC);
    PanCentro.add (panOpz);

    JPanel panBott = new JPanel();
    GridBagLayout GBL4     = new GridBagLayout();
    GridBagConstraints CC4 = new GridBagConstraints();
    panBott.setLayout (GBL4);

      CC4.fill = GridBagConstraints.VERTICAL;

      CC4.gridx = 1;   CC4.gridy = 1;
      GBL4.setConstraints (botOk, CC4);
      panBott.add (botOk);

      spazio = Box.createRigidArea (new Dimension(20,4));
      CC4.gridx = 2;   CC4.gridy = 1;
      GBL4.setConstraints (spazio, CC4);
      panBott.add (spazio);

      CC4.gridx = 3;   CC4.gridy = 1;
      GBL4.setConstraints (botDef, CC4);
      panBott.add (botDef);

      spazio = Box.createRigidArea (new Dimension(20,4));
      CC4.gridx = 4;   CC4.gridy = 1;
      GBL4.setConstraints (spazio, CC4);
      panBott.add (spazio);

      CC4.gridx = 5;   CC4.gridy = 1;
      GBL4.setConstraints (botCan, CC4);
      panBott.add (botCan);

      panBott.setBorder (BorderFactory.createEmptyBorder(15, 10, 0, 10));   // alto,sx,basso,dx
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (panBott, CC);
    PanCentro.add (panBott);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FOPZ_WINTITLE"));

    arrTreVal[0] = Lingua.frase("FOPZ_OPZ_TRE_UNO");
    arrTreVal[1] = Lingua.frase("FOPZ_OPZ_TRE_DUE");
    arrTreVal[2] = Lingua.frase("FOPZ_OPZ_TRE_TRE");
    
    outCaricaPlace  = new JComboBox (arrTreVal);
    outApriFinPlace = new JComboBox (arrTreVal);

    labSpiega.setText(Lingua.frase("FOPZ_SPIEGAZIO"));

    labCaricaPlace .setText(Lingua.frase("FOPZ_CARICA_PLA"));
    labApriFinPlace.setText(Lingua.frase("FOPZ_APRI_FIN"));
    labApriInfo    .setText(Lingua.frase("FOPZ_APRI_INFO"));
    labEsciUltima  .setText(Lingua.frase("FOPZ_ESCI_ULT"));
    labUsaSC       .setText(Lingua.frase("FOPZ_USA_SC"));
    labUsaFont     .setText(Lingua.frase("FOPZ_USA_FONT"));
    labFinDebug    .setText(Lingua.frase("FOPZ_FIN_DEBUG"));
    labDelPlace    .setText(Lingua.frase("FOPZ_DEL_PLACE"));
    labDelConfig   .setText(Lingua.frase("FOPZ_DEL_CONFIG"));

    botDelPlace .setText(Lingua.frase("FOPZ_BOT_CANC_ORA"));
    botDelConfig.setText(Lingua.frase("FOPZ_BOT_CANC_ORA"));

    botOk .setText (Lingua.frase("FOPZ_BOT_DEFINISCI"));
    botDef.setText (Lingua.frase("FOPZ_BOT_DEFAULT"));
    botCan.setText (Lingua.frase("FOPZ_BOT_CHIUDI"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Imposta tutti i combo-box e i check-box sui valori definiti.
       */
  protected void impostaCampiVariabili () {
    impostaComboSu (outCaricaPlace,  Config.chePropInt("ChiediCaricaPlace"));
    impostaComboSu (outApriFinPlace, Config.chePropInt("ChiediApriPlace"));
    chkApriInfo  .setSelected (Config.chePropBool ("ApriInfoSu"));
    chkEsciUltima.setSelected (! Config.chePropBool ("ContinuaDopoUltima"));  // NB: c' il NOT
    chkUsaSC     .setSelected (Config.chePropBool ("UsaTestoSC"));
    chkUsaFont   .setSelected (Config.chePropBool ("SliderModiFont"));
    chkFinDebug  .setSelected (Config.chePropBool ("FinestraDiDebug"));
  } //impostaCampiVariabili

      /**
       *  Imposta il combo-box passato sulla stringa di opzioni corrispondente all'intero passato.
       */
  protected void impostaComboSu (JComboBox cheCombo, int opzione) {
    cheCombo.setSelectedItem (arrTreVal[opzione]);
  } //impostaComboSu

      /**
       *  Rende l'opzione (in intero) su cui  selezionato il combo-box passato.
       */
  protected int rendiComboChe (JComboBox cheCombo) {
    String opzStr = (String) cheCombo.getSelectedItem();
    boolean trovato = false;
    int i=0;
    while ((i<3) && (! trovato)) {
      if (opzStr.equals(arrTreVal[i])) 
        trovato = true;
      else
        i++;
    }
    if (trovato)
      return i;
    else
      return -1;
  } //rendiComboChe


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();   // PRELEVO L'AZIONE DA ESEGUIRE

      if (azione.equals("imposta")) {
        Config.modifPropInt  ("ChiediCaricaPlace",  rendiComboChe(outCaricaPlace));
        Config.modifPropInt  ("ChiediApriPlace",    rendiComboChe(outApriFinPlace));
        Config.modifPropBool ("ApriInfoSu",         chkApriInfo.isSelected());
        Config.modifPropBool ("ContinuaDopoUltima", (! chkEsciUltima.isSelected())); // NB: c' il NOT
        Config.modifPropBool ("UsaTestoSC",         chkUsaSC.isSelected());
        Config.modifPropBool ("SliderModiFont",     chkUsaFont.isSelected());
        Config.modifPropBool ("FinestraDiDebug",    chkFinDebug.isSelected());
        if (Config.chePropBool("FinestraDiDebug"))    // APRE O CHIUDE LA FINESTRA DI DEBUG
          Debug.apriFinestra ();
        else
          Debug.chiudiFinestra ();
        distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
      }
      else
        if (azione.equals("default")) {
          Config.resetProp ("ChiediCaricaPlace");
          Config.resetProp ("ChiediApriPlace");
          Config.resetProp ("ApriInfoSu");
          Config.resetProp ("ContinuaDopoUltima");
          Config.resetProp ("FinestraDiDebug");
          impostaCampiVariabili ();
        }
        else
          if (azione.equals("delPlace")) {
            Creatore.cancellaConfigPlace();
            botDelPlace.setEnabled(false);
            labDelPlace.setEnabled(false);
          }
          else
            if (azione.equals("delConfig")) {
              Config.resetConfig();
              Lingua.defLingua (Config.chePropInt("Lingua"));
              Apparenza.defApparenza (Config.cheProp ("Apparenza"));
              impostaCampiVariabili();
            }
            else
              distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    Config.caricaPropUtenteSeCiSono ();
    Config.defPropInt ("ChiediCaricaPlace", FinOpzioni.OPZIONE_CHIEDI_UT);
    Config.defPropInt ("ChiediApriPlace",   FinOpzioni.OPZIONE_SEMPRE_SI);
    Config.defPropBool ("ApriInfoSu",         true);
    Config.defPropBool ("ContinuaDopoUltima", false);
    Config.defPropBool ("UsaTestoSC",         true);
    Config.defPropBool ("SliderModiFont",     true);
    Config.defPropBool ("FinestraDiDebug",    false);
    FinOpzioni fin = new FinOpzioni ();
  } //main
*/

} //FinOpzioni