/**  FinMemory
 *     Una finestrella in cui mostrare le informazioni sulla memoria.
 *     Memory, all alone in the moonlight,..
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.awt.*;
import javax.swing.*;


public class FinMemory extends Finestra {

  // Variabili d'istanza:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labTotale, labUsata, labLibera,
                       labMeno, labUguale, labUnita;
  protected JTextField txtTotale, txtUsata, txtLibera;
  protected JButton    botChiudi;

      /**
       *  I dati (sulla memoria) passati al costruttore
       */
  protected long memTotale, memLibera, memUsata;

      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinMemory (long memTotale, long memLibera, long memUsata) {
    super (220, 120);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE
    this.memTotale = memTotale;
    this.memLibera = memLibera;
    this.memUsata  = memUsata;
    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labTotale = new JLabel ();
    labUsata  = new JLabel ();
    labLibera = new JLabel ();
    labMeno   = new JLabel ();
    labUguale = new JLabel ();
    labUnita  = new JLabel ();

    txtTotale = new JTextField (10);
    txtTotale.setEnabled (false);
    txtTotale.setHorizontalAlignment(JLabel.RIGHT);
    txtUsata  = new JTextField (10);
    txtUsata .setEnabled (false);
    txtUsata .setHorizontalAlignment(JLabel.RIGHT);
    txtLibera = new JTextField (10);
    txtLibera.setEnabled (false);
    txtLibera.setHorizontalAlignment(JLabel.RIGHT);

    botChiudi  = new JButton ();

    txtTotale.setText(String.valueOf(memTotale));
    txtUsata .setText(String.valueOf(memUsata));
    txtLibera.setText(String.valueOf(memLibera));

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botChiudi.setCursor (cursoreBottone);
    botChiudi.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botChiudi.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 20, 8, 20));   // alto,sx,basso,dx

    Component spazio;

      CC.gridx = 1;   CC.gridy = 2;
      CC.anchor = GridBagConstraints.EAST;
      GBL.setConstraints (labTotale, CC);
      PanCentro.add (labTotale);

      CC.gridx = 2;   CC.gridy = 2;
      CC.anchor = GridBagConstraints.EAST;
      GBL.setConstraints (txtTotale, CC);
      PanCentro.add (txtTotale);

      CC.gridx = 3;   CC.gridy = 2;
      CC.anchor = GridBagConstraints.WEST;
      GBL.setConstraints (labMeno, CC);
      PanCentro.add (labMeno);

    spazio = Box.createRigidArea (new Dimension(5,15));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 4;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

      CC.gridx = 1;   CC.gridy = 6;
      CC.anchor = GridBagConstraints.EAST;
      GBL.setConstraints (labUsata, CC);
      PanCentro.add (labUsata);

      CC.gridx = 2;   CC.gridy = 6;
      CC.anchor = GridBagConstraints.EAST;
      GBL.setConstraints (txtUsata, CC);
      PanCentro.add (txtUsata);

      CC.gridx = 3;   CC.gridy = 6;
      CC.anchor = GridBagConstraints.WEST;
      GBL.setConstraints (labUguale, CC);
      PanCentro.add (labUguale);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

      CC.gridx = 1;   CC.gridy = 10;
      CC.anchor = GridBagConstraints.EAST;
      GBL.setConstraints (labLibera, CC);
      PanCentro.add (labLibera);

      CC.gridx = 2;   CC.gridy = 10;
      CC.anchor = GridBagConstraints.EAST;
      GBL.setConstraints (txtLibera, CC);
      PanCentro.add (txtLibera);

      CC.gridx = 3;   CC.gridy = 10;
      CC.anchor = GridBagConstraints.WEST;
      GBL.setConstraints (labUnita, CC);
      PanCentro.add (labUnita);

    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 2;   CC.gridy = 12;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 2;   CC.gridy = 13;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FMEM_WINTITLE"));

    labTotale.setText (Lingua.frase("FMEM_TOTAL"));
    labUsata .setText (Lingua.frase("FMEM_USED"));
    labLibera.setText (Lingua.frase("FMEM_FREE"));
    labMeno  .setText (Lingua.frase("FMEM_SUB"));
    labUguale.setText (Lingua.frase("FMEM_EQU"));
    labUnita .setText (Lingua.frase("FMEM_UNIT"));

    botChiudi.setText (Lingua.frase("FMEM_BOT_OK"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    new FinMemory (Runtime.getRuntime().totalMemory(),  Runtime.getRuntime().freeMemory(),
                   Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() );
  } //main
*/

} //FinMemory