/**  FinConnect
 *     Una finestrella tramite cui inserire il dominio a cui connettere
 *     un Place Mobile.
 *     I dati sono presi dal DNS del place mobile.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.PlaceID;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class FinConnect extends Finestra {

  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraPlace finestraPlace;
  protected ActionPlace   actionPlace;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JRadioButton radioCombo, radioTesto;
  protected JLabel       labSpiega;
  protected PanPlace     panPlace;
  protected JTextField   txtPlace;
  protected JButton      botOK, botKO;


      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinConnect (FinestraPlace finestraPlace, ActionPlace actionPlace) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.actionPlace   = actionPlace;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega     = new JLabel ();

    radioCombo = new JRadioButton ();
    radioTesto = new JRadioButton ();

    ButtonGroup gruppo = new ButtonGroup();    // Creo un gruppo di bottoni
    gruppo.add (radioCombo);
    gruppo.add (radioTesto);

    panPlace = new PanPlace (PanPlace.INPUT_DOMINIO, actionPlace);

    txtPlace = new JTextField (30);
    botOK = new JButton ();
    botKO = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botOK.setCursor (cursoreBottone);
    botOK.setIcon (new ImageIcon(PICTURE_PATH+"Connect.gif"));
    botOK.addActionListener (bottoniera);
    botOK.setActionCommand("ok");
    botKO.setCursor (cursoreBottone);
    botKO.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO.addActionListener (bottoniera);
    botKO.setActionCommand("cancel");
    botKO.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    txtPlace.setActionCommand("ok");
    txtPlace.addActionListener (bottoniera);    // PRESSIONE "INVIO" SU TextField

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 6;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (radioCombo, CC);
    PanCentro.add (radioCombo);

    panPlace.setBorder (BorderFactory.createEmptyBorder(0, 40, 6, 0));   // alto,sx,basso,dx

    CC.gridx = 1;   CC.gridy = 7;
    GBL.setConstraints (panPlace, CC);
    PanCentro.add (panPlace);

    CC.gridx = 1;   CC.gridy = 8;
    GBL.setConstraints (radioTesto, CC);
    PanCentro.add (radioTesto);

    JPanel panTxt = new JPanel();
    panTxt.add(txtPlace);
    panTxt.setBorder (BorderFactory.createEmptyBorder(0, 40, 15, 0));   // alto,sx,basso,dx
    CC.gridx = 1;   CC.gridy = 9;
    GBL.setConstraints (panTxt, CC);
    PanCentro.add (panTxt);

    CC.fill = GridBagConstraints.VERTICAL;

    CC.gridx = 1;   CC.gridy = 11;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (botOK, CC);
    PanCentro.add (botOK);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 11;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    // AZIONI: actionListener
    ListRadio radiera = new ListRadio ();
    radioCombo.addActionListener (radiera);
    radioCombo.setActionCommand ("combo");
    radioTesto.addActionListener (radiera);
    radioTesto.setActionCommand ("testo");

    radioCombo.setSelected(true);
    eseguiAzione (radioCombo.getActionCommand());

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panPlace.distruggimi();

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FCON_WINTITLE"));

    labSpiega.setText (Lingua.frase("FCON_SPIEGAZ"));

    radioCombo.setText (Lingua.frase("FCON_COMBO"));
    radioTesto.setText (Lingua.frase("FCON_TESTO"));

    botOK.setText (Lingua.frase("FCON_BOT_PUT"));
    botKO.setText (Lingua.frase("FCON_BOT_CANC"));

    radioCombo.setToolTipText (Lingua.frase("FCON_TIP_R_COMBO"));
    radioTesto.setToolTipText (Lingua.frase("FCON_TIP_R_TEXT"));
    txtPlace  .setToolTipText (Lingua.frase("FCON_TIP_R_TEXT"));  //nota: stessa "tip"
    botOK     .setToolTipText (Lingua.frase("FCON_TIP_OK"));
    botKO     .setToolTipText (Lingua.frase("FCON_TIP_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

  protected void eseguiAzione (String actionCommand) {
    if (actionCommand.equals("combo")) {
      panPlace.abilitami();
      txtPlace.setEditable(false);
    }
    else {
      panPlace.disabilitami();  //NB: riabilito!
      txtPlace.setEditable(true);
    }
  } //eseguiAzione


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI "RADIO" DELLA FINESTRA.
       *  Permette di disabilitare tutti i "campi" di input che sono relativi ai "radio" non abilitati.
       */
  class ListRadio implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      eseguiAzione (azione);
    } //actionPerformed
  } // ListRadio

      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("ok")) {

        // PRELEVA I DATI DAL PANNELLO:
        try {

          PlaceID placeToConnect;
          if (radioCombo.isSelected())           // LEGGO I DATI DAL "RADIO" SELEZIONATO
            placeToConnect = panPlace.cheDominio();
          else { //radioTesto
            String campoTxt = txtPlace.getText();
            if (campoTxt.equals(""))
              throw new Exception (Lingua.frase("FCON_ERR_EMPTY_PLACE"));

            try {
              placeToConnect = new PlaceID (campoTxt);
              if (! placeToConnect.isDomain())
                throw new Exception ("bauBau");
            }
            catch (Exception ecc) {
              throw new Exception (Lingua.frase("FCON_ERR_WRONG_PLACE"));
            }
          }

          // ESEGUE L'AZIONE DIRETTAMENTE SULL'ActionPlace PASSANDOGLI I DATI:
          actionPlace.mobileConnect (placeToConnect);

          // Se tutto ok, distruggo questa finestra
          distruggiFinestra();

        }
        catch (Exception eccezione) {
          OiDialogoi.mostraErrore (eccezione, mioFrame);    // STAMPA L'ECCEZIONE GENERATA!
        }
      }
      else
        // Altrimenti, distruggo questa finestra!
        distruggiFinestra();
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

} //FinConnect