/**  FinConContainer
 *     Finestra per mostrare un generico oggetto "Container" 
 *     (creato e inizializzato a priori dall'utente).
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.awt.*;
import javax.swing.*;


public class FinConContainer extends Finestra {
  // "static", se no non mi permette di crearne istanze all'interno di metodi "static"

      /**
       *  Oggetti passati al costruttore
       */
  protected Container mioContainer;
  protected String    winTitolo;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JButton botOk;

      /**
       *  Costruisce e mostra la finestra della traccia dello stack.
       */ 
  public FinConContainer (Container mioContainer, String winTitolo) {
    super (150, 30, winTitolo);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE (Finestra!)

    this.mioContainer = mioContainer;
    this.winTitolo    = winTitolo;

    costruisciFinestra();
  } //costruttore

  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    botOk    = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botOk.setCursor (cursoreBottone);
    botOk.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botOk.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    PanCentro.setLayout (new BorderLayout());

    JScrollPane scrollArea = new JScrollPane (mioContainer);

    PanCentro.add (scrollArea, BorderLayout.CENTER);

    JPanel panOkkia = new JPanel ();
    panOkkia.add (botOk);
    PanCentro.add (panOkkia,   BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (winTitolo);

    botOk.setText (Lingua.frase("FTXT_BOT_OK"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    FinConContainer fin = new FinConContainer (new JLabel("BAU BAU BAU"), "miaoooo!");
  } //main
*/

} //FinConContainer