/**  FinAgentInfo
 *     Una finestrella in cui mostrare le informazioni su un Place.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.naming.AgentID;

import java.awt.*;
import javax.swing.*;


public class FinAgentInfo extends Finestra {

  // Variabili d'istanza:

      /**
       *  L'AgentID di cui mostrare le informazioni.
       */ 
  protected AgentID agentID;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labAgentID,  labHome;
  protected JTextField txtAgentID,  txtHome;
  protected JButton    botChiudi;


      /**
       *  Costruisce e mostra la finestra di informazioni.
       */ 
  public FinAgentInfo (AgentID agentID) {
    super (250, 120);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.agentID = agentID;

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labAgentID = new JLabel ();
    labHome    = new JLabel ();

    txtAgentID = new JTextField (24);
    txtAgentID.setEnabled (false);
    txtHome    = new JTextField (20);
    txtHome.setEnabled (false);

    botChiudi  = new JButton ();

    txtAgentID.setText (agentID.toString());
    txtHome.setText (agentID.getHome().toString());

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListClose listClose = new ListClose(this);

    botChiudi.setCursor (cursoreBottone);
    botChiudi.setIcon (new ImageIcon(PICTURE_PATH+"BotOK.gif"));
    botChiudi.addActionListener (listClose);

    mioFrame.addWindowListener (listClose);  // Per la chiusura della finestra

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

      JPanel panX = new JPanel ();                       // PLACE ID
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panX.setLayout (GBL3);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 1;   CC3.gridy = 1;
      GBL3.setConstraints (labAgentID, CC3);
      panX.add (labAgentID);

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 2;   CC3.gridy = 1;
      GBL3.setConstraints (txtAgentID, CC3);
      panX.add (txtAgentID);

      spazio = Box.createRigidArea (new Dimension(5,10));   // Aggiunge spazio vuoto
      CC3.gridx = 2;   CC3.gridy = 2;
      GBL3.setConstraints (spazio, CC3);
      panX.add (spazio);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 1;   CC3.gridy = 3;
      GBL3.setConstraints (labHome, CC3);
      panX.add (labHome);

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 2;   CC3.gridy = 3;
      GBL3.setConstraints (txtHome, CC3);
      panX.add (txtHome);

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (panX, CC);
    PanCentro.add (panX);

    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 9;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FAGINF_WINTITLE"));

    labAgentID.setText (Lingua.frase("FAGINF_AGENT_ID"));
    labHome.setText    (Lingua.frase("FAGINF_HOME"));
    botChiudi.setText  (Lingua.frase("FAGINF_BOT_CHIUDI"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    new FinAgentInfo (new AgentID(new PlaceID ("Italia", ""), 1));
    new FinAgentInfo (new AgentID(new PlaceID ("Italia", "Bologna"), 123));
  } //main
*/

} //FinAgentInfo