/**  DebugWindow
 *     La finestra usata dall'oggetto "Debug". E` questa la finestra che viene
 *     creata e sulla quale viene stampato.
 *     L'oggetto "Debug" non fa altro che da tramite (in modo da creare una sola 
 *     istanza di questa finestra).
 *     @autore     Luigi Antenucci
 *     @versione   2.1
 *     @linguaggio jdk 1.2
 */

package SOMA.gui;

import SOMA.gui.lingua.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class DebugWindow extends Finestra {

      /**
       *  Oggetti che mostrano frasi, cio che dipendono dalla lingua.
       */
  protected JButton    botChiudi, botPulisci;
  protected JTextArea  textArea;
  protected PanFontDim panFontDim;

  protected PanTestoSC testata;

      /**
       *  Propriet di "Config" per ricordarsi la dimensione del font della finestra.
       */
  protected static final String CONFIG_TXT_DIM = "DebugFontTxtDim";


      /**
       *  Costruisce e mostra la finestra di debug.
       */ 
  public DebugWindow () {
    super (0, 0);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    Config.defPropInt (CONFIG_TXT_DIM, 11);

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    testata    = new PanTestoSC ();

    botChiudi  = new JButton ();
    botPulisci = new JButton ();
    
    textArea = new JTextArea (10,80);      // CREA AREA DI OUTPUT (STREAM) <righe,colonne>
		textArea.setEnabled (false);
    JScrollPane scrollTextArea = new JScrollPane (textArea);
    scrollTextArea.setPreferredSize (new Dimension(250,100));
    scrollTextArea.setMinimumSize (new Dimension(50,30));
    scrollTextArea.setVerticalScrollBarPolicy (JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    scrollTextArea.setHorizontalScrollBarPolicy (JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

    panFontDim = new PanFontDim (Config.chePropInt(CONFIG_TXT_DIM));
    panFontDim.addChangeListener (new ChangeListener () {
                                    public void stateChanged (ChangeEvent e) {
                                      int dim = ( (JSlider)e.getSource() ).getValue();
                                      impostaFontTxt (dim);
                                    }
                                  });
    impostaFontTxt (Config.chePropInt(CONFIG_TXT_DIM));

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)
    
    ListBottoni listBott = new ListBottoni ();

    mioFrame.addWindowListener (listBott);  // Per la chiusura della finestra

    botChiudi.setCursor (cursoreBottone);
    botChiudi.setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botChiudi.addActionListener (listBott);

    botPulisci.setActionCommand("pulisci");
    botPulisci.addActionListener (listBott);
    botPulisci.setCursor (cursoreBottone);
    botPulisci.setIcon (new ImageIcon(PICTURE_PATH+"Pulisci.gif"));

    PanCentro.setLayout (new BorderLayout());
    PanCentro.setBorder (BorderFactory.createEmptyBorder(6, 5, 3, 5));   // alto,sx,basso,dx

    testata.setBorder (BorderFactory.createEmptyBorder(0, 4, 4, 0));   // alto,sx,basso,dx
    PanCentro.add (testata, BorderLayout.NORTH);

    JPanel panOutSpa = new JPanel (new BorderLayout());
      Component spazio = Box.createRigidArea(new Dimension(4,4));
      panOutSpa.add (scrollTextArea, BorderLayout.CENTER);
      panOutSpa.add (spazio,         BorderLayout.SOUTH);

    PanCentro.add (panOutSpa, BorderLayout.CENTER);

    JPanel panBottoni = new JPanel ();
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();

      panBottoni.setLayout (GBL2);

      CC2.fill   = GridBagConstraints.NONE;
      CC2.anchor = GridBagConstraints.SOUTH;

      CC2.gridx = 1;   CC2.gridy = 1;
      GBL2.setConstraints (botPulisci, CC2);
      panBottoni.add (botPulisci);

      spazio = Box.createRigidArea(new Dimension(10,4));
      CC2.gridx = 2;   CC2.gridy = 1;
      GBL2.setConstraints (spazio, CC2);
      panBottoni.add (spazio);

      CC2.gridx = 3;   CC2.gridy = 1;
      GBL2.setConstraints (panFontDim, CC2);
      panBottoni.add (panFontDim);

      spazio = Box.createRigidArea(new Dimension(10,4));
      CC2.gridx = 4;   CC2.gridy = 1;
      GBL2.setConstraints (spazio, CC2);
      panBottoni.add (spazio);

      CC2.gridx = 5;   CC2.gridy = 1;
      GBL2.setConstraints (botChiudi, CC2);
      panBottoni.add (botChiudi);

      panBottoni.setBorder (BorderFactory.createEmptyBorder(10, 0, 0, 0));   // alto,sx,basso,dx

    PanCentro.add (panBottoni, BorderLayout.SOUTH);

    mioFrame.setResizable (true);     // La finestra place e' ridimensionabile

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("DEBUGW_WINTITLE"));

    testata   .setText (Lingua.frase("DEBUGW_HEADER"));

    botPulisci.setText (Lingua.frase("DEBUGW_BOT_CLEAR"));
    botChiudi .setText (Lingua.frase("DEBUGW_BOT_CLOSE"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Interna, serve per far impostare la nuova dimensione del font delle zone di testo.
       */
  protected void impostaFontTxt (int nuovaDim) {
    Config.modifPropInt (CONFIG_TXT_DIM, nuovaDim);
    Font txtFont = new Font ("DialogInput", Font.PLAIN, nuovaDim);
    textArea.setFont (txtFont);
  } //impostaFontTxt

      /**
       *  Per scrivere correttamente sulla text area, in qualsiasi momento.
       */
  public void scrivi (final String testo) {
    SwingUtilities.invokeLater (new Runnable () {
            public void run () {
              textArea.append (testo);
            } //run
    }); //invokeLater
  } //scrivi

      /**
       *  Per cancellare il contenuto della text area, in qualsiasi momento.
       */
  public void pulisci () {
    SwingUtilities.invokeLater (new Runnable () {
            public void run () {
              textArea.setText ("");
            } //run
    }); //invokeLater
  } //pulisci


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {

      String azione = e.getActionCommand();   // PRELEVO L'AZIONE DA ESEGUIRE

      if (azione.equals("pulisci")) {
        textArea.setText("");
      }
      else
        Debug.chiudiFinestra ();  //NB: dico a "Debug" di chiudermi
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      Debug.chiudiFinestra ();  //NB: dico a "Debug" di chiudermi
    } //windowClosing

  } //ListBottoni (classe)


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    DebugWindow debugWindow = new DebugWindow ();
    debugWindow.scrivi ("CIAO MONDO");
  } //main
*/

} //DebugWindow