/**  Creatore
 *     Classe statica che si occupa principalmente di creare nuovi place (di default e non).
 *     Inoltre, permette la definizione di frasi di invocazione per la creazione
 *     (che possono essere salvate facilmente su disco).
 *     In pi  l'unica classe delle GUI a tener memorizzato (e accessibile da tutte le
 *     altre classi) il direttorio radice del men di SOMA (l'interfaccia a modo testo).
 *     Nota: ogni nuovo place che viene creato viene anche "battezzato" facendo
 *     una chiamata a {@link SOMA.gui.Anagrafe#battezzaPlace()} di {@link SOMA.gui.Anagrafe}.
 *     L'oggetto Anagrafe che si usa sar quello passato al metodo di creazione.
 *     Una funzionalit aggiuntiva  il lancio di agenti.
 *     @author     Luigi Antenucci
 *     @version    2.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.mobilePlace.MobileEnvironment;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.agent.AgentWorker;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.NullOutputStream;
import SOMA.security.SecurityEnvironment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.awt.*;
import javax.swing.*;


public class Creatore {
    
    // COSTANTI (protette):
      /**
       *  File su cui salvare e successivamente ricaricare le stringhe di
       *  invocazione dei place.
       */
    protected static final String FILE_PLACES = "PLACES.GG";
    // File su cui memorizzare la configurazione dei place/dominii
    
      /**
       *  Intestazione di ogni singola invocazione per distinguere il tipo di
       *  place da creare: dei DEFault o NORmale.
       */
    protected static final String CREA_PLACEDEF = "DEF-PLACE";
    protected static final String CREA_PLACENOR = "NOR-PLACE";
    protected static final String CREA_PLACEMOB = "MOB-PLACE";
    
    protected static final String SICURO_SI     = "SIC";
    protected static final String SICURO_NO     = "INS";
    
    // Variabili protette:
      /**
       *  Riferimento alla "root" del men creato da {@link SOMA.Main}.
       */
    protected static DirExplorerItem rootDir = null;
    
      /**
       *  Tengo traccia se  la prima volta che si esegue un metodo di questa classe.
       *  Infatti la "prima volta" - e solo in quell'occasione - va caricato il file di lingua.
       */
    protected static boolean primaVolta = true;
    
    
      /**
       *  Carico il file di lingua di questa classe
       */
    protected static void CaricaMiaLingua () {
        if (primaVolta) {
            Lingua.caricaFileDiLingua (Creatore.class);
            primaVolta=false;
        }
    } //CaricaMiaLingua
    
      /**
       *  Salva il riferimento alla "root" del men a directory di SOMA, quello
       *  che viene creato da {@link SOMA.Main}.
       */
    public static void defRootDir (DirExplorerItem rootDirMenu) {
        // Imposta la "root dir" del menu' definito nella classe "Main"
        // Tale menu' viene passato da Main a Inizio che lo rende visibile a
        //  qualunque Finestra tramite l'accesso al Creatore.
        rootDir = rootDirMenu;
    } //defRootDir
    
      /**
       *  Rende il riferimento alla "root" del men a directory di SOMA.
       */
    public static DirExplorerItem cheRootDir () {
        // Per ottenere la "root" del menu'
        return rootDir;
    } //cheRootDir
    
      /**
       *  Rende il riferimento al "direttorio" del men corrispondente al
       *  Place passato (accede a "rootDir").
       */
    public static DirExplorerItem chePlaceDir (PlaceID placeID) {
        String stringa;
        if (placeID.isDomain())
            stringa = placeID.domain;
        else
            stringa = placeID.place;
        return (DirExplorerItem) rootDir.getItem(stringa);
    } //chePlaceDir
    
      /**
       *  Crea un place di default o un place normale da una stringa di invocazione.
       *  Tutto ci che occorre  passato attraverso la stringa "invocazione".
       *  L'invocazione dice al Creatore cosa si vuole che venga creato e 
       *  buona cosa che sia creata attraverso i metodi "invocaPlaceDefault"
       *  o "invocaPlace" oppure che sia una stringa letta dal file di salvataggio
       *  dei dati dei place.
       *  L'oggetto "Anagrafe" passato verr avvisato dell'avvenuta creazione del place;
       *  porre Anagrafe=null se NON si vuole mantenerne traccia.
       *  Sfruttando il late-binding, l'Environment reso pu essere un:
       *  Environment, MobilbeEnvironment, SecurityEnvironment.
       */
    public static Environment crea (String invocazione, Anagrafe anagrafe) throws Exception {
        final Environment env;  // cio' che render
        if (primaVolta)
            CaricaMiaLingua();
        
        StringTokenizer separatore = new StringTokenizer (invocazione);
        String header = separatore.nextToken();
        
        Debug.outln ("Creatore - creo "+invocazione+" --> ");
        
        if (header.equals(CREA_PLACEDEF)) {        // CREAZIONE DI UN PLACE DI DEFAULT
            Debug.outln ("Creatore - invocazione di creazione PLACE DI DEFAULT");
            // PRELEVA E CONTROLLA I DATI
            // ognuna delle seguenti linee puo' generare un'eccezione (che NON viene presa qui)
            String usaSic, domNome, regAddr;
            int    regPorta, domPorta;
            InetAddress regInetAddr;
            
            usaSic = separatore.nextToken();
            boolean sicuro = (usaSic.equals(SICURO_SI));
            if (sicuro)
                abilitaSicurezza();
            
            domNome = separatore.nextToken();
            try {
                domPorta   = Integer.parseInt (separatore.nextToken());
            }
            catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_PPOR_MALF")); }
            if (separatore.hasMoreTokens()) {
                regAddr  = separatore.nextToken();
                try {
                    regInetAddr = InetAddress.getByName(regAddr);
                }
                catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_REG_UNKNOW")); }
                try {
                    regPorta = Integer.parseInt (separatore.nextToken());
                }
                catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_RPOR_MALF")); }
            } //if
            else {
                regAddr  = "";        // nessun DNS PADRE
                regInetAddr = null;
                regPorta = 0;
            }
            
            // CREO IL PLACE DI DEFAULT
            Debug.outln ("Creatore - Creando il Place di Default "+ domNome+" "+domPorta);
            
            PlaceID domainID = new PlaceID (domNome, "");
            
            DirExplorerItem domainDir = new DirExplorerItem(domainID.domain);
            
            domainDir.setSyntax("Domain " + domainDir.getSyntax());
            
            PrintStream nullOut = new PrintStream (new NullOutputStream());  // NON VOGLIO STAMPARE I MESSAGGI DI DEBUG!
            if (! sicuro)
                env = new Environment (domainID, domainDir, domPorta, System.in, nullOut, nullOut,false);
            else
                env = new SecurityEnvironment (domainID, domainDir, domPorta, System.in, nullOut, nullOut);
            
            // REGISTRO IL PLACE DI DEFAULT - il suo DNS (SOLO SE regAddr<>"")
            if (! regAddr.equals("")) {
                Debug.outln ("Creatore - Registrandolo DNS a "+regInetAddr+ " "+ regPorta);
                
                boolean ok = env.domainNameService.register (regInetAddr, regPorta);    // esegue la registrazione!
                
                if (!ok )
                    throw new Exception (Lingua.frase("CRE_ERR_REGIS_DNS"));
            } //if
            else
            {
                Debug.outln ("Creatore -  un DNS RADICE: non lo registro");
            }
            if (anagrafe != null) {
                anagrafe.ricordaRegistrazioneLocaleDNS (domainID, regPorta);
                anagrafe.battezzaPlace (env);   // Battezzo il place (genera eventuale evento di cambiamento)
            }
            
            rootDir.addItem (domainDir);
        }
        
        else
            if (header.equals(CREA_PLACENOR)) {        // CREAZIONE DI UN PLACE "normale"
                Debug.outln ("Creatore - invocazione di creazione PLACE NORMALE");
                // PRELEVA E CONTROLLA I DATI
                // ognuna delle seguenti linee puo' generare un'eccezione (che non viene presa qui)
                String usaSic, domNome, placeNome, regAddr;
                int    placePorta, regPorta;
                InetAddress regInetAddr;
                
                usaSic = separatore.nextToken();
                boolean sicuro = (usaSic.equals(SICURO_SI));
                if (sicuro)
                    abilitaSicurezza();
                
                domNome   = separatore.nextToken();
                placeNome = separatore.nextToken();
                try {
                    placePorta   = Integer.parseInt (separatore.nextToken());
                }
                catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_PPOR_MALF")); }
                regAddr   = separatore.nextToken();
                try {
                    regInetAddr = InetAddress.getByName(regAddr);
                }
                catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_REG_UNKNOW")); }
                try {
                    regPorta     = Integer.parseInt (separatore.nextToken());
                }
                catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_RPOR_MALF")); }
                
                // CREO IL PLACE
                Debug.outln ("Creatore - Creando il Place "+ domNome+" "+placeNome+" "+placePorta);
                
                PlaceID placeID = new PlaceID (domNome, placeNome);
                
                DirExplorerItem placeDir = new DirExplorerItem (placeID.place);
                placeDir.setSyntax("Place " + placeDir.getSyntax());
                
                PrintStream nullOut = new PrintStream (new NullOutputStream());  // NON VOGLIO STAMPARE I MESSAGGI DI DEBUG!
                if (! sicuro)
                    env = new Environment (placeID, placeDir, placePorta, System.in, nullOut, nullOut,false);
                else
                    env = new SecurityEnvironment (placeID, placeDir, placePorta, System.in, nullOut, nullOut);
                
                // REGISTGRO IL PLACE (SEMPRE!)
                boolean ok = env.placeNameService.register (regInetAddr, regPorta);    // esegue la registrazione!
                if (!ok )
                    throw new Exception (Lingua.frase("CRE_ERR_REGIS_PNS"));
                
                if (anagrafe != null)
                    anagrafe.battezzaPlace (env);   // Battezzo il place (ne tiene traccia)
                
                rootDir.addItem (placeDir);
            }
        
            else
                if (header.equals(CREA_PLACEMOB)) {        // CREAZIONE DI UN PLACE "MOBILE"
                    Debug.outln ("Creatore - invocazione di creazione PLACE MOBILE");
                    // PRELEVA E CONTROLLA I DATI
                    // ognuna delle seguenti linee puo' generare un'eccezione (che non viene presa qui)
                    String domNome, placeNome, regAddr;
                    int    placePorta, regPorta;
                    InetAddress regInetAddr;
                    
                    domNome   = separatore.nextToken();
                    placeNome = separatore.nextToken();
                    try {
                        placePorta   = Integer.parseInt (separatore.nextToken());
                    }
                    catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_PPOR_MALF")); }
                    regAddr   = separatore.nextToken();
                    try {
                        regInetAddr = InetAddress.getByName(regAddr);
                    }
                    catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_REG_UNKNOW")); }
                    try {
                        regPorta     = Integer.parseInt (separatore.nextToken());
                    }
                    catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_RPOR_MALF")); }
                    
                    // CREO IL PLACE
                    Debug.outln ("Creatore - Creando il Place Mobile "+ domNome+" "+placeNome+" "+placePorta);
                    
                    PlaceID placeID = new MobilePlaceID (domNome, placeNome);
                    
                    DirExplorerItem placeDir = new DirExplorerItem (placeID.place);
                    placeDir.setSyntax("Mobile Place " + placeDir.getSyntax());
                    
                    PrintStream nullOut = new PrintStream (new NullOutputStream());  // NON VOGLIO STAMPARE I MESSAGGI DI DEBUG!
                    env = new MobileEnvironment (placeID, placeDir, placePorta, System.in, nullOut, nullOut);
                    
                    // REGISTGRO IL PLACE (SEMPRE!)
                    boolean ok = env.placeNameService.register (regInetAddr, regPorta);    // esegue la registrazione!
                    if (!ok)
                        throw new Exception (Lingua.frase("CRE_ERR_REGIS_PNS"));
                    
                    if (anagrafe != null)
                        anagrafe.battezzaPlace (env);   // Battezzo il place (ne tiene traccia)
                    
                    rootDir.addItem (placeDir);
                }
        
                else
                    throw new Exception (Lingua.frase("CRE_ERR_UNK_HEADER")+": '"+header+"'");
        
        return env;
    } //crea
    
    protected static void abilitaSicurezza () {
        try {
            
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null ) {
                securityManager = new SecurityManager();
                System.setSecurityManager (securityManager);
            }
        }
        catch (Exception e) {
            OiDialogoi.mostraErrore (e);
        }
    } //abilitaSicurezza
    
      /**
       *  Rende la stringa di invocazione (da dare a "crea") per la creazione
       *  di un place di default relativo al dominio domNome, sulla porta domPorta
       *  e la cui registrazione del DNS verr effettuata verso il processo presente
       *  sul computer all'indirizzo IP regAddr e sulla porta regPorta.
       *  Viene generata un eccezione se un qualsiasi dato non  corretto.
       */
    public static String invocaPlaceDefault (String domNome, int domPorta,
    String regAddr, int regPorta,
    boolean usaSicurezza) throws Exception {
        return invocaPlaceDefault (domNome, String.valueOf(domPorta),
        regAddr, String.valueOf(regPorta),
        usaSicurezza);
    } //invocaPlaceDefault
    
      /**
       *  Analoga alla precedente, ma i numeri di porta sono delle stringhe
       *  anzich dei numeri interi.
       *  Viene generata un eccezione se un qualsiasi dato non  corretto.
       */
    public static String invocaPlaceDefault (String domNome, String domPorta,
    String regAddr, String regPorta,
    boolean usaSicurezza) throws Exception {
        if (primaVolta)
            CaricaMiaLingua();
        String trimDom = domNome.trim();  // Toglo spazi a inizio e fine
        if (trimDom.equals(""))     throw new Exception (Lingua.frase("CRE_ERR_PLA_EMPTY"));
        if (trimDom.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_PLA_NOBLNK"));
        int tmpPort;
        try {
            tmpPort = Integer.valueOf(domPorta).intValue();
        }
        catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_PPOR_MALF")); }
        if (tmpPort < 1024)   throw new Exception (Lingua.frase("CRE_ERR_PPRO_1024"));
        if (tmpPort > 65535)  throw new Exception (Lingua.frase("CRE_ERR_PPRO_64K"));
        if (! regAddr.equals("")) {
            if (regAddr.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_REG_NOBLNK"));
            try {
                tmpPort = Integer.valueOf(regPorta).intValue();
            }
            catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_RPOR_MALF")); }
            if (tmpPort < 1024)   throw new Exception (Lingua.frase("CRE_ERR_RPOR_1024"));
            if (tmpPort > 65535)  throw new Exception (Lingua.frase("CRE_ERR_RPOR_64K"));
        }
        String sicuro;
        if (usaSicurezza)
            sicuro = SICURO_SI;
        else
            sicuro = SICURO_NO;
        
        String dominee = new String (CREA_PLACEDEF +" "+ sicuro +" "+
        trimDom +" "+ domPorta +" "+
        regAddr +" "+ regPorta);
        Debug.outln ("Creatore: creata invocazione '"+dominee+"'");
        return dominee;
    } //invocaPlaceDefault
    
      /**
       *  Rende la stringa di invocazione (da dare a "crea") per la creazione
       *  di un place (normale) contenuto nel dominio domNome e col nome placeNome,
       *  sulla porta domPorta e la cui registrazione del PNS (nota: PNS e non DNS)
       *  verr effettuata verso il processo presente sul computer all'indirizzo
       *  IP regAddr e sulla porta regPorta (tale indicazione DEVE fare riferimento
       *  al place di default del dominio domNome in cui il place sar contenuto).
       *  Viene generata un eccezione se un qualsiasi dato non  corretto.
       */
    public static String invocaPlace (String domNome, String placeNome, int placePorta,
    String regAddr, int regPorta,
    boolean usaSicurezza) throws Exception {
        return invocaPlace (domNome, placeNome, String.valueOf(placePorta),
        regAddr, String.valueOf(regPorta),
        usaSicurezza);
    } //invocaPlace
    
      /**
       *  Analoga alla precedente, ma i numeri di porta sono delle stringhe
       *  anzich dei numeri interi.
       *  Viene generata un eccezione se un qualsiasi dato non  corretto.
       */
    public static String invocaPlace (String domNome, String placeNome, String placePorta,
    String regAddr, String regPorta,
    boolean usaSicurezza) throws Exception {
        if (primaVolta)
            CaricaMiaLingua();
        String trimDom = domNome.trim();  // Toglo spazi a inizio e fine
        if (trimDom.equals("")) throw new Exception (Lingua.frase("CRE_ERR_DOM_EMPTY"));
        if (trimDom.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_DOM_NOBLNK"));
        String trimPlace = placeNome.trim();  // Toglo spazi a inizio e fine
        if (trimPlace.equals("")) throw new Exception (Lingua.frase("CRE_ERR_PLA_EMPTY"));
        if (trimPlace.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_PLA_NOBLNK"));
        int tmpPort;
        try {
            tmpPort = Integer.valueOf(placePorta).intValue();
        }
        catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_PPOR_MALF")); }
        if (tmpPort < 1024)  throw new Exception (Lingua.frase("CRE_ERR_PPRO_1024"));
        if (tmpPort > 65535) throw new Exception (Lingua.frase("CRE_ERR_PPRO_64K"));
        if (regAddr.equals("")) throw new Exception (Lingua.frase("CRE_ERR_REG_EMPTY"));
        if (regAddr.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_REG_NOBLNK"));
        try {
            tmpPort = Integer.valueOf(regPorta).intValue();
        }
        catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_RPOR_MALF")); }
        if (tmpPort < 1024)  throw new Exception (Lingua.frase("CRE_ERR_RPOR_1024"));
        if (tmpPort > 65535) throw new Exception (Lingua.frase("CRE_ERR_RPOR_64K"));
        String sicuro;
        if (usaSicurezza)
            sicuro = SICURO_SI;
        else
            sicuro = SICURO_NO;
        
        String dominee = new String (CREA_PLACENOR +" "+ sicuro +" "+
        trimDom +" "+ trimPlace +" "+ placePorta +" "+
        regAddr +" "+ regPorta);
        Debug.outln ("Creatore: creata invocazione '"+dominee+"'");
        return dominee;
    } //invocaPlace
    
      /**
       *  Rende la stringa di invocazione (da dare a "crea") per la creazione
       *  di un place mobile contenuto nel dominio domNome e col nome placeNome,
       *  sulla porta domPorta e la cui registrazione del PNS (nota: PNS e non DNS)
       *  verr effettuata verso il processo presente sul computer all'indirizzo
       *  IP regAddr e sulla porta regPorta (tale indicazione DEVE fare riferimento
       *  al place di default del dominio domNome in cui il place sar contenuto).
       *  Viene generata un eccezione se un qualsiasi dato non  corretto.
       */
    public static String invocaPlaceMobile (String domNome, String placeNome, int placePorta,
    String regAddr, int regPorta) throws Exception {
        return invocaPlaceMobile (domNome, placeNome, String.valueOf(placePorta),
        regAddr, String.valueOf(regPorta));
    } //invocaPlaceMobile
    
      /**
       *  Analoga alla precedente, ma i numeri di porta sono delle stringhe
       *  anzich dei numeri interi.
       *  Viene generata un eccezione se un qualsiasi dato non  corretto.
       */
    public static String invocaPlaceMobile (String domNome, String placeNome, String placePorta,
    String regAddr, String regPorta) throws Exception {
        if (primaVolta)
            CaricaMiaLingua();
        String trimDom = domNome.trim();  // Toglo spazi a inizio e fine
        if (trimDom.equals("")) throw new Exception (Lingua.frase("CRE_ERR_DOM_EMPTY"));
        if (trimDom.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_DOM_NOBLNK"));
        String trimPlace = placeNome.trim();  // Toglo spazi a inizio e fine
        if (trimPlace.equals("")) throw new Exception (Lingua.frase("CRE_ERR_PLA_EMPTY"));
        if (trimPlace.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_PLA_NOBLNK"));
        int tmpPort;
        try {
            tmpPort = Integer.valueOf(placePorta).intValue();
        }
        catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_PPOR_MALF")); }
        if (tmpPort < 1024)  throw new Exception (Lingua.frase("CRE_ERR_PPRO_1024"));
        if (tmpPort > 65535) throw new Exception (Lingua.frase("CRE_ERR_PPRO_64K"));
        if (regAddr.equals("")) throw new Exception (Lingua.frase("CRE_ERR_REG_EMPTY"));
        if (regAddr.indexOf(' ')>0) throw new Exception (Lingua.frase("CRE_ERR_REG_NOBLNK"));
        try {
            tmpPort = Integer.valueOf(regPorta).intValue();
        }
        catch (Exception E) { throw new Exception (Lingua.frase("CRE_ERR_RPOR_MALF")); }
        if (tmpPort < 1024)  throw new Exception (Lingua.frase("CRE_ERR_RPOR_1024"));
        if (tmpPort > 65535) throw new Exception (Lingua.frase("CRE_ERR_RPOR_64K"));
        
        String dominee = new String (CREA_PLACEMOB +" "+
        trimDom +" "+ trimPlace +" "+ placePorta +" "+
        regAddr +" "+ regPorta);
        Debug.outln ("Creatore: creata invocazione '"+dominee+"'");
        return dominee;
    } //invocaPlaceMobile
    
      /**
       *  Rende true se esiste il file di salvataggio delle configurazioni dei place.
       */
    public static boolean esisteConfigSalvata () {
        // rende true se c' una configurazione di place salvata su disco.
        try {
            FileInputStream FIS = new FileInputStream (FILE_PLACES);  // PROVO A APRIRE IL FILE DI PLACES
            FIS.close();
            return true;
        }
        catch (Exception E) {
            return false;
        }
    } //esisteConfigSalvata
    
      /**
       *  Carica il file di configurazione dei place (precedentemente salvato) e
       *  crea uno a uno ogni place.
       *  Dal file vengono lette le "stringhe di invocazione" che vengono passate a "crea".
       *  Al ritorno viene reso un array di {@link SOMA.Environment} che identificano
       *  tutti i place creati.
       *  Se l'array ha dimensione zero, nessun place  stato creato.
       *  Nota: durante il caricamento viene mostrata una finestra di dialogo con una barra
       *  che indica il progresso nella creazione.
       *  L'oggetto {@link SOMA.gui.Anagrafe} passato verr avvisato dei place creati.
       *  Se non lo si vuole avvisare, porre Anagrafe=null nella chiamata.
       */
    public static Environment[] caricaConfigSalvata (Anagrafe anagrafe) {
        Debug.outln("Creatore - Caricando la configurazione PLACE da disco..");
        if (primaVolta)
            CaricaMiaLingua();
        Environment[] envArr = new Environment [50];
        int i = 0;
        int max = cheDimensConfigSalvata ();
        
        JFrame mioDialog = new JFrame ();
        mioDialog.setResizable(false);
        Container contentPane = mioDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JLabel lab1 = new JLabel(Lingua.frase("CRE_CREANDO_UP"));
        JPanel pan1 = new JPanel();
        pan1.add (lab1);
        contentPane.add(pan1, BorderLayout.NORTH);
        // Metto la label in un pannello e poi nel conentPane, senn non viene centrata!
        
        JProgressBar progressBar = new JProgressBar (0, max);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        contentPane.add(progressBar, BorderLayout.CENTER);
        
        JLabel lab2 = new JLabel(Lingua.frase("CRE_CREANDO_DW"));
        JPanel pan2 = new JPanel();
        pan2.add (lab2);
        contentPane.add(pan2, BorderLayout.SOUTH);
        
        contentPane.add(Box.createRigidArea(new Dimension(10,4)), BorderLayout.EAST);
        contentPane.add(Box.createRigidArea(new Dimension(10,4)), BorderLayout.WEST);
        
        mioDialog.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        mioDialog.addWindowListener(new ListExit(ListExit.EXIT_SOMA));
        mioDialog.setLocation(180,190);
        mioDialog.pack();
        mioDialog.setVisible (true);
        
        try {
            FileInputStream FIS = new FileInputStream (FILE_PLACES);  // PROVO A APRIRE IL FILE DI PLACES
            DataInputStream DIS = new DataInputStream (FIS);
            
            try {
                String linea = DIS.readUTF();
                while (linea != null) {
                    
                    try {
                        
                        envArr[i] = crea (linea, anagrafe);      // Invoca metodo di CREAZIONE!
                        
                    }
                    catch (final Exception eccezzziunale) {
                        SwingUtilities.invokeLater (new Runnable () {
                            public void run () {
                                OiDialogoi.mostraErrore (eccezzziunale);
                            } //run
                        }); //invokeLater
                    }
                    
                    i++;
                    progressBar.setValue(i);
                    
                    linea = DIS.readUTF();         // Passa alla prossima linea
                } //while
            }
            catch (java.io.EOFException E) { }  // uscita (brutale)
            FIS.close();
            
        }
        catch (final Exception eccezzziunale) {
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    OiDialogoi.mostraErrore (eccezzziunale);
                } //run
            }); //invokeLater
        }
        
        mioDialog.setVisible(false);
        mioDialog.dispose();
        
        Environment[] envArr2 = new Environment [i];
        for (int j=0; j<i; j++)
            envArr2[j] = envArr[j];
        return envArr2;
    } //caricaConfigSalvata
    
      /**
       *  Rende la dimensione del file di configurazione dei place (precedentemente salvato).
       *  La dimensione  intesa in "numero di stringhe di invocazione" distinte.
       */
    public static int cheDimensConfigSalvata () {
        int i = 0;
        try {
            FileInputStream FIS = new FileInputStream (FILE_PLACES);  // PROVO A APRIRE IL FILE DI PLACES
            DataInputStream DIS = new DataInputStream (FIS);
            try {
                String linea = DIS.readUTF();
                while (linea != null) {
                    i++;
                    linea = DIS.readUTF();         // Passa alla prossima linea
                } //while
            }
            catch (java.io.EOFException E) { }  // uscita (brutale)
            FIS.close();
        }
        catch (Exception E) { }
        return i;
    } //cheDimensConfigSalvata
    
      /**
       *  Salva la "stringa di invocazione" sul file di configurazione dei place.
       *  Se "append" vale true, la stringa viene accodata alla fine del file;
       *  altrimenti il file viene cancellato e riempito con la sola stringa passata.
       */
    public static void salvaConfigPlace (final String invocazione, final boolean append) throws Exception {
        try {
            
            Debug.outln("Creatore - Salvando la configurazione PLACE su disco..");
            FileOutputStream FOS = new FileOutputStream (FILE_PLACES, append);
            DataOutputStream DOS = new DataOutputStream (FOS);
            DOS.writeUTF (invocazione);
            FOS.close();
            
        }
        catch (Exception eccez) {
            OiDialogoi.mostraErrore (eccez);
        }
    } //salvaConfigPlace
    
      /**
       *  Cancella il file di salvataggio delle invocazioni.
       */
    public static void cancellaConfigPlace () {
        try {
            
            Debug.outln("Creatore - Cancellando la configurazione PLACE su disco..");
            File F = new File (FILE_PLACES);
            F.delete ();
            
        }
        catch (Exception eccez) {
            OiDialogoi.mostraErrore (eccez);
        }
    } //cancellaConfigPlace
    
      /**
       *  Lancia un agente, dato l'{@link SOMA.Environment} del place.
       *  Viene lanciato nel place di ambiente "env" l'agente il cui nome  contenuto in "nomeAgente"
       *  (senza estensione ".class") con i parametri "arrParam".
       *  Sono disponibili parametri aggiuntivi: "usaSysClassLoader" (per usare il caricatore di classi
       *  di sistema), "rintracciabile" (per far s che si possa sempre sapere la posizione dell'agente)
       *  e "nonFarloPartire" (per creare l'agente senza che ne sia messo in esecuzione il suo "worker").
       */
    public static void lanciaAgente (Environment env,
    String nomeAgente, String[] arrParam,
    boolean usaSysClassLoader, boolean rintracciabile,
    boolean nonFarloPartire) throws Exception {
        lanciaAgente (env, nomeAgente, arrParam,
        usaSysClassLoader, rintracciabile, nonFarloPartire,
        null, null);
    } //lanciaAgente
    
      /**
       *  Lancia un agente, dato l'{@link SOMA.Environment} del place.
       *  Come la precedente, ma ha i parametri per la sicurezza (profilo e password)
       */
    public static void lanciaAgente (Environment env,
    String nomeAgente, String[] arrParam,
    boolean usaSysClassLoader, boolean rintracciabile,
    boolean nonFarloPartire,
    String profileFileName,
    String profilePassword) throws Exception {
        if (env == null)
            throw new Exception (Lingua.frase("CRE_ERR_NOTENV"));
        
        AgentWorker agentWorker;
        
        if (false) {  /*c'era questo, ma non riesco a compilare altrimenti: env instanceof SecurityEnvironment*/
/*      ProfileManager profile;
      try {
        ProfileManager envProfile = ((SecurityEnvironment)env).profile;
        boolean onLine = false;
        Infrastructure pki = null;
        if (envProfile != null) {
          pki = envProfile.getEntrustInfrastructure();
          if (pki != null)
            onLine = pki.getOnLine();
        }
        profile = new ProfileManager (pki);
        profile.logonProfile (profileFileName, profilePassword, onLine);
 
      }
      catch (Exception ecc1) {
        throw new Exception (Lingua.frase("CRE_ERR_CANTLOGON"));
      }
 
      agentWorker =
        ((AgentManagerSecurity)env.agentManager).createAgent(nomeAgente, arrParam,
                                                             usaSysClassLoader, rintracciabile,
                                                             profile);
      if (profile != null)
        profile.logoffProfile();
 */
        }
        else {  // ENVIRONMENT NORMALE (NON SICURO)
            // CREO L'AGENT-WORKER!
            agentWorker =
            env.agentManager.createAgent (nomeAgente, arrParam,
            usaSysClassLoader, rintracciabile);
        }
        
        // o per lo meno, ci ho provato:
        if (agentWorker == null)
            throw new Exception (Lingua.frase("CRE_ERR_CREATE"));
        
        if (! nonFarloPartire)
            agentWorker.start();     // LANCIO L'AGENTE (pu generare eccezione)!
        
    } //lanciaAgente
    
} //Creatore