package SOMA.ext.PNSManagement;

import SOMA.naming.*;
import SOMA.network.connection.*;

/** 
 * Rimozione di un place dal PNS dello slave.
 *
 * @author Alessandro Ghigi
 */
public class SlavePNSRemoveCommand extends Command {
	
	PlaceID toRemove;
	
	/** Costruttore. */
	public SlavePNSRemoveCommand(PlaceID toRemove) {
		this.toRemove = toRemove;
	}
	
	/** Rimozione di un dominio dal PNS dello slave. */
	public void run() {
		env.out.println("Removing " + toRemove + " from PNS...");
		// Rimozione del dominio dalla tabella
		env.placeNameService.getPlaces().remove(toRemove);
	}
	
}