package SOMA.ext.PNSManagement;

import SOMA.naming.place.PlaceInfo;
import SOMA.network.connection.*;

/** 
 * Registrazione di un nuovo Place presso il PNS dello slave.
 *
 * @author Alessandro Ghigi
 */
public class SlavePNSRefreshCommand extends Command {
	
	PlaceInfo myPlaceInfo;
	
	/** Costruttore. */
	public SlavePNSRefreshCommand(PlaceInfo myPlaceInfo) {
		this.myPlaceInfo = myPlaceInfo;
	}
	
	/** 
	 * Registra il place.
	 * Se un place con lo stesso nome era gia' presente, gli viene spedito un messaggio di errore.
	 */
	public void run() {
		if(env.placeNameService.getPlace(myPlaceInfo.placeID) == null) {
			env.out.println("Updating my PNS with entry: " + myPlaceInfo);
			// Inserimento del place nella tabella
			env.placeNameService.getPlaces().put(myPlaceInfo.placeID,myPlaceInfo);
		}
		else env.err.println("ERROR: Place " + myPlaceInfo + " already exists!");
	}
	
}