package SOMA.ext.NetManagement;

import SOMA.network.connection.*;
import SOMA.naming.*;

/** 
 * Operazioni sulle connessioni permanenti riflesse sullo slave.
 *
 * @author Alessandro Ghigi
 */
public class SlavePermConnectionRefreshCommand extends Command {
	
	PlaceID placeID;
	int kind;
	
	/** Costruttore. */
	public SlavePermConnectionRefreshCommand(PlaceID placeID,int kind) {
		this.placeID = placeID;
		this.kind = kind;
	}
	
	/** Operazioni sulle connessioni permanenti riflesse sullo slave. */
	public void run() {
		// Operazione di start
		if(kind == 1) {
			env.out.println("Updating the starting of a permanent connection with " + placeID);
			env.networkManager.startPermanentConnection(placeID);
		}
		// Operazione di stop
		else {
			env.out.println("Updating the stopping of a permanent connection with " + placeID);
			env.networkManager.stopPermanentConnection(placeID);
		}
	}
	
}