package SOMA.ext.NetManagement;

import SOMA.network.connection.*;
import SOMA.naming.*;

/** 
 * Aggiornamento delle connessioni permanenti presso i domini che avevano una connessione col dominio prima della caduta.
 *
 * @author Alessandro Ghigi
 */
public class SlavePeerConnectionRefreshCommand extends Command {
	
	PlaceID peerPlaceID;
	PlaceID sender;
	
	/** Costruttore. */
	public SlavePeerConnectionRefreshCommand(PlaceID peerPlaceID,PlaceID sender) {
		this.peerPlaceID = peerPlaceID;
		this.sender = sender;
	}
	
	/** Aggiornamento delle connessioni permanenti presso i domini che avevano una connessione col dominio prima della caduta. */
	public void run() {
		// Aggiornamento delle connessioni: viene fornito l'ID del place caduto
		env.networkManager.refreshPeerPermanentConnections(peerPlaceID,sender);
	}
}