package SOMA.ext.Main;

import java.util.*;

import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.network.connection.*;

/** 
 * Ricezione dello stato del Master da parte dello Slave: DNS, PNS, riferimenti gerarchici e connessioni permanenti.
 *
 * @author Alessandro Ghigi
 */

public class SendInfoCommand extends Command {
	
	// Informazioni di stato
	PlaceInfo masterInfo;
	Hashtable domains;
	Hashtable places;
	PlaceID fatherDNS;
	Vector childrenDNS;
	Hashtable permanentConnections;
	
	/** Costruttore. */
	public SendInfoCommand(PlaceInfo masterInfo,Hashtable domains,Hashtable places,PlaceID fatherDNS,Vector childrenDNS,Hashtable permanentConnections) {
		this.masterInfo = masterInfo;
		this.domains = domains;
		this.places = places;
		this.fatherDNS = fatherDNS;
		this.childrenDNS = childrenDNS;
		this.permanentConnections = permanentConnections;
	}
	
	/** Ricezione dello stato del Master da parte dello Slave: DNS, PNS, riferimenti gerarchici e connessioni permanenti. */
	public void run() {
		env.out.println("Receiving connection info from my Master...");
		// Impostazione placeInfo del master
		env.masterInfo = masterInfo;
		// Impostazione domini (DNS)
		env.domainNameService.setDomains(domains);
		// Impostazione places (PNS)
		env.placeNameService.setPlaces(places);
		// Impostazione eventuale riferimento al dominio padre
		env.domainNameService.setFatherDNS(fatherDNS);
		// Impostazione eventuali riferimenti a domini figli
		env.domainNameService.setChildrenDNS(childrenDNS);
		// Impostazione connessioni permanenti
		env.networkManager.setPermanentConnections(permanentConnections);
		// Avvio thread di interrogazione, se nn ancora attivo
		if(!env.pollingThread.isAlive()) {
			env.pollingThread.start();
			try {
				env.pollingThread.join();	
			}
			catch(Exception e) {
				e.printStackTrace();
			
			}
		}
		env.out.println("I'm ready!");
	}
	
}