package SOMA.ext.Main;

import java.io.*;
import java.net.*;
import java.util.*;
import SOMA.Environment;
import SOMA.explorer.*;
import SOMA.naming.*;

/** 
 * Voce di menu per la creazione di un default place slave. 
 *
 * @author Alessandro Ghigi
 */

public class NewSlaveExplorerItem extends ExplorerItem {
	
	DirExplorerItem dir;
	
	public NewSlaveExplorerItem(DirExplorerItem dir) {
		super("<domain_name> <port> <master_address> <master_port>");
		this.dir = dir;
	}
	
	/** 
	 * Metodo di esecuzione del comando: crea lo slave.
	 * I parametri richiesti sono il nome di dominio, l'indirizzo del master,
	 * e la porta di ascolto del server del master.
	 * Vengono creati l'Environment dello slave ed un sottomenu chiamato col suo nome.
	 */
	public Object Execute(Collection Parameters,PrintStream out) {
		if(Parameters.size() == 4) {
			Iterator i = Parameters.iterator();
			PlaceID domainID = new PlaceID((String)i.next(),"");
			String portS = (String)i.next();
			int port = 0;
			try {
				port = Integer.parseInt(portS);
			}
			catch(Exception e) {
				out.println("ERROR: incorrect port number " + portS);
				return null;
			}
			// Creazione directory
			DirExplorerItem domainDir = new DirExplorerItem(domainID.domain);
			domainDir.setSyntax("Domain " + domainDir.getSyntax());
			Environment slave = null;
			try {
				// Creazione environment
				slave = new Environment(domainID,domainDir,port,System.in,out,out,true);
				dir.addItem(domainDir);
				out.println("Slave " + slave + " created!" );
			}
			catch( Exception e) {
				e.printStackTrace(out);
			}
			// Indirizzo del master
			InetAddress masterAddress = null;
			try {
				masterAddress = InetAddress.getByName((String)i.next());
			}
			catch(UnknownHostException e) {
				e.printStackTrace();
			}
			// Porta del master
			String masterPortS = (String)i.next();
			int masterPort = 0;
			try {
				masterPort = Integer.parseInt(masterPortS);
			}
			catch(Exception e) {
				out.println("ERROR: incorrect port number " + masterPortS);
				return null;
			}
			// Invio comando di "presentazione" al master e relativo duplice scambio di informazioni
			try {
				slave.out.println("Sending connection info to my Master...");
				slave.networkManager.contactMaster(masterAddress,masterPort);
			}
			catch(Exception e) {
				e.printStackTrace();
			}
			return slave;
		}
		return null;
	}
	
	public String Help( PrintStream out ) {
		String help = "domain_name port: Creates a new slave using the specified port.";
		out.println( help );
		return help;
	}
	
}