package SOMA.ext.Main;

import SOMA.network.connection.Command;

/** 
 * Comando di presentazione inviato da Slave a Master, il quale salva la connessione ed invia il proprio stato al pari.
 *
 * @author Alessandro Ghigi
 */

public class MeetCommand extends Command {
	
	public MeetCommand() {
	}
	
	/** Comando di presentazione inviato da Slave a Master, il quale salva la connessione ed invia il proprio stato al pari. */
	public void run() {
		env.out.println("Received connection info from my Slave! Sending my state to it...");
		// Impostazione della connessione sulla quale avverranno tutte le comunicazioni tra master e slave
		env.repConnection = ReturnConnection;
		// Invio comando di risposta contenente lo stato del Master
		Return(new SendInfoCommand(env.networkManager.placeInfo,env.domainNameService.getDomains(),env.placeNameService.getPlaces(),env.domainNameService.getParentDNS(),env.domainNameService.getChildrenDNS(),env.networkManager.getPermanentConnections()));
	}
	
}