package SOMA.ext.Main;

import SOMA.ext.NetManagement.*;
import SOMA.naming.*;
import SOMA.naming.domain.*;
import SOMA.network.connection.Command;
import java.util.*;

/** 
 * Ripristina lo stato del master in seguito a riattivazione.
 *
 * @author Alessandro Ghigi
 */

public class ActivateMasterCommand extends Command {
	
	// Informazioni di stato
	Hashtable domains;
	Hashtable places;
	PlaceID fatherDNS;
	Vector childrenDNS;
	Hashtable permanentConnections;
	
	/** Costruttore. */
	public ActivateMasterCommand(Hashtable domains,Hashtable places,PlaceID fatherDNS,Vector childrenDNS,Hashtable permanentConnections) {
		this.domains = domains;
		this.places = places;
		this.fatherDNS = fatherDNS;
		this.childrenDNS = childrenDNS;
		this.permanentConnections = permanentConnections;
	}
	
	/** Ripristina lo stato del master in seguito a riattivazione. */
	public void run() {
		// Impostazione domini (DNS)
		env.domainNameService.setDomains(domains);
		// Impostazione places (PNS)
		env.placeNameService.setPlaces(places);
		// Impostazione eventuale riferimento al dominio padre
		env.domainNameService.setFatherDNS(fatherDNS);
		// Impostazione eventuali riferimenti a domini figli
		env.domainNameService.setChildrenDNS(childrenDNS);
		// Impostazione connessioni permanenti
		env.networkManager.setPermanentConnections(permanentConnections);
		// Riabilitazione connessioni permanenti
		env.networkManager.refreshPermanentConnections();
		
		// Invio del proprio PlaceInfo a tutti i domini
		env.domainNameService.putDomain((DomainInfo)env.networkManager.placeInfo);
		try {
			Thread.sleep(2000);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		// Invio del proprio placeID a tutti i domini per la riabilitazione delle connessioni permanenti (che essi avevano con lo slave)
		PlaceID sender = env.networkManager.placeInfo.placeID;
		env.domainNameService.sendToAllDomains(new SlavePeerConnectionRefreshCommand(sender,sender),sender);
		// Invio del proprio placeInfo a tutti i places (e riabilitazione conseguente delle connessioni con tali nodi)
		env.placeNameService.putPlace(env.networkManager.placeInfo);
		try {
			Thread.sleep(2000);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		// Salvataggio della nuova connessione
		env.repConnection = ReturnConnection;
	}
	
}