package SOMA.ext.DNSManagement;

import SOMA.naming.*;
import SOMA.network.connection.*;

/** 
 * Rimozione di un dominio dal DNS dello slave.
 *
 * @author Alessandro Ghigi
 */
public class SlaveDNSRemoveCommand extends Command {
	
	PlaceID toRemove;
	
	/** Costruttore. */
	public SlaveDNSRemoveCommand(PlaceID toRemove) {
		this.toRemove = toRemove;
	}
	
	/** Rimozione di un dominio dal DNS dello slave. */
	public void run() {
		env.out.println("Removing " + toRemove + " from DNS...");
		// Rimozione del dominio dalla tabella
		env.domainNameService.getDomains().remove(toRemove);
		// Rimozione del dominio dall'insieme dei domini figli
		env.domainNameService.getChildrenDNS().remove(toRemove);
		// Annullamento dell'eventuale riferimento al dominio padre
		if(toRemove.equals(env.domainNameService.getParentDNS())) env.domainNameService.setFatherDNS(null);
	}
	
}