package SOMA.ext.DNSManagement;

import SOMA.naming.domain.*;
import SOMA.network.connection.*;
import java.util.*;

/** 
 * Registrazione di un nuovo dominio padre presso il DNS dello slave.
 *
 * @author Alessandro Ghigi
 */
public class SlaveDNSFatherRefreshCommand extends Command {
	
	DomainInfo myDomainInfo;
	Hashtable domains;
	
	/** Costruttore. */
	public SlaveDNSFatherRefreshCommand(DomainInfo myDomainInfo,Hashtable domains) {
		this.myDomainInfo = myDomainInfo;
		this.domains = domains;
	}
	
	/** Registrazione di un nuovo dominio padre presso il DNS dello slave. */
	public void run() {
		if(env.domainNameService.getDomain(myDomainInfo.placeID) == null) {
			env.out.println("Updating my DNS with entry: " + myDomainInfo);
			// Viene copiata la tabella del padre
			env.domainNameService.setDomains(domains);
			env.out.println("Updating hierarchical info about the new father DNS...");
			// Viene aggiornato il valore del dominio padre
			env.domainNameService.setFatherDNS(myDomainInfo.placeID);
		}
		else env.err.println("ERROR: Place " + myDomainInfo + " already exists!");
	}
	
}