package SOMA.ext.DNSManagement;

import java.util.*;
import SOMA.naming.domain.*;
import SOMA.network.connection.*;

/** 
 * Registrazione di un nuovo dominio figlio presso il DNS dello slave.
 *
 * @author Alessandro Ghigi
 */
public class SlaveDNSChildRefreshCommand extends Command {
	
	DomainInfo myDomainInfo;
	
	/** Costruttore. */
	public SlaveDNSChildRefreshCommand(DomainInfo myDomainInfo) {
		this.myDomainInfo = myDomainInfo;
	}
	
	/** Registrazione di un nuovo dominio figlio presso il DNS dello slave. */
	public void run() {
		if(env.domainNameService.getDomain(myDomainInfo.placeID) == null) {
			env.out.println("Updating my DNS with entry: " + myDomainInfo);
			// Inserimento del valore nella tabella
			env.domainNameService.getDomains().put(myDomainInfo.placeID,myDomainInfo);
			env.out.println("Updating hierarchical info about the new child DNS...");
			// Registrazione del dominio tra i figli
			Vector children = env.domainNameService.getChildrenDNS();
			children.add(myDomainInfo.placeID);
			env.domainNameService.setChildrenDNS(children);
		}
		else env.err.println("ERROR: Place " + myDomainInfo + " already exists!");
	}
	
}