package SOMA.ext.AgentManagement;

import SOMA.network.connection.*;
import SOMA.agent.*;
import SOMA.agent.mobility.*;
import SOMA.Environment;

/** 
 * Comando per il trasporto di agenti verso uno Slave.
 *
 * @author Alessandro Ghigi
 */

public class SlaveTransportCommand extends Command {
	
	final private AgentPacket agentPacket;
	
	/** Costruttore. */
	public SlaveTransportCommand(Environment env,Agent agent) {
		agentPacket = env.agentManager.packAgent(agent);
	}
	
	/** Salva l'agente presso lo Slave. */
	public void run() {
		try {
			// Impacchettamento dell'agente
			Agent agent = agentPacket.getAgent(env);
			env.out.println("Creating worker for Agent: " + agent.toString() + "...");
			// Creazione (e non esecuzione!) del worker
			AgentWorker worker = env.agentManager.createWorker(agent);
		}
		catch(Exception e) {
			e.printStackTrace(env.err);
		}
	}

}
