package SOMA.ext.AgentManagement;

import SOMA.network.connection.*;
import SOMA.naming.*;

/** 
 * Comando per la rimozione di un agente dallo Slave.
 *
 * @author Alessandro Ghigi
 */

public class RemoveAgentCommand extends Command {
	
	/** ID dell'agente da rimuovere. */
	final private AgentID agentID;
	
	/** Costruttore. */
	public RemoveAgentCommand(AgentID agentID) {
		this.agentID = agentID;
	}
	
	/** Elimina l'agente dall'insieme di workers dello Slave. */
	public void run() {
		try {
			Thread.sleep(10000);
			// Rimozione del worker
			env.agentManager.agentWorkerStore.removeWorker(agentID);
			env.out.println("Agent has GONE from Master; deleting worker for the Agent  " + agentID + " if it's present.");
		}
		catch(Exception e) {
			e.printStackTrace(env.err);
		}
	}

}