package SOMA.explorer;

import java.io.*;
import java.util.*;

/** Voce di menu per leggere e modificare una stringa.
*
* <P> Memorizza la stringa in {@link ExplorerItem#Syntax}
*
* @author Livio Profiri
*/
public class StringExplorerItem extends SOMA.explorer.ExplorerItem
{
  public StringExplorerItem()
  {
    super();
  }

  public StringExplorerItem( String string )
  {
    super( string );
  }

  /** Nessun argomento: visualizza la stringa,
  * 1 argomento: Modifica la stringa.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 0 )
    {
      out.println( Syntax );
    }
    else if( Parameters.size() == 1 )
    {
      String oldString = Syntax;

      String newString = (String)Parameters.iterator().next();

      if( !oldString.equals( newString ) )
        stringChange( oldString, newString, out );
    }

    return Syntax;
  }

  public String Help( PrintStream out )
  {
    out.println( "No argument -> Prints the string." );
    out.println( "1 argument -> New string value. " );

    return Syntax;
  }

  /** Returns the String. */
  public String get()
  {
    return Syntax;
  }

  /** Sostituisce la vecchia con la nuova stringa (se diverse).
  *
  * <P> Ridefinire questo metodo per cambiare il comportamento
  * dell'item: compiere un'azione se necessario.
  */
  public void stringChange( String oldString, String newString, PrintStream out )
  {
    out.println( "Old value: " + oldString  );
    out.println( "New value: " + newString  );

    Syntax = newString;
  }
}