package SOMA.explorer;

import java.io.*;
import java.util.*;

/** {@link SOMA.explorer.ExplorerItem} che mostra come sintassi ({@link SOMA.explorer.ExplorerItem#getSyntax()}) una descrizione dell'oggetto osservato (oggetto.toString()).
*
* Si tratta di un {@link SOMA.explorer.ExplorerItem} generico utilizabile per osservare lo stato di un oggetto.
*
* @author Livio Profiri
*/
public class ObjectExplorerItem extends ExplorerItem
{
  /** @serial*/
  Object myObject;

  /** Costruttore che ha come parametro l'oggetto di cui si osserva lo stato.*/
  public ObjectExplorerItem( Object myObject )
  {
    this.myObject = myObject;
  }

  /** Stampa e restituisce {@link SOMA.explorer.ExplorerItem#getSyntax()}.*/
  public Object Execute( Collection Parameters, PrintStream out )
  {
    out.println( getSyntax() );

    return getSyntax();
  }

  /** Restituisce {@link SOMA.explorer.ExplorerItem#getSyntax()}.*/
  public String toString()
  {
    return getSyntax();
  }

  public String getSyntax()
  {
    return myObject.toString();
  }
}