package SOMA.explorer;

import javax.swing.tree.*;

import java.util.*;
import java.io.*;

import java.security.*;
import javax.security.auth.*;

public class ExplorerTreeNode extends Object implements TreeNode, Enumeration {

  /* La struttura di ciascun nodo e' costituita dall'ExplorerItem ccorrispondente,
     dal riferimento al nodo genitore da un array di nodi figli e dalla key
     corrispondete all'ExplorerItem.
  */
  private ExplorerTreeNode parent;
  private String key;
  private ExplorerItem item;
  private ArrayList sons=new ArrayList();

  private Iterator iter;

  public ExplorerTreeNode(TreeNode parent,String key,ExplorerItem item) {

    this.parent=(ExplorerTreeNode)parent;
    this.key=key;
    this.item=item;

    // Popolo l'albero andando ad attraversare la struttura del SOMA.

    populate();

  }

  public ExplorerTreeNode(ExplorerItem item) {

    this(null,"/",item);

  }

  /**  Questo metodo crea la struttura dei nodi sulla base della struttura
       del SOMA. Accedo alle variabili private della classe DirExplorerItem
       tramite alcuni metodi aggiunti in quest'ultima.
  */


  public void populate() {

    int i,iMax,childCount;

    // Verifico se il nodo puo' avere figli, ovvero se e' una dir

    if (!getAllowsChildren()) return;

    // System.out.println("item: "+this.item);

    i=0;
    iMax=((DirExplorerItem)item).getItemNumber();
    while (i<iMax) {

      String tempKey=(String)((DirExplorerItem)item).getKey(i);
      ExplorerItem tempItem=((DirExplorerItem)item).getItem(i);

      // System.out.println("i= "+i+" iMax="+iMax+" tempkey="+tempKey+" tempItem="+tempItem);

      if (isGUIKey(tempKey)) sons.add(new ExplorerTreeNode(this,tempKey,tempItem));
      i++;

      // System.out.println(sons);

    }

  }

  public String getKey() {

    return this.key;

  }

  public String getSyntax() {

    return this.item.getSyntax();

  }

  // Implemento l'interfaccia di TreeNode

  public TreeNode getChildAt(int childIndex) {

    return (TreeNode)sons.get(childIndex);

  }

  public int getChildCount() {

    return sons.size();

  }

  public TreeNode getParent() {

    return parent;

  }

  public int getIndex(TreeNode node) {

    return sons.indexOf(node);

  }

  public boolean getAllowsChildren() {

    return (item instanceof DirExplorerItem);

  }

  public boolean isLeaf() {

    return sons.isEmpty();

  }

  public Enumeration children() {

    iter=sons.iterator();
    return this;

  }

  public boolean hasMoreElements() {

    return iter.hasNext();

  }

  public Object nextElement() {

    return iter.next();

  }

  // Fine dell'interfaccia di TreeNode

  /** Questo metodo e' il cuore della classe, e' in esso che vanno decise
      le voci di menu da inserire nella GUI. Vengono effettuati due controlli:
      viene verificato che la voce non sia inutile nella GUI (voci come "..","end",
      "exit",ecc.) e poi viene verificato che l'utente legato a questo Thread
      abbia i permessi per quella determinata voce.
  */

  private boolean isGUIKey(String key) {

    boolean status=false;

    // System.out.println("verifica della key: "+key);

    status=status||key.equals("/");
    status=status||key.equals("cd");
    status=status||key.equals("exit");
    status=status||key.equals("..");
    status=status||key.equals("end");

    // Condizioni sui Permessi basati sull'autenticazione.

    // La verifica dei permessi non e' ancora presente

    //Subject activeSubject=Subject.getSubject(AccessController.getContext());
    //System.out.println("Principals :"+activeSubject.getPrincipals());

    return !status;

  }

  /* questo metedo esegue un comando, in paricolare risalgo alla dir
     parente e lancio l'execute della DirExplorerItem corrispondente.
     A questo punto, visto che tale metodo e' chiamato dalla ExplorerThreadGUI
     all'interno del costrutto doAs, tutti i comandi lanciati hanno un soggetto
     corrispondente che ha effettuato il login.

  */

  public void execute(String parameters,PrintStream out) {

      // System.out.println("Parametri: "+parameters);

      //System.out.println("Vado a lanciare: "+this.key+" "+parameters);

      // Le righe qui sotto stampano i principals del soggetto legato
      // a questo thread.

      final AccessControlContext context=AccessController.getContext();

      Subject activeSubject=Subject.getSubject(context);
      System.out.println("Soggetto Attivo che lancia il comando:\n"+activeSubject);
      javax.security.auth.Policy policy = javax.security.auth.Policy.getPolicy();
      try {
        System.out.println(policy.getPermissions(activeSubject,this.getClass().getProtectionDomain().getCodeSource()));
      } catch (Exception ex) {

        System.out.println(ex.getMessage());
      }

      if (parent!=null)
        ((DirExplorerItem)parent.item).Execute(this.key+" "+parameters,out);
      else ((DirExplorerItem)item).Execute(parameters,out);

  }

  public String toString() {

    return this.key;

  }

}
