package SOMA.agent.mobility;

import SOMA.agent.Agent;
import SOMA.Environment;
import SOMA.naming.AgentID;
import java.io.*;

/**
 * Title:        	ubiQoS
 * Copyright:    	Copyright (c) 2002
 * Date:		12/04/2002
 * Description:		Multimedia middleware based in part on precedent versions implemented by Antonio D'Errico and Francesco Baschieri
 * @author 		Luca Foschini
 * @version 		1.0
 *
 */

/**
 * A packetizer for the UbiQoS system agents. This class implements a packetizer for the
 * system agents used in the ubiQoS package. In particular this packetizer moves only the
 * fields of the class and assumes that all the needed code, both for the agent and for 
 * the fields is present in the target location. There is no code mobility in this case,
 * but only mobility of the state of the agent.
 *
 */
public class UbiQoSSystemAgentPacket implements AgentPacket
{
  private final byte[] packet;
  private final AgentID agentID;
  private final String className;

  public UbiQoSSystemAgentPacket( Agent agent )
  {
    agentID = agent.getID();
    className = agent.getClass().getName();

    byte[] thePacket = null;
    try
    {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream( baos );
      oos.writeObject( agent );
      //AgentOutputStream aos = new AgentOutputStream( baos, agent );
      //aos.writeObject( agent );
      thePacket = baos.toByteArray();
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }

    packet = thePacket;
       // packet  un blank final: va inizializzato una
       //   sola volta ed obbligatoriamente

  }

  public AgentID getAgentID()
  {
    return agentID;
  }

  public Agent getAgent( Environment env )
  {            
    Agent theAgent = null;
    try
    {

      ByteArrayInputStream bais = new ByteArrayInputStream( packet );
      ObjectInputStream ois = new ObjectInputStream( bais );
      //ObjectInputStream ois = new ObjectInputStream( bais );

      theAgent = (Agent)ois.readObject();
    }
    catch(Exception e)
    {            
      env.err.println("---PROBLEMS GETTING THIS AGENT: "+className+" "+agentID);
      e.printStackTrace( env.err );
    }


    return theAgent;
  }

  public String toString()
  {
    return "[UbiQoSSystemAgentPacket "+ agentID + ", " + className +"]";
  }
}


