package SOMA.agent.mobility;

import SOMA.agent.*;
import SOMA.Environment;
import SOMA.naming.AgentID;
import java.io.*;
import SOMA.network.connection.Daemon;

public class SavedWorker implements Serializable
{
  public AgentPacket packet;
  public boolean activate = false;

  public SavedWorker( Environment env, AgentWorker worker ) throws AgentWorker.AgentWorkerException
  {
    if( worker.getStatus() == Daemon.ON )
    {
      worker.stop();
      activate = true;
    }
    else
      activate = false;

    Object status = worker.getStatus();

    if( status == Daemon.OFF ||
        status == AgentWorker.IDLE ||
        status == AgentWorker.STOPPED )
    {
      packet = env.agentManager.packAgent( worker.agent );
    }
    else
      throw new AgentWorker.AgentWorkerException( "Cannot save worker: " + worker );
  }

  public AgentID restoreWorker( Environment env ) throws AgentWorker.AgentWorkerException
  {
    AgentID agentID = null;

    Agent agent = packet.getAgent( env );

    if( agent != null )
    {
      AgentWorker worker = env.agentManager.createWorker( agent );

      if( activate )
        worker.start();

      agentID = agent.getID();
    }
    else
      env.out.println( "SavedWorker: Error starting agent: " + packet.getAgentID() );

    return agentID;
  }

  public String toString()
  {
    return "[SavedWorker " + packet + " activate?" + activate +"]";
  }
}