package SOMA.agent.mobility;

import java.security.*;
import SOMA.naming.*;

/** Permesso di accesso a un place.
 *
 * @author Livio Profiri
 */

public class PlaceAccessPermission extends Permission
{
  /** Costruttore.
  *
  * <P> Per rispettare la sintassi di una normale <code>BasicPermission</code>
  * e' stato utilizzato uno stratagemma: il nome del permesso si ottiene
  * separando con un punto il nome di dominio dal il nome di place.
  * <BR><BR> <B>    Esempio:<B> <code>PlaceAccessPermission( Italia.Roma )</code>
  *
  * <P> Questo permette di specificare molto facilmente permessi di vario tipo:
  * <UL>
  * <LI> Accesso a tutti i place di tutti i domini: <code>PlaceAccessPermission( "*" );
  * <LI> Accesso a tutti i place di un dominio: <code>PlaceAccessPermission( "Dominio.*" );
  * <LI> Accesso a un place di un dominio: <code>PlaceAccessPermission( "Dominio.Place" );
  * <LI> Accesso al default place di un dominio: <code>PlaceAccessPermission( "Dominio" );
  * </UL>
  *
  * @author Livio Profiri
  */
  PlaceID placeID;

  public PlaceAccessPermission(String name, String actions )
  {
    this( name );
  }

  /** Costruttore. */
  public PlaceAccessPermission(String name) //throws NameException
  {
    super( name );

    try
    {
      if( "*".equals( name.trim() ) )
        placeID = new PlaceID( "*", "*" );
      else
        placeID = new PlaceID( name );
    }
    catch( NameException e )
    {
      placeID = new PlaceID( "ERROR", "ERROR" );
    }
  }

  /** Costruttore. */
  public PlaceAccessPermission( PlaceID placeID )
  {
    super( placeID.toString() );

    this.placeID = placeID;
  }

  /** Aggiunto un side effect: stampo il risultato a video. */
  public boolean implies(Permission permission)
  {
    boolean answer = false;

    if( permission instanceof PlaceAccessPermission )
    {
      PlaceAccessPermission other = (PlaceAccessPermission)permission;

      boolean answerDomain = placeID.domain.equals( "*" ) ||
                             placeID.domain.equals( other.placeID.domain );

      boolean answerPlace = placeID.place.equals( "*" ) ||
                            placeID.place.equals( other.placeID.place );

      answer = answerDomain && answerPlace;
    }

    //System.out.println( this + " ===> " + permission + "  is  " + answer );

    return answer;
  }

  /** Aggiunto un side effect: stampo il risultato a video. */
  public boolean equals( Object obj )
  {
    boolean answer = false;

    if( obj instanceof PlaceAccessPermission )
      answer = placeID.equals( ((PlaceAccessPermission)obj).placeID );

    //System.out.println( this + " equals " + obj + "  is  " + answer );

    return answer;
  }

  /** Vuoto. */
  public String getActions()
  {
    return "";
  }

  public String toString()
  {
    return "[PlaceAccessPermission " + placeID + "]";
  }

  public int hashCode()
  {
    return placeID.hashCode();
  }

}
