package SOMA.agent.mobility;

import SOMA.agent.Agent;
import SOMA.Environment;
import SOMA.naming.AgentID;
import SOMA.agent.classLoading.*;
import java.io.*;
import java.util.*;

public class BasicAgentPacket implements AgentPacket
{
  private final byte[] packet;
  private final AgentID agentID;
  private final String className;
  private Set classToLoadSet = new TreeSet();  // Lo inizializzo per sicurezza.

  public BasicAgentPacket( Agent agent )
  {
    agentID = agent.getID();
    className = agent.getClass().getName();
    byte[] thePacket = null;
    try
    {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new AgentOutputStream( baos, agent );
      oos.writeObject( agent );

      thePacket = baos.toByteArray();
      classToLoadSet = ((AgentClassLoader)agent.getClass().getClassLoader()).getLoadedClassesSet();
    }
    catch( Exception e )
    {
      System.out.println("---PROBLEMS GETTING THIS AGENT: "+className+" "+agentID);
      e.printStackTrace();
    }

    packet = thePacket;
       // packet  un blank final: va inizializzato una
       //   sola volta ed obbligatoriamente

  }

  public AgentID getAgentID()
  {
    return agentID;
  }

  public Agent getAgent( Environment env )
  {
    AgentClassLoader classLoader = new AgentClassLoader( env, className, agentID );

    Agent theAgent = null;

    try
    {
      // Siccome la deserializzazione puo' richiedere varie connessioni per scaricare pi classi
      //   chiedo che la connesione sia stabile.
      env.networkManager.startPermanentConnection( agentID.getHome() );

      Iterator i;



      i = classToLoadSet.iterator();

      while( i.hasNext() )
      {
        String className = (String)i.next();
        classLoader.loadClass( className );

      }

      ByteArrayInputStream bais = new ByteArrayInputStream( packet );
      ObjectInputStream ois = new AgentInputStream( bais, classLoader );


      theAgent = (Agent)ois.readObject();
    }
    catch(Exception e)
    {
      env.err.println("---PROBLEMS GETTING THIS AGENT: "+className+" "+agentID);
      e.printStackTrace( env.err );
    }
    finally
    {
      env.networkManager.stopPermanentConnection( agentID.getHome() );
    }

    //env.out.println( "BasicAgentPacket: Agent " + theAgent + " loaded by: " + theAgent.getClass().getClassLoader() );
    //env.out.println( "--------------------------------------------------------------------------------------------" );

    if( theAgent != null && !(theAgent.getClass().getClassLoader() instanceof AgentClassLoader) )
    {
      env.out.println( "******************************************************************" );
      env.out.println( "WARNING: SYSTEM class loader: Agent " + theAgent + " LOADED BY " + theAgent.getClass().getClassLoader() );
      env.out.println( "Class " + theAgent.getClass().getName() + " is in the CLASSPATH" );
      env.out.println( "The agent has the privileges fixed for his CLASSPATH position." );
      env.out.println( "******************************************************************" );
    }

    return theAgent;
  }

  public String toString()
  {
    return "[BasicAgentPacket "+ agentID + ", " + className +"]";
  }
}