package SOMA.agent.mobility;

import SOMA.naming.*;
import SOMA.network.connection.*;
import SOMA.agent.*;
import SOMA.Environment;

/** 
 * Comando per il trasporto di agenti.
 *
 * @author Livio Profiri
 * Revised by Alessandro Ghigi
 */
public class AgentTransportCommand extends Command {
	
	final private AgentPacket agentPacket;
	final private PlaceID destination;
	
	/** Costruttore. */
	public AgentTransportCommand(Environment env,Agent agent,PlaceID destination) {
		agentPacket = env.agentManager.packAgent(agent);
		this.destination = destination;
	}
	
	/** Avvia l'agente. */
	public void run() {
		AgentID startedID = null;
		Agent agent = agentPacket.getAgent(env);
		try {
			AgentWorker worker = env.agentManager.createWorker(agent);
			// Se sono nella home del place mobile dove devo recarmi
			// vuol dire che questo non  raggiungibile, quindi metto l'agente in attesa.
			if(env.mobilePlaceManager != null && env.mobilePlaceManager.checkWaitCondition(destination)) env.mobilePlaceManager.addWaitingAgent(agent.getID(),destination);
			else worker.start();
			startedID = agent.getID();
		}
		catch(Exception e) {
			e.printStackTrace(env.err);
		}
		if(startedID == null) {
			env.out.println("AgentTransportCommand: CANNOT START " + agentPacket);
			env.agentManager.agentDeath(agentPacket.getAgentID());
		}
	}
	
	/** 
	 * Restituisce true.
	 * Gli agenti vengono avviati anche se non raggiungono la destinazione.
	 * In questo modo si evita la loro distruzione in caso di malfunzionamento della rete.
	 */
	public boolean startOnError() {
		return true;
	}
	
	public String toString() {
		return "[AgentTransportCommand " + agentPacket + "]";
	}
	
}
