package SOMA.agent.mobility;

import SOMA.naming.*;
import SOMA.network.connection.QuickCommand;

/** Comando per l'aggiornamento della posizione di agenti.
*
* @author Livio Profiri
*/
public class AgentPositionUpdateCommand extends QuickCommand
{
  private final AgentID agentID;
  private final PlaceID placeID;

  /** Costruttore. */
  public AgentPositionUpdateCommand( AgentID agentID, PlaceID placeID )
  {
    this.agentID = agentID;
    this.placeID = placeID;
  }

  public void run()
  {
    env.agentManager.agentPositionStore.put( agentID, placeID );
    //env.out.println( toString() );
  }

  public String toString()
  {
    return "[AgentPositionUpdateCommand " + agentID + " --> " + placeID + "]";
  }
}
