package SOMA.agent.mobility;

import SOMA.naming.*;

import java.util.*;
import java.io.*;

/** Struttura dati che contiene le posizioni degli agenti traceable.
*
* @author Livio Profiri (metodo aggiuntivo di Luigi Antenucci)
*/
public class AgentPositionStore implements Serializable
{
  private Hashtable positions = new Hashtable();

  public PlaceID get( AgentID agentID )
  {
    return (PlaceID)positions.get( agentID );
  }

  public PlaceID put( AgentID agentID, PlaceID position )
  {
    return (PlaceID)positions.put( agentID, position );
  }

  public PlaceID remove( AgentID agentID )
  {
    return (PlaceID)positions.remove( agentID );
  }

  public void printPositions( PrintStream out )
  {
    Iterator i = positions.entrySet().iterator();

    for( int j = 1; i.hasNext(); j++ )
    {
      Map.Entry e = (Map.Entry)i.next();
      out.println( "  " + j + ") " + e.getKey() + " --> " + e.getValue() );
    }
  }

  /**
   *  Rende un array di AgentID corrispondente all'elenco di tutti gli agenti 
   *  "rintracciabli" creati nel place corrente.
   *  Metodo aggiunto da Luigi Antenucci per la "PosizioneAgenti".
   */
  public AgentID[] cheElencoAgenti () {
    Set elencoAgID = positions.keySet();
    return (AgentID[]) elencoAgID.toArray (new AgentID[positions.size()]);
  } //cheElencoAgenti
}