package SOMA.agent.mobility;

import SOMA.naming.*;

/** Comando che segnala la morte di un agente.
*
* @author Livio Profiri
*/
public class AgentDeathCommand extends SOMA.network.connection.QuickCommand
{
  private final AgentID agentID;

  /** Costruttore. */

  public AgentDeathCommand( AgentID agentID )
  {
    this.agentID = agentID;
  }

  public void run()
  {
    env.agentManager.agentDeath( agentID );
    //env.out.println( toString() );
  }

  public String toString()
  {
    return "[AgentDeathCommand " + agentID + "]";
  }
}
