package SOMA.agent.classLoading;

import SOMA.network.connection.Command;
import SOMA.utility.*;

public class SendClassCommand extends Command
{
  private byte[] classData;
  private int classDataIndex;
  private int waitAndTimeoutIndex;

  /** Costruttore. */
  public SendClassCommand( byte[] classData, int classDataIndex, int waitAndTimeoutIndex )
  {
    this.classData = classData;
    this.classDataIndex = classDataIndex;
    this.waitAndTimeoutIndex = waitAndTimeoutIndex;
  }

  public void run()
  {
    //env.out.println( toString() + ": EXECUTING!" );

    env.agentManager.indexStore.put( classDataIndex, classData );

    // Segnalo al semaforo, verr rimosso dal metodo in attesa.
    ((WaitAndTimeout)env.agentManager.indexStore.get( waitAndTimeoutIndex )).Done();

    //env.out.println( toString() + ": WaitAndTimeout.Done " + waitAndTimeoutIndex );
  }

  public String toString()
  {
    return "[SendClassCommand classDataIndex: " + classDataIndex + "    waitAndTimeoutIndex: " + waitAndTimeoutIndex + "]";
  }
}
