package SOMA.agent.classLoading;

import SOMA.explorer.*;
import java.io.*;

/** Permette di vedere e cambiare la directory del ClassManager.
*
* @author Livio Profiri
*/
public class ClassManagerExplorerItem extends StringExplorerItem
{
  private ClassManager classManager;

  public ClassManagerExplorerItem( ClassManager classManager )
  {
    super( classManager.getClassPathDirectory() );
    this.classManager = classManager;
  }

  public void stringChange( String oldString, String newString, PrintStream out )
  {
    try
    {
      classManager = new ClassManager( newString, classManager.getCreateDirectory() );

      out.println( "Old value: " + oldString  );
      out.println( "New value: " + newString  );

      Syntax = classManager.getClassPathDirectory();
      update( classManager );
    }
    catch( Exception e )
    {
      e.printStackTrace( out );
    }
  }

  public void update( ClassManager classManager )
  {}
}
