package SOMA.agent;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;
import SOMA.Environment;
import SOMA.naming.*;
import SOMA.utility.ThreadsExplorerItem;
import SOMA.mobilePlace.MobilePlaceID;

/** Voce di menu per gestire i {@link SOMA.agent.AgentWorker worker} dell'Agent Manager.
* @author Livio Profiri
*/

public class AgentWorkerExplorerItem extends ExplorerItem
{
  Environment env;

  /** Costruttore. */
  public AgentWorkerExplorerItem( Environment env )
  {
    super( "\"Agent ID\" {start | stop | status | dom | remove | kill | go \"Place ID\"}" );
    this.env = env;
  }

  /** Metodo di esecuzione.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    AgentWorker worker = null;

    if( Parameters.size() == 0 )
    {
      Help( out );
    }
    else
    {
      Iterator i = Parameters.iterator();

      AgentID agentID = null;

      try
      {
        agentID = new AgentID( (String)i.next() );
      }
      catch( Exception e )
      {
        out.println( "AgentID ERROR: " + e.toString() );
        return null;
      }

      PlaceID actualPosition = env.agentManager.agentPositionStore.get( agentID );

      if( actualPosition != null )
      {
        out.println();
        out.println( "Agent " + agentID + " is in place " + actualPosition );
        out.println();
      }

      worker = env.agentManager.agentWorkerStore.getWorker( agentID );

      if( worker == null )
      {
        out.println();
        out.println( "Agent " + agentID + " NOT FOUND " );
        out.println();
        return null;
      }

      String Param = "";

      if( i.hasNext() )
        Param = (String)i.next();

      if( Param.equals( "start" ) )
      {
        try
        {
          worker.start();
          out.println( "Started-->" + worker );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "stop" ) )
      {
        try
        {
          worker.stop();
          out.println( "Stopped-->" + worker );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "remove" ) )
      {
        try
        {
          worker.remove();
          out.println( "Removed -->" + worker );
        }
        catch( Exception e )
        {
          out.println( "ERROR: " + e );
          return null;
        }
      }
      else if( Param.equals( "kill" ) )
      {
        try
        {
          worker.kill();
          out.println( "killed -->" + worker );
        }
        catch( Exception e )
        {
          out.println( "ERROR: " + e );
          return null;
        }
      }
      else if( Param.equals( "go" ) )
      {
        PlaceID placeID = null;

        try
        {
          //placeID = new PlaceID( (String)i.next() );
          placeID = MobilePlaceID.parsePlaceID( (String)i.next() );
        }
        catch( Exception e )
        {
          out.println( "I need a valid PlaceID: " + e );
          return null;
        }

        try
        {
          worker.go( placeID );
        }
        catch( CantGoException e )
        {
          out.println( "ERROR: " + e );
        }
      }
      else if( Param.equals( "dom" ) )
      {
        out.println( "Worker " + worker );
        out.println();
        out.println( "Protection domain: " + worker.agent.getClass().getProtectionDomain() );
        out.println();
      }
      else if( Param.equals( "status" ) || Param.equals( "" ) )
      {
        out.println( "Worker " + worker );
        out.println( "Status: " +  worker.getStatus() );
        out.println();
        out.println( "Agent class: " + worker.agent.getClass() );
        out.println( "Class loader: " + worker.agent.getClass().getClassLoader() );
        out.println();
        out.println( "Source URL: " + worker.agent.getClass().getProtectionDomain().
                          getCodeSource().getLocation() );
        out.println();
        out.println( "Active threads: " );
        ThreadsExplorerItem.Enumerate( worker.agentThreadGroup, out );
        out.println();
      }
      else
      {
        out.println( "Unknown operation: " + Param );
      }
    }

    return worker;
  }

  public String Help( PrintStream out )
  {
    out.println( "  start: starts the agent." );
    out.println( "  stop: stops the agent." );
    out.println( "  status: returns the agent's status." );
    out.println( "  dom: returns the agent's protection domain." );
    out.println( "  remove: removes the agent, if in OFF status." );
    out.println( "  kill: kills the agent." );
    out.println( "  go: moves the agent to another place." );

    return toString();
  }
}