package SOMA;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;
import SOMA.naming.*;

/** Voce di menu per la creazione di un place.
*
* @see SOMA.NewDomainExplorerItem
* @author Livio Profiri
*/
public class NewPlaceExplorerItem extends ExplorerItem
{
  /** @serial*/
  DirExplorerItem dir;

  public NewPlaceExplorerItem( DirExplorerItem dir )
  {
    super( "<domain_name> <place_name> <port>" );
    this.dir = dir;
  }

  /** Metodo di esecuzione del comando: crea il place.
  * <br>
  * I parametri richiesti sono il <B>nome del dominio</B>, il <B>nome del place</B>  e la <B>porta</B> del server del place.<BR>
  * Vengono creati l'{@link SOMA.Environment Environment} del place ed un
  * {@link SOMA.explorer.DirExplorerItem sottomenu} chiamato <B>nome del place</B>.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 3 )
    {
      Iterator i = Parameters.iterator();
      PlaceID placeID = new PlaceID( (String)i.next(), (String)i.next() );

      String Param = (String)i.next();

      int port = 0;
      try
      {
        port = Integer.parseInt( Param );
      }
      catch( Exception e )
      {
        out.println( "ERROR: incorrect port number" + Param );
        return null;
      }

      DirExplorerItem placeDir = new DirExplorerItem( placeID.place );
      placeDir.setSyntax( "Place " + placeDir.getSyntax() ); // Syntax: Place Directory
      Environment env = null;

      try
      {
        env = new Environment( placeID, placeDir, port, System.in, out, out,false );
        dir.addItem( placeDir );

        out.println( "Environment " + env + " created" );
      }
      catch( Exception e )
      {
        e.printStackTrace( out );
      }

      return env;
    }
    return null;
  }

  public String Help( PrintStream out )
  {
    String help = "place_name port: Creates a new place using the specified port.";

    out.println( help );

    return help;
  }
}