package SOMA;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;
import SOMA.naming.*;

/** Voce di menu per la creazione di un dominio. 
*
*  @see SOMA.NewPlaceExplorerItem
*  @author Livio Profiri
*/

public class NewDomainExplorerItem extends ExplorerItem
{
  /** @serial*/
  DirExplorerItem dir;

  public NewDomainExplorerItem( DirExplorerItem dir )
  {
    super( "<domain_name> <port>" );
    this.dir = dir;
  }

  /** Metodo di esecuzione del comando: crea il dominio.
  * <br>
  * I parametri richiesti sono il <B>nome di dominio</B> e la <B>porta</B> del server del dominio.<BR>
  * Vengono creati l'{@link SOMA.Environment Environment} del default place del dominio ed un
  * {@link SOMA.explorer.DirExplorerItem sottomenu} chiamato <B>nome di dominio</B>.
  */
  
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 2 )
    {
      Iterator i = Parameters.iterator();
      PlaceID domainID = new PlaceID( (String)i.next(), "" );

      String Param = (String)i.next();

      int port = 0;
      try
      {
        port = Integer.parseInt( Param );
      }
      catch( Exception e )
      {
        out.println( "ERROR: incorrect port number" + Param );
        return null;
      }

      DirExplorerItem domainDir = new DirExplorerItem( domainID.domain );
      domainDir.setSyntax( "Domain " + domainDir.getSyntax() ); // Syntax: Domain Directory
      
      Environment env = null;

      try
      {
        env = new Environment( domainID, domainDir, port, System.in, out, out,false );

        dir.addItem( domainDir );

        out.println( "Environment " + env + " created" );
      }
      catch( Exception e)
      {
        e.printStackTrace( out );
      }

      return env;
    }
    return null;
  }

  public String Help( PrintStream out )
  {
    String help = "domain_name port: Creates a new domain using the specified port.";

    out.println( help );

    return help;
  }
}