package SOMA;

import SOMA.network.*;
import SOMA.explorer.DirExplorerItem;
import SOMA.naming.*;
import SOMA.naming.domain.*;
import SOMA.naming.place.*;
import SOMA.agent.mobility.AgentManager;
import SOMA.mobilePlace.*;
import SOMA.gui.ActionPlace;
import SOMA.gui.remotegui.SportelloRichieste;
import SOMA.explorer.*;
import SOMA.ext.Main.*;
import SOMA.ext.NetManagement.*;
import SOMA.network.connection.*;
import SOMA.telnet.*;
import SOMA.resourceManagement.*;
import SOMA.gui.Debug;
import java.io.*;
import java.util.*;

/**
 * Classe che rappresenta l'astrazione di place.
 * Contiene i riferimenti a tutti gli oggetti che compongono un place o un default place,
 * che e' il place che gestisce un dominio.
 * Il costruttore di Environment avvia il place.
 *
 * @author Livio Profiri (aggiunte di Luigi Antenucci)
 * Revised by Alessandro Ghigi
 */

public class Environment {
	
	/** Identificatore del place. */
	public final PlaceID placeID;
	/** Porta di comunicazione del place. */
	public final int port;
	/** Gestore delle comunicazioni fra place. */
	public NetworkManager networkManager = null;
	/** Menu di gestione del place. */
	public DirExplorerItem dir;
	/** Servizio di nomi di dominio. E' presente solo in un default place. */
	public DomainNameService domainNameService;
	/** Servizio di nomi di place. E' presente in qualsiasi place. */
	public PlaceNameService placeNameService;
	/** Gestore degli agenti. */
	public AgentManager agentManager;
	/** Gestore dei place mobili. */
	public MobilePlaceManager mobilePlaceManager;
	/** Gestore delle risorse del place. */
	public PlaceResourceManager placeResourceManager;
	/** Gestore delle risorse del domain. */
	public DomainResourceManager domainResourceManager;
	
	/** Gestore della finestra del Place (package gui). */
	public ActionPlace actionPlace;
	/** Thread di attesa delle richieste da parte delle applet (package gui.remoteapplet). */
	public SportelloRichieste sportelloRichieste;   
	
	/** The directory where we store the metadataRepository. */
	public String metadataRepositoryFile = System.getProperty("user.dir")/*SOMA directory*/ +	System.getProperty("file.separator") + "metadataRepository" + System.getProperty("file.separator") + "presentationsMetaDataDataBase";
	/** The directory where we store the profileRepository. */
	public String profileRepositoryFile = System.getProperty("user.dir")/*SOMA directory*/ +	System.getProperty("file.separator") + "profileRepository" + System.getProperty("file.separator") + "profileDataBase";
	/** The directory where we store the profileRepository. */
	public String platformDescriptorsFile = System.getProperty("user.dir")/*SOMA directory*/ +	System.getProperty("file.separator") + "profileRepository" + System.getProperty("file.separator") + "platformDescriptorsDataBase";
	/** The directory where we store the componentRepository. */
	public String repositoryBaseDirectory;        
	
	/** L'InputStream del place. */
	public InputStream in;
	/** Il MultiOutputStream out. */
	public MultiOutputStream multiOut = new MultiOutputStream();
	/** L'OutputStream del place. */
	public PrintStream out = new PrintStream(multiOut);
	/** Il MultiOutputStream err. */
	public MultiOutputStream multiErr = new MultiOutputStream();
	/** L'ErrorStream del place. */
	public PrintStream err = new PrintStream(multiErr);
	
	public ThreadGroup threadGroup = null;
	private Exception creationException = null;
	
	/** Flag che indica se l'Environment  Master oppure slave - Added by Alessandro Ghigi. */
	public boolean slave;
	/** PlaceInfo dell'Environment master - Added by Alessandro Ghigi. */
	public PlaceInfo masterInfo;
	/** Connessione con il pari (master o slave) - Added by Alessandro Ghigi. */
	public Connection repConnection = null;
	/** Flag che indica se il master  attivo o meno - Added by Alessandro Ghigi. */
	public boolean master_alive = true;
	/**  Thread di interrogazione dello stato del master - Added by Alessandro Ghigi. */
	public Thread pollingThread = null;
	
	/** Costruttore usato per avere un Environment "vuoto". */
	public Environment(DirExplorerItem dir,InputStream in,PrintStream out,PrintStream err) {
		this.port = -1;
		this.dir = dir;
		this.in = in;
		multiOut.add(out);
		multiErr.add(err);
		placeID = new PlaceID("???","???");
		repositoryBaseDirectory = System.getProperty("user.dir")/*SOMA directory*/ +	System.getProperty("file.separator") + "componentRepository" + placeID.domain+placeID.place;
	}
	
	/** Costruttore usato per avere un Environment "vuoto". */
	public Environment(PlaceID placeID) {
		this.placeID = placeID;
		this.port = -1;
		repositoryBaseDirectory = System.getProperty("user.dir")/*SOMA directory*/ +	System.getProperty("file.separator") + "componentRepository" + placeID.domain+placeID.place;
	}
	
	/** 
	 * Costruttore: avvia il place chiamando i costruttori di tutti i suoi componenti.
	 * Un flag indica se si sta costruendo o meno un Environment slave - Added by Alessandro Ghigi. 
	 */
	public Environment(final PlaceID placeID,final DirExplorerItem dir,final int port,final InputStream in,final PrintStream out,final PrintStream  err,final boolean slave) throws Exception {
		this.slave = slave;
		this.placeID = placeID;
		this.port = port;
		this.dir = dir;
		repositoryBaseDirectory = System.getProperty("user.dir")/*SOMA directory*/ +	System.getProperty("file.separator") + "componentRepository" + placeID.domain+placeID.place;
		this.err = err;
		multiOut.add(out);
		multiErr.add(err);
		dir.addItem( "env",new ObjectExplorerItem(this));
		aggiungiVociDellaGUI(dir);
		createNameServices();
		if(placeID.isDomain() && !slave) mobilePlaceManager = new MobilePlaceManager(this);
		// Tutti i threads creati dall'environment, ossia facenti parte del place, si troveranno in questo ThreadGroup
		threadGroup = new ThreadGroup("[Environment:" + placeID + "]");
		threadGroup.setDaemon(true);   // Distrutto dopo l'ultimo thread di questo gruppo
		Thread initThread = new Thread(threadGroup,toString() + " Initialization Thread.") {
			public void run() {
				try {
					networkManager = new NetworkManager(Environment.this,port);
					Debug.outln("Environment: NetworkManager created!");
					agentManager = new AgentManager(Environment.this);
					Debug.outln("Environment: AgentManager created!");
					dir.addItem("threads", new SOMA.utility.ThreadsExplorerItem());
				}
				catch( Exception e ) {
					creationException = e;
				}
			}
		};
		initThread.setDaemon(true);
		initThread.start();
		initThread.join();
		// Creazione del Thread di interrogazione dello stato del master, se si sta creando uno Slave...
		if(slave) {
			pollingThread = new Thread(threadGroup,toString() + " Polling Master Thread.") {
				public void run() {
					while(true) {
						// Parte del ciclo da eseguire nel caso in cui il master sia attivo
						if(master_alive) {
							try {
								//Interrogazione ogni 30 secondi
								Thread.sleep(30000);
								// Se riesce ad inviare un comando vuoto, il Master  attivo
								repConnection.send(new ReqAliveCommand());
							}
							catch(Exception e) {
								// Rilevata caduta del master
								out.println("Master is down! Now I manage the domain Places...");
								master_alive = false;
								// Inserimento placeInfo dello Slave nella tabella del DNS e aggiornamento presso tutti i domini
								domainNameService.putDomain((DomainInfo)networkManager.placeInfo);
								try {
									Thread.sleep(2000);
								}
								catch(Exception se) {
									se.printStackTrace();
								}
								// Aggiornamento delle connessioni permanenti che erano state stabilite dal master
								networkManager.refreshPermanentConnections();
								// Aggiornamento delle connessioni permanenti presso tutti i domini che ne avevano stabilita una con il master
								domainNameService.sendToAllDomains(new SlavePeerConnectionRefreshCommand(placeID,placeID),placeID);
								// Inserimento placeInfo dello Slave nella tabella del PNS
								placeNameService.putPlace(networkManager.placeInfo);
								// Restart di tutti gli agenti interrotti
								agentManager.restartAllAgents();
							}
						}
						// Parte da eseguire appena viene rilevata una riattivazione del master
						else {
							try {
								// Interrogazione ogni minuto
								Thread.sleep(30000);
								// Scambio di informazioni con il master
								networkManager.contactMaster2(masterInfo.host,masterInfo.port);
								out.println("Master is alive again!!");
								master_alive = true;
								Thread.sleep(2000);
								// Rimozioni delle connessioni dallo Slave
								networkManager.connectionStore.stopAllConnections(placeID);
								// Invio al Master di tutte le informazioni di stato necessarie per una riattivazione completa
								repConnection.send(new ActivateMasterCommand(domainNameService.getDomains(),placeNameService.getPlaces(),domainNameService.getParentDNS(),domainNameService.getChildrenDNS(),networkManager.getPermanentConnections()));
								// Inserimento del PlaceInfo del Master nel DNS e nel PNS
								initNameServices();
							}
							catch(Exception e) {}
						}
					}
				}
			};
			out.println("Polling Thread starting...I'll check Master status every 30 sec");
			pollingThread.setDaemon(true);
		}
		if(creationException != null) throw(creationException);
		// Questo ha solo finalit di debugging.
		dir.addItem( "text", new ExplorerItem("Writes text to 3 different PrintStreams.") {
			public Object Execute(java.util.Collection Parameters,PrintStream out) {
				out.println("********** Testo di Explorer! *********");
				Environment.this.out.println("----------- Testo di PlaceWindow! -----------");
				System.out.println("############## Testo di System! ##############");
				return null;
			}
		} );
		dir.addItem( "save", new ExplorerItem("Save place info to disk.") {
			public Object Execute(java.util.Collection Parameters, PrintStream out) {
				try {
					save();
					out.println("Saved!");
				}
				catch(Exception e) {
					e.printStackTrace(out);
				}
				return null;
			}
		} );
		dir.addItem("load", new ExplorerItem("Load place info from disk.") {
			public Object Execute(java.util.Collection Parameters,PrintStream out) {
				try {
					load();
					out.println("Loaded!");
				}
				catch(Exception e) {
					e.printStackTrace(out);
				}
				return null;
			}
		} );
	}
	
	/** Cambia in MobileEnvironment. */
	protected void createNameServices() {
		if(placeID.isDomain()) {
			domainNameService = new DomainNameService(this);
			dir.addItem("dns",new DNSExplorerItem(domainNameService));
		}
		placeNameService = new PlaceNameService(this);
		dir.addItem("pns",new PNSExplorerItem(placeNameService));
	}
	
	protected void initNameServices() {
		domainNameService.getDomains().put(masterInfo.placeID,(DomainInfo)masterInfo);
		placeNameService.getPlaces().put(masterInfo.placeID,masterInfo);
	}
	
	/** Caricamento dello stato da disco (file .dat). */
	public void load() throws IOException, ClassNotFoundException {
		load(placeID.toString() + ".dat");
	}
	
	public void load(String fileName) throws IOException, ClassNotFoundException {
		ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(fileName)));
		Hashtable table = new Hashtable();
		table = (Hashtable)ois.readObject();
		ois.close();
		placeNameService = (PlaceNameService)table.get("pns");
		if(placeNameService != null) {
			placeNameService.setEnv(this);
			out.println("pns:" + placeNameService);
			dir.addItem("pns", new PNSExplorerItem(placeNameService));
		}
		domainNameService = (DomainNameService)table.get("dns");
		if(domainNameService != null) {
			domainNameService.setEnv(this);
			out.println("dns:" + domainNameService);
			dir.addItem("dns", new DNSExplorerItem(domainNameService));
		}
		mobilePlaceManager = (MobilePlaceManager)table.get("mpm");
		if(mobilePlaceManager != null) {
			mobilePlaceManager.setEnv(this);
			dir.addItem("mpm", new MobilePlaceManagerExplorerItem(mobilePlaceManager));
			out.println("mpm:" + mobilePlaceManager);
		}
		int newCount = ((Integer)table.get("count")).intValue();
		int oldCount = agentManager.AgentIDCounter;
		if(newCount > oldCount) {
			agentManager.AgentIDCounter = newCount;
			out.println("agent counter:" + oldCount + " -->" + newCount);
		}
		out.println("Status loaded!");
	}
	
	/** Salvataggio dello stato su disco (file .dat). */
	public void save() throws IOException {
		save(placeID.toString() + ".dat");
	}
	
	public void save(String fileName) throws IOException {
		ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(fileName )));
		Hashtable table = new Hashtable();
		table.put("pns", placeNameService);
		out.println("pns:" + placeNameService);
		table.put("dns", domainNameService);
		out.println("dns:" + domainNameService);
		table.put("mpm", mobilePlaceManager);
		out.println("mpm:" + mobilePlaceManager);
		table.put("count", new Integer(agentManager.AgentIDCounter));
		out.println("agent counter:" + agentManager.AgentIDCounter);
		oos.writeObject(table);
		oos.close();
		out.println("Status saved!");
	}
	
	/** Metodo aggiunto da Luigi Antenucci per aggiungere le voci della GUI. */
	protected void aggiungiVociDellaGUI (DirExplorerItem dir) {
		actionPlace = new ActionPlace (this);
		dir.addItem("window", new DaemonExplorerItem(actionPlace));
		sportelloRichieste = new SportelloRichieste (actionPlace, SportelloRichieste.PORTA_DEFAULT);
		dir.addItem("remoteApplet", new DaemonExplorerItem(sportelloRichieste));
	}
	
	public String toString() {
		return "[Environment " + placeID + " " + networkManager + " " + domainNameService + " " + placeNameService + " " + agentManager + " " + mobilePlaceManager + "]";
	}
	
}