package gcs;

import java.util.*;

public class View{

private HashSet memberList;
private Member member;

//tabella con chiave=IP_suspect+" "+name_suspect		valore=HashSet di suspecters_list
private Hashtable suspected_to_have_crashed_members = null;

private Hashtable logical_clocks = null; //chiave = member_id valore = logical clock

synchronized public Integer get_logical_clock(String member_id){return (Integer)logical_clocks.get(member_id);}

synchronized public boolean isEmpty(){return memberList.isEmpty();}

synchronized public boolean containsOtherMembers(){return memberList.size()>1;}

synchronized public HashSet getList(){return memberList;}

synchronized public boolean contains(String member_id){
return memberList.contains(member_id);
}

synchronized public View copy(){
return new View(member,memberList,suspected_to_have_crashed_members);
}

synchronized public View removeOwner(){
memberList.remove(member.getLocation().getHostAddress()+" "+member.getName());
return this;
}





//il metodo ritorna subito, se si cerca di aggiungere nell'elenco dei logical clock 
//il proprietario della view, oppure se la view non contiene member_id
synchronized public void set_logical_clock(String member_id, String value){
	if(member_id.equals(member.getLocation().getHostAddress()+" "+member.getName()))return;
	if(!memberList.contains(member_id))return;
	logical_clocks.put(member_id, new Integer(value));
}//set_logical_clock





synchronized public String print_vector_clocks(){
	String returnString = "";
	Enumeration enum = logical_clocks.keys();
	while(enum.hasMoreElements()){	
		String current_member_id = (String)enum.nextElement();
		String current_logical_clock = ((Integer)logical_clocks.get(current_member_id)).toString();
		returnString+=" #"+current_member_id+" "+current_logical_clock;
	}//while
return returnString;
}//print_vector_clocks





public View(Member m){
member = m;
memberList = new HashSet();
suspected_to_have_crashed_members = new Hashtable();
logical_clocks = new Hashtable();
}//View





//costruttore per copia (solo per la memberList e la lista dei sospettati)
public View(Member m, HashSet ml, Hashtable s){
member = m;
memberList = new HashSet();

Iterator it = ml.iterator();
while(it.hasNext())memberList.add(new String((String)it.next()));

suspected_to_have_crashed_members = new Hashtable();
Enumeration enum = s.keys();
while(enum.hasMoreElements()){
	String key = new String((String)enum.nextElement());
	HashSet val = copyHashSet((HashSet)s.get(key));
	suspected_to_have_crashed_members.put(key,val);
}//while
}//View





private HashSet copyHashSet(HashSet hs){
	HashSet returnHs = new HashSet();
	Iterator it = hs.iterator();
	while(it.hasNext())returnHs.add(new String((String)it.next()));
	return returnHs;
}//copyHashSet





//ritorna true quando su di un membro ricadono i sospetti di tutti gli altri
synchronized public boolean add_suspicion(String IP_suspecter, String name_suspecter, String IP_suspect, String name_suspect){
HashSet suspecters_list = (HashSet)suspected_to_have_crashed_members.get(IP_suspect+" "+name_suspect);
if(suspecters_list==null)suspecters_list = new HashSet();
suspecters_list.add(IP_suspecter+" "+name_suspecter);
suspected_to_have_crashed_members.put(IP_suspect+" "+name_suspect,suspecters_list);

Iterator it = memberList.iterator();
while(it.hasNext()){
	String element = (String)it.next();
	if(element.equals(IP_suspect+" "+name_suspect))continue;
	if(
		(!suspecters_list.contains(element))&&
		(!suspected_to_have_crashed_members.containsKey(element))
	)return false;
}//while
suspected_to_have_crashed_members.remove(IP_suspect+" "+name_suspect);
return true;
}//add_suspicion





//il membro di identificatore globale "IP name"
//viene aggiunto solo se non esiste gi un altro membro con nome "IP name"
synchronized public boolean addMember(String IP, String name, String logical_clock){
if(memberList.contains(IP+" "+name))return false;
memberList.add(IP+" "+name);
Integer value;
if(Integer.parseInt(logical_clock)>0)value = new Integer((new Integer(logical_clock)).intValue());
else value = new Integer("0");
if(
!(member.getLocation().getHostAddress()+" "+member.getName()).equals(IP+" "+name)
){
	logical_clocks.put(IP+" "+name, value);
}//if
updateView();
return true;
}//addMember

synchronized public boolean addMember(String IP, String name){
return addMember(IP, name, "0");
}





synchronized public void removeMember(String IP, String name){
//non autorimuove
if(IP.equals(member.getLocation().getHostAddress())&&name.equals(member.getName()))return;
memberList.remove(IP+" "+name);
if(suspected_to_have_crashed_members!=null){
	suspected_to_have_crashed_members.remove(IP+" "+name);
}//if
updateView();
}//removeMember





synchronized public String toString(){
Iterator it = memberList.iterator();
String returnString = "";
while(it.hasNext())returnString+=it.next()+"\n";
return returnString;
}//toString





synchronized public void updateView(){
if(member.getView()==this)member.setViewText(toString());
}

}//class View