package gcs;

import java.net.*;
import java.util.*;

/*
mantiene le informazioni per la garanzia di consegna dei pacchetti:
-timestamp di invio del pacchetto
-elenco dei membri da cui si richiede conferma di ricezione
*/
public class PacketWrapper{

private DatagramPacket packet;
private Hashtable acks; //tabella: chiave = membri da cui si aspetta l'ack
private long timestamp; //non  quello del logical clock
private int times_number_sent;

public long get_timestamp(){return timestamp;}
public int get_times_number_sent(){return times_number_sent;}
public DatagramPacket get_packet(){return packet;}

//restituisce la lista dei membri per cui si richiede l'ack
public HashSet getEventuallyCrashedList(){
	HashSet returnSet = new HashSet();
	Iterator it = acks.keySet().iterator();
	while(it.hasNext()){
		String element = (String)it.next();
		if(!((String)acks.get(element)).equals("ack"))returnSet.add(element);
	}//while
return returnSet;
}//getEventuallyCrashedList

public void set_timestamp(long t){timestamp = t;}
public void set_times_number_sent(int n){times_number_sent = n;}

/*
richiede che gli ack provengano dai membri della view 
al momento dell'invio del pacchetto
*/
public PacketWrapper(DatagramPacket packet, View view, long timestamp){
this.times_number_sent = 1;
this.packet = packet;
this.timestamp = timestamp;

acks = new Hashtable();
HashSet memberList = view.getList();
if(memberList==null)return;
Iterator it = memberList.iterator();
while(it.hasNext())acks.put(it.next(),"");
}//PacketWrapper





//se tutti gli ack sono stati ricevuti, ritorna true, altrimenti false
public boolean setAck(String member_id){
if(!acks.containsKey(member_id))return false;
acks.put(member_id,"ack");
Enumeration enum = acks.elements();
while(enum.hasMoreElements())if(!enum.nextElement().equals("ack"))return false;
return true;
}//setAck

}