package gcs;

import java.net.*;
import java.awt.*;
import java.io.*;
import javax.swing.*;
import java.util.*;
import java.rmi.*;
import java.lang.reflect.*;

/**
realizza un membro del gruppo
*/
public class Member{

private boolean lock;
private int ack_port; //per la ricezione degli ack
private JFrame frame = null;
private Container container = null;
private JButton send_button = null;
private JScrollPane outPanel = null;
private JScrollPane applicationOutPanel = null;
private JScrollPane view_printPanel = null;
private JTextArea output = null;
private JTextArea application_output = null;
private JTextArea view_print = null;
private JTextField input = null;

/************identificatore globale************/
private InetAddress location = null;
private String name = null;
/************************************************/

private int sequence_number = 0; //numero di sequenza dei messaggi
private int logical_clock = 0; //per l'ordinamento causale
private String synchronizing_numbers_lock;
private Hashtable send_buffer; //chiave = numeri di sequenza, valore = PacketWrapper
private Hashtable last_delivered_packet; //chiave = member_id, valore = numero ultimo pacchetto consegnato
private Hashtable receive_buffer; //chiave = member_id sequence_number, valore = pacchetto pendente
private HashSet causal_receive_buffer; //insieme di pacchetti (String)

private InetAddress group = null;
private MulticastSocket multicast_socket = null;
private DatagramSocket unicast_socket = null;
private String service_name;

private View view; //membri del gruppo correntemente riconosciuti

public Hashtable get_last_delivered_packet(){return last_delivered_packet;}
public Hashtable get_send_buffer(){return send_buffer;}
public MulticastSocket getMulticastSocket(){return multicast_socket;}
public DatagramSocket getUnicastSocket(){return unicast_socket;}
public String getName(){return name;}
public InetAddress getLocation(){return location;}
public String getMemberInfo(){return location.getHostAddress()+" "+ack_port+" "+name;}
public View getView(){return view;}

public String getOrdinaryMsg(){return ("ordinary "+input.getText());}

public void setViewText(String s){
view_print.setText(s);
}

public void init(boolean setLocalInterface_flag){
frame = new JFrame("member "+name);
frame.setSize(new Dimension(300,300));
frame.setResizable(false);
frame.setLocation(150,200);
view = new View(this);
output = new JTextArea(10,45);
application_output = new JTextArea(10,45);
view_print = new JTextArea(5,15);
input = new JTextField(40);
send_button = new JButton("send");
send_button.addActionListener(new SendListener(this));
container = frame.getContentPane();
container.setLayout(new BoxLayout(container, BoxLayout.PAGE_AXIS));
		outPanel = new JScrollPane(output);
		applicationOutPanel = new JScrollPane(application_output);
		view_printPanel = new JScrollPane(view_print);
		container.add(outPanel,BorderLayout.SOUTH);
		container.add(applicationOutPanel,BorderLayout.SOUTH);
		container.add(view_printPanel,BorderLayout.EAST);
		container.add(input,BorderLayout.SOUTH);
       container.add(send_button,BorderLayout.SOUTH);
       frame.addWindowListener(new Terminator(this));
       frame.pack();
       frame.show();

//adesione al gruppo
		try{
		group = InetAddress.getByName("228.5.6.7");
		multicast_socket = new MulticastSocket(6789);
		unicast_socket = new DatagramSocket(null);
		unicast_socket.setReuseAddress(true);
		unicast_socket.bind(new InetSocketAddress(ack_port));
		multicast_socket.setTimeToLive(255);
		if(setLocalInterface_flag)multicast_socket.setInterface(InetAddress.getByName("127.0.0.1"));

		//discovery, fase critica perch non  affidabile: un volta raggiunti gli altri membri
		//si lavora con reliability, ma in fase di discovery non  garantito che tutti i membri siano raggiunti,
		//perci nella view iniziale ne potranno mancare alcuni
		send("join");

		multicast_socket.joinGroup(group);

		//autoinclusione nella view
		view.addMember(location.getHostAddress(),name);

		}catch(Exception e){output.append("\n"+e.getMessage());}
}//init





	public Member(String name, int ack_port, String service_name){
		this.service_name = service_name;
		this.ack_port = ack_port;
		this.name = name;
		synchronizing_numbers_lock = new String("");
		send_buffer = new Hashtable();
		last_delivered_packet = new Hashtable();
		receive_buffer = new Hashtable();
		causal_receive_buffer = new HashSet();
		try{
			this.location = InetAddress.getLocalHost();
		}catch(Exception e){System.out.println(""+e.getMessage());}
	}//Member





synchronized public void removeMember(String IP, String name){
System.out.println("remove data of: "+IP+" "+name);
	view.removeMember(IP,name);
	last_delivered_packet.remove(IP+" "+name);
	remove_from_send_buffer(IP,name);
	remove_from_receive_buffer(IP,name);
}//removeMember





//aggiunge al send_buffer degli ack virtuali per i messaggi mandati ai membri in crash
public void remove_from_send_buffer(String IP, String name){
synchronized(this){
	Enumeration enum = send_buffer.keys();
	while(enum.hasMoreElements()){
		Integer seq_num = (Integer)enum.nextElement();
		PacketWrapper pw = (PacketWrapper)send_buffer.get(seq_num);
		if((pw.setAck(IP+" "+name)==true)||(!view.containsOtherMembers())){
			send_buffer.remove(seq_num);
			output.append("\nsend_buffer decrease: "+send_buffer.toString());
		}//if
	}//while
}//synchronized
}//remove_from_send_buffer





public void remove_from_receive_buffer(String IP, String name){
	Enumeration enum = receive_buffer.keys();
	while(enum.hasMoreElements()){
		String current_key = (String)enum.nextElement();
		String current_member_id = current_key.split(" ")[0]+" "+current_key.split(" ")[1];
		String current_seq_num = current_key.split(" ")[2];
		if(current_member_id.equals(IP+" "+name)){
			receive_buffer.remove(current_member_id+" "+current_seq_num);
		}//if
	}//while
}//remove_from_receive_buffer





/*la send si deve preoccupare di garantire la consegna a tutti i membri della view corrente
oppure rilevarne il crash (o l'uscita dal gruppo) e notificarlo agli altri*/
public void send(String string_msg){send(string_msg,1);}
public void send(String string_msg, int times_number_sent){
		String _msg;
		byte[] msg;
		boolean join_type;

		int sequence_number_here = -1;
		int logical_clock_here = -1;

		synchronized(synchronizing_numbers_lock){
			if(!string_msg.equals("join"))	sequence_number++;
			sequence_number_here = sequence_number;
			//l'ordine causale si impone solo per i pacchetti ordinari
			if(string_msg.startsWith("ordinary"))logical_clock++;
			//il messaggio contiene come timestamp il logical clock dopo l' incremento
			logical_clock_here = logical_clock;
		}//synchronized

		//non si pu dichiarare un proprio crash
		if(string_msg.equals("has-crashed "+location.getHostAddress()+" "+name))return;

		if(!string_msg.equals("join")){
			_msg = getMemberInfo()+" "+sequence_number_here;
			join_type = false;
		}//
		else{ //caso di messaggio di join
			_msg = getMemberInfo()+" "+sequence_number_here; //_msg = getMemberInfo()+" join";
			join_type = true;
		}//else

		if(string_msg.startsWith("ack"))msg = (_msg+" "+string_msg).getBytes();

		else{
		String[] fields = string_msg.split(" ");
		String others_field = "";
		if(fields.length>1)others_field = string_msg.substring(fields[0].length());
		msg = (_msg+" "+fields[0]+" "+
					logical_clock_here+
					(string_msg.startsWith("ordinary")?view.print_vector_clocks():"")+
					others_field).getBytes();
		}//else

		DatagramPacket packet = null;
		try{
		packet = new DatagramPacket(msg, msg.length, group, 6789);
		send(packet, join_type, times_number_sent);
		}catch(Exception e){output.append("\n send error:"+e.getMessage());e.printStackTrace();}
}//send



//da utilizzare direttamente solo per il riinvio, caso in cui non si aggiorna il timestamp causale
public void send(DatagramPacket packet, boolean join_type, int times_number_sent){
		String packet_text = new String(packet.getData()).trim();
		try{
		if(view.containsOtherMembers()&&(!join_type)){
			synchronized(this){
				if(times_number_sent==1){
					View modified_view_copy = view.copy().removeOwner();
					if(
						(packet_text.split(" ")[4]).equals("suspect-crashed")
					)modified_view_copy.removeMember(packet_text.split(" ")[6],packet_text.split(" ")[7]);
					send_buffer.put(new Integer(sequence_number),
													new PacketWrapper(
																packet,
																modified_view_copy,
													System.currentTimeMillis()));
					output.append("\nsend_buffer increase: "+send_buffer.toString());
				}//if
				if(times_number_sent>1){
				//il pacchetto si riinvia con lo stesso numero di sequenza
				String packet_sequence_number = packet_text.split(" ")[3];
					PacketWrapper pw = (PacketWrapper)send_buffer.get(new Integer(packet_sequence_number));
					if(pw==null)return;
					pw.set_times_number_sent(times_number_sent);
					pw.set_timestamp(System.currentTimeMillis());
				}//if
			}//synchronized
		}//if

		multicast_socket.send(packet);
		output.append("\n-->at local time "+System.currentTimeMillis()+": send-->\""+new String(packet.getData())+"\"");

		}catch(Exception e){output.append("\n send error:"+e.getMessage());e.printStackTrace();}
}//send





public void recv(){
		byte[] buf;
		DatagramPacket recv;
		try{
		buf = new byte[1000];
		recv = new DatagramPacket(buf, buf.length);

		//ricezione: bloccante ma eseguita dal thread Receiver
		System.out.println("--->recv: waiting for packets...");
		multicast_socket.receive(recv);
		output.append("\n<--at local time "+System.currentTimeMillis()+": received<--\""+new String(recv.getData()).trim()+"\"");

		String[] packet_fields = new String(recv.getData()).split(" ");
		packet_fields[packet_fields.length-1] = packet_fields[packet_fields.length-1].trim();

/*il pacchetto  nel formato: 
<IP mittente> <porta ack> <nome mittente> 
<numero sequenza> <tipo> <timestamp (logical clock)>
[vector clock (se il pacchetto  ordinary), come lista di 
"member_IP member_name member_clock"] [testo]
*/
		String packet_field_IP = packet_fields[0];
		String packet_field_ack_port = packet_fields[1];
		String packet_field_name = packet_fields[2];
		String packet_sequence_number = packet_fields[3];
		String packet_field_type = packet_fields[4];
		String packet_field_timestamp = packet_fields[5];

		/********************************************************
		operazioni eseguite in base ai pacchetti ricevuti
		********************************************************/

		//se si riceve un pacchetto autoinviato lo si scarta
		if(
			(packet_field_IP.equals(location.getHostAddress()))&&
			(packet_field_name.equals(name))
		)return;


		//se si  ricevuta una richiesta di join
		if(packet_field_type.equals("join")){
			view.addMember(packet_field_IP,packet_field_name,packet_field_timestamp);
			/*si manda a tutti i membri della view l'ack del join, con reliability,
			questo garantisce che anche se il discovery  best-effort,  sufficiente
			che il membro che vuole aderire al gruppo raggiunga anche un solo componente,
			che si preoccuper di notificare agli altri, con reliability, il nuovo entrante*/
			send("has-joined "+packet_field_IP+" "+packet_field_name);

			//quindi lo si consegna
			deliverPacket(recv,packet_field_IP+" "+packet_field_name,new Integer(packet_sequence_number));
			return;
		}//if join

		//se si  ricevuto un messaggio di ack del join
		else if(packet_field_type.equals("has-joined")){
			//se si  colui che ha fatto richiesta di join, si aggiunge alla view il mittente (effetto del discovery)
			if(
				(packet_fields[6].equals(location.getHostAddress()))&&
				(packet_fields[7].equals(name))
			){
				view.addMember(packet_field_IP,packet_field_name,packet_field_timestamp);
				//quindi lo si consegna
				deliverPacket(recv,packet_field_IP+" "+packet_field_name,new Integer(packet_sequence_number));
			}//if

			//altrimenti si controlla di aver aggiunto alla view il nuovo entrante
			else{
				view.addMember(packet_fields[6],packet_fields[7],packet_field_timestamp);
				checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);
			}
		}//if has-joined

		//se si  ricevuto un pacchetto da un membro non presente nella propria view
		else if(!view.contains(packet_field_IP+" "+packet_field_name)){
			newMember(packet_field_IP,packet_field_name,packet_field_timestamp);
			deliverPacket(recv,packet_field_IP+" "+packet_field_name,new Integer(packet_sequence_number));
		}//if

		else if(packet_field_type.equals("suspect-crashed")){

			//se il sospettato non  nella propria view, non si deve propagare il sospetto,
			//altrimenti il sistema diventa instabile (genera pacchetti inutili di suspect-crash all'infinito)
			//per si deve mandare un messaggio che servir comunque come conferma del sospetto
			if(!view.contains(packet_fields[6]+" "+packet_fields[7])){
				send("don't-know "+packet_fields[6]+" "+packet_fields[7]);
			}//if
			else{
				//altrimenti si manda un pacchetto per controllare se anche il ricevente 
				//non riesce a comunicare con il sospettato di crash
				send("hello");

				boolean all_are_suspecting = view.add_suspicion(packet_field_IP, packet_field_name, 
																								packet_fields[6], packet_fields[7]);
				if(all_are_suspecting){
					removeMember(packet_fields[6],packet_fields[7]);
					send("has-crashed "+packet_fields[6]+" "+packet_fields[7]);
				}//if
			}//else
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);
		}//if suspect-crashed

		else if(packet_field_type.equals("don't-know")){
			if(view.contains((packet_fields[6]+" "+packet_fields[7]))){
				boolean all_are_suspecting = view.add_suspicion(packet_field_IP, packet_field_name, 
																								packet_fields[6], packet_fields[7]);
				if(all_are_suspecting){
					removeMember(packet_fields[6],packet_fields[7]);
					send("has-crashed "+packet_fields[6]+" "+packet_fields[7]);
				}//if
			}//if view contains
			//il pacchetto va comunque consegnato
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);
		}//if don't know

		else if(packet_field_type.equals("has-crashed")){
			removeMember(packet_fields[6],packet_fields[7]);
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);
		}//if has-crashed

		//messaggio di leave
		else if(packet_field_type.equals("leave")){
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);
		}//if leave

		//messaggio ordinario
		else if(packet_field_type.equals("ordinary")||packet_field_type.equals("hello")){
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);
		}//if ordinary

		else if(packet_field_type.equals("request-service")){
			if(packet_fields[6].equals(service_name))send("service-available "+service_name);
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);			
		}//if request service

		else if(packet_field_type.equals("what-services")){
			if(service_name!=null)send("service-available "+service_name);
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);			
		}//if what services

		else if(packet_field_type.equals("service-available")){
			aboutService(packet_field_IP,packet_fields[6]);
			checkIfDeliverPacket(recv,packet_field_IP,packet_field_name,packet_sequence_number);			
		}//if service available

		int logical_clock_here;
		synchronized(synchronizing_numbers_lock){
			logical_clock_here = logical_clock;
		}//synchronized

		//ack inviato appena  stato ricevuto il pacchetto, ancora prima del delivery
		sendAck(packet_field_IP, Integer.parseInt(packet_field_ack_port),
			"ack "+packet_field_name,packet_sequence_number, ""+logical_clock_here);

		}catch(Exception e){output.append("\nreceive error: "+e.getMessage());e.printStackTrace();}

}//recv





public void sendAck(String IP, int remote_ack_port, String string_msg, 
										String packet_sequence_number, String sender_logical_clock){
		byte[] msg = (getMemberInfo()+" "+packet_sequence_number+" "+
								string_msg+" "+sender_logical_clock).getBytes();
		DatagramPacket packet = null;
		try{
		packet = new DatagramPacket(msg, msg.length, InetAddress.getByName(IP), remote_ack_port);
		unicast_socket.send(packet);
		output.append("\n -->send ack "+new String(packet.getData()).trim());
		}catch(Exception e){output.append("\n ack send error:"+e.getMessage());e.printStackTrace();}
}//sendAck





public void receiveAck(){
System.out.println("--> receiveAck");
		byte[] buf;
		DatagramPacket recv;
		try{
		buf = new byte[1000];
		recv = new DatagramPacket(buf, buf.length);

		//ricezione: bloccante ma eseguita dal thread Receiver
		unicast_socket.receive(recv);
		output.append("\nack received: --> "+new String(recv.getData()).trim());
		String[] packet_fields = new String(recv.getData()).split(" ");
		packet_fields[packet_fields.length-1] = packet_fields[packet_fields.length-1].trim();

/*il pacchetto  nel formato: 
<IP mittente> <porta mittente> <nome mittente> <numero sequenza> 
ack <nome destinatario> <timestamp>
*/

		String packet_field_IP = packet_fields[0];
		String packet_field_port = packet_fields[1];
		String packet_field_name = packet_fields[2];
		String packet_field_number = packet_fields[3];
		String packet_field_timestamp = packet_fields[6];

		synchronized(this){
			PacketWrapper pw = (PacketWrapper)send_buffer.get(new Integer(packet_field_number));
			if(pw==null)return;

			if(
				pw.setAck(packet_field_IP+" "+packet_field_name)==true
			){
				send_buffer.remove(new Integer(packet_field_number));
				output.append("\nsend_buffer decrease: "+send_buffer.toString());
			}//if
		}//synchronized
		
		//se si  ricevuto un ack da un membro non presente nella propria view
		if(!view.contains(packet_field_IP+" "+packet_field_name)	){
			newMember(packet_field_IP,packet_field_name,packet_field_timestamp);
		}//if

		}catch(Exception e){output.append("\n ack receive error:"+e.getMessage());e.printStackTrace();}
}//receiveAck





//livello applicativo: utilizzo (delivery) del pacchetto
public void deliverPacket(DatagramPacket recv, String member_id, Integer seq_num){

String msg = (new String(recv.getData())).trim();
String[] fields = msg.split(" ");

//si impedisce di fare il delivery di un pacchetto gi consegnato o vecchio
//(caso possibile per i pacchetti di tipo join, has-join, oppure membro non presente nella
//propria view, perch questi pacchetti vengono consegnati appena ricevuti)
Integer eventually_already_set_seq_num = (Integer)last_delivered_packet.get(member_id);
if(eventually_already_set_seq_num!=null){
	if(seq_num.intValue()<=eventually_already_set_seq_num.intValue())return;
}

last_delivered_packet.put(member_id,seq_num);

	if(fields[4].equals("leave")){
		removeMember(fields[0],fields[2]);
	}//if leave

	if(fields[4].equals("ordinary")){
	boolean to_buffer = false;
	Hashtable received_vector_clock = new Hashtable(); //chiave = member_id, valore = logical_clock
	to_buffer = checkIfDeliverCausalPacket(msg,received_vector_clock);
		if(to_buffer){
			causal_receive_buffer.add(msg);
			output.append("\n@@@@@ causal receive buffer increase: "+causal_receive_buffer.toString());
			return;
		}//if

		//altrimenti il messaggio pu essere messo in delivery e si aggiorna il vector clock locale:
		causalDelivery(msg);

		//si controlla se questo pacchetto pu generare altri delivery
		Iterator it = causal_receive_buffer.iterator();
		boolean moreRounds = true;
		while(moreRounds){
		moreRounds = false;
			while(it.hasNext()){
				String current_msg = (String)it.next();
				received_vector_clock = new Hashtable();
				to_buffer = checkIfDeliverCausalPacket(current_msg,received_vector_clock);
				if(!to_buffer){
					causalDelivery(current_msg);
					causal_receive_buffer.remove(current_msg);
					output.append("\n@@@@@ causal receive buffer decrease: "+causal_receive_buffer.toString());
					moreRounds = true; //se  stato fatto un altro delivery, si ricomincia a scandire il buffer
				}//if
			}//while
		}//while

		return;
	}//if ordinary

application_output.append("\nat local time "+System.currentTimeMillis()+": delivered--> \""+new String(recv.getData()).trim()+"\"");
}//deliverPacket





public void causalDelivery(String msg){
String sender_logical_clock = msg.split(" ")[5];
String current_member_id = msg.split(" ")[0]+" "+msg.split(" ")[2];
	//il messaggio pu essere messo in delivery e si aggiorna il vector clock locale:
	view.set_logical_clock(current_member_id, sender_logical_clock);
application_output.append("\nat local time "+System.currentTimeMillis()+": delivered--> \""+msg+"\"");
}//causalDelivery





public boolean checkIfDeliverCausalPacket(String msg, Hashtable received_vector_clock){
String[] fields = msg.split(" ");
	boolean to_buffer = false;
		//si controllano le 2 condizioni per il delivery causale
		if(Integer.parseInt(fields[5])!=view.get_logical_clock(fields[0]+" "+fields[2]).intValue()+1){
			to_buffer = true;
		}//if
		for(int i=6;i<fields.length;){
			if(fields[i].startsWith("#")){
				String current_member_id = fields[i].substring(1)+" "+fields[i+1];
				if(current_member_id.equals(location.getHostAddress()+" "+name)){i++;continue;}
				Integer current_logical_clock = new Integer(fields[i+2]);
				received_vector_clock.put(current_member_id,current_logical_clock);
				if(
					current_logical_clock.intValue()>((Integer)view.get_logical_clock(current_member_id)).intValue()
				){
					to_buffer = true;
				}//if
				i=i+2;
			}//if
		i++;
		}//for
return to_buffer;
}//checkIfDeliverCausalPacket





public void checkIfDeliverPacket(DatagramPacket recv, String IP, String name, String packet_sequence_number){
	int this_packet_seq_num = Integer.parseInt(packet_sequence_number);
	Integer last_seq_num_Integer = (Integer)last_delivered_packet.get(IP+" "+name);

	//se  arrivato un pacchetto da un membro sconosciuto lo si scarta
	if(last_seq_num_Integer==null)return;

	int last_seq_num = last_seq_num_Integer.intValue();

	//se il pacchetto  troppo vecchio lo si scarta
	if(this_packet_seq_num<=last_seq_num)return;

	//se il pacchetto  il successivo all'ultimo consegnato
	if(this_packet_seq_num==last_seq_num+1){
		last_seq_num++;
		//lo si consegna
		deliverPacket(recv,IP+" "+name,new Integer(packet_sequence_number));
		//e si consegnano anche gli altri nel receive_buffer immediatamente successivi
		DatagramPacket dp = null;
		while((dp=(DatagramPacket)receive_buffer.get(IP+" "+name+" "+(last_seq_num+1)))!=null){
			receive_buffer.remove(IP+" "+name+" "+(last_seq_num+1));
			output.append("\n#####at local time: "+System.currentTimeMillis()+
				" receive_buffer decrease, LAST seq_num="+last_seq_num+
				"and THIS seq_num="+(last_seq_num+1)+" :"+
				receive_buffer.toString());
			last_seq_num++;
			deliverPacket(dp,IP+" "+name,new Integer(last_seq_num));
		}//while			
	}//if
	else{
		receive_buffer.put(IP+" "+name+" "+packet_sequence_number,recv);
		output.append("\n#####at local time: "+System.currentTimeMillis()+
				" receive_buffer increase, LAST seq_num="+last_seq_num+
				" but THIS seq_num="+this_packet_seq_num+
				" : "+receive_buffer.toString());
	}//else
}//checkIfDeliverPacket





public void newMember(String packet_field_IP, String packet_field_name, String timestamp){
		//se si  ricevuto un pacchetto da un membro
		//non presente nella propria view, per esempio un membro ricomparso
		//dopo essere stato accusato di crash (in realt non andato in crash, ma irraggiungibile
		//per problemi di rete)
		view.addMember(packet_field_IP,packet_field_name,timestamp);
		/*si manda a tutti i membri della view la notifica della presenza di un membro
		non presente nella view*/
		send("has-joined "+packet_field_IP+" "+packet_field_name);
		return;
}//newMember





public void leaveGroup(){
	try{
		send("leave"); //da eliminare per simulare un crash alla chiusura di un membro
		multicast_socket.leaveGroup(group);
	}catch(Exception e){output.append("\n"+e.getMessage());}
}//leaveGroup





public void aboutService(String IP, String serviceName){
Remote service = null;
try{
	service = Naming.lookup("//"+IP+":1099"+"/"+serviceName);
}
catch(NotBoundException e){
	output.append("\nservice not found, maybe you have to use the package prefix, i.e. \"gcs\"");
	return;
}//catch
catch(Exception e){
	output.append("\n"+e.getMessage());
	e.printStackTrace();
	return;
}//catch

if(service==null){System.out.println("remote object reference is null");return;}

	Method[] methods = service.getClass().getMethods();
	String method_list = "\t";
	for(int i=0;i<methods.length;i++){
		Class[] parameters = methods[i].getParameterTypes();
		String parameters_list = "";
		for(int j=0;j<parameters.length;j++){
			parameters_list += parameters[j].getName();
			if(j<parameters.length-1)parameters_list += ", ";
		}//for
		method_list += methods[i].getReturnType().getName()+" "+
				methods[i].getName()+"("+parameters_list+")";
		if(i<methods.length-1)method_list += "\n\t";
	}//for

application_output.append("\nservice "+serviceName+":\n"+method_list);

}//aboutService





public static void main(String args[]){
System.setSecurityManager(new RMISecurityManager());

boolean setLocalInterface_flag = false;
if(args[0].endsWith("_local"))setLocalInterface_flag = true;

String service_name = null;

if(args.length>2){
try{
Remote service = (Remote)Class.forName(args[2]).newInstance();
Naming.rebind("//localhost:1099/"+args[2], service);
}catch(Exception e){
	System.out.println(""+e.getMessage());e.printStackTrace();System.exit(-1);
}//catch
service_name = args[2];
}//if

//ipotesi: in locale non esistono pi processi con lo stesso nome, n con la stessa porta per gli ack
//e due processi offrono due servizi con nome diverso
Member member = new Member(args[0], Integer.parseInt(args[1]), service_name);
member.init(setLocalInterface_flag);
new Receiver(member).start();
new AckReceiver(member).start();
new FailureDetector(member).start();
}//main

}//class Member
