package gcs;

import java.util.*;

public class FailureDetector extends Thread{

//risorse condivise a cui accede: send_buffer, view, contatori

private Member member;
private int time_threshold = 3000; //tempo massimo di tolleranza del ritardo di ricezione dell'ack
private int attempts_threshold = 3; //numero tentativi di trasmissione
private int sleeping_time = 5000; //tempo fra due successive attivazioni
private int MAX_SEND_BUFFER_time_threshold = 20000;

	public FailureDetector(Member member){
		this.member = member;
	}

public void run(){
while(true){
	try{
		Thread.sleep(sleeping_time);
		System.out.println("Failure Detector activation");
	}catch(Exception e){System.out.println("\n send error:"+e.getMessage());e.printStackTrace();}

synchronized(member){
		Enumeration enum = member.get_send_buffer().elements();
		while(enum.hasMoreElements()){
		PacketWrapper packet_wrapper = (PacketWrapper)enum.nextElement();
		if(packet_wrapper==null)continue;

		int times_number_sent = packet_wrapper.get_times_number_sent();

//se il pacchetto  nel buffer da troppo tempo
if((System.currentTimeMillis()-
				packet_wrapper.get_timestamp())
				>MAX_SEND_BUFFER_time_threshold
)member.get_send_buffer().remove(packet_wrapper);

			if(
				(System.currentTimeMillis()-
				packet_wrapper.get_timestamp())
				>time_threshold
			){
				if(times_number_sent<attempts_threshold)member.send(packet_wrapper.get_packet(),false,times_number_sent+1);
				else{
					HashSet eventuallyCrashedList = packet_wrapper.getEventuallyCrashedList();
					Iterator it = eventuallyCrashedList.iterator();
					while(it.hasNext()){
						String crashed_member_id = (String)it.next();
						/*si sospetta che il destinatario sia andato in crash, quindi si utilizza un protocollo
						per l'aggiornamento delle view*/
						String IP = crashed_member_id.split(" ")[0];
						String name = crashed_member_id.split(" ")[1];
						System.out.println("$$$$$$$$$$"+crashed_member_id+" is suspected to have crashed$$$$$$$$$$");

						if(!member.getView().contains(IP+" "+name))member.removeMember(IP,name);

						//inizio del protocollo di agreement per la potenziale esclusione del membro sospetto
						//invio di proposta di esclusione alla nuova view
						member.send("suspect-crashed "+IP+" "+name);

						System.out.println("sent: suspect-crashed "+IP+" "+name+", view="+member.getView().toString());

						boolean all_are_suspecting = member.getView().add_suspicion(
									member.getLocation().getHostAddress(), member.getName(),IP,name);

						System.out.println("added suspicion of member: "+IP+" "+name);

						if(all_are_suspecting){
						System.out.println("all are suspecting of: "+IP+" "+name);
							member.removeMember(IP,name);
							member.send("has-crashed "+IP+" "+name);
						}//if

						System.out.println("look at next packet of send_buffer...");
					}//while
				}//else
			}//if
		}//while
}//synchronized
}//while(true)
}//run

}//class FailureDetector