using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Xml;
using System.IO;
using System.Security.Cryptography;

using TeamProjectClient.it.teamproject.service;

using Bertaccini.Utils;

namespace TeamProjectClient
{
	public class TPClient : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Panel FnPanel;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel PnlMain;
		private System.Windows.Forms.TextBox Messages;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.Panel PnlData;
		private System.Windows.Forms.Button btnListDir;
		private System.Windows.Forms.ListBox featuresLB;
		private System.Windows.Forms.Splitter splitter3;
		private System.Windows.Forms.Panel pnlFiles;
		private System.Windows.Forms.TreeView Directorys;
		private System.Windows.Forms.Splitter splitter4;
		private System.Windows.Forms.ListBox FilesLB;
		private System.Windows.Forms.Button btnCreateDir;
		private System.Windows.Forms.Button btnListFiles;
		private System.Windows.Forms.Button btnUpload;
		private System.Windows.Forms.OpenFileDialog openFileDlg;
		private System.Windows.Forms.Button btnFileInfo;
		private System.Windows.Forms.Button btnLock;
		private System.Windows.Forms.Button btnUnlock;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public TPClient()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.FnPanel = new System.Windows.Forms.Panel();
			this.btnLock = new System.Windows.Forms.Button();
			this.btnFileInfo = new System.Windows.Forms.Button();
			this.btnUpload = new System.Windows.Forms.Button();
			this.btnListFiles = new System.Windows.Forms.Button();
			this.btnCreateDir = new System.Windows.Forms.Button();
			this.btnListDir = new System.Windows.Forms.Button();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.PnlMain = new System.Windows.Forms.Panel();
			this.PnlData = new System.Windows.Forms.Panel();
			this.pnlFiles = new System.Windows.Forms.Panel();
			this.FilesLB = new System.Windows.Forms.ListBox();
			this.splitter4 = new System.Windows.Forms.Splitter();
			this.Directorys = new System.Windows.Forms.TreeView();
			this.splitter3 = new System.Windows.Forms.Splitter();
			this.featuresLB = new System.Windows.Forms.ListBox();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.Messages = new System.Windows.Forms.TextBox();
			this.openFileDlg = new System.Windows.Forms.OpenFileDialog();
			this.btnUnlock = new System.Windows.Forms.Button();
			this.FnPanel.SuspendLayout();
			this.PnlMain.SuspendLayout();
			this.PnlData.SuspendLayout();
			this.pnlFiles.SuspendLayout();
			this.SuspendLayout();
			// 
			// FnPanel
			// 
			this.FnPanel.Controls.Add(this.btnUnlock);
			this.FnPanel.Controls.Add(this.btnLock);
			this.FnPanel.Controls.Add(this.btnFileInfo);
			this.FnPanel.Controls.Add(this.btnUpload);
			this.FnPanel.Controls.Add(this.btnListFiles);
			this.FnPanel.Controls.Add(this.btnCreateDir);
			this.FnPanel.Controls.Add(this.btnListDir);
			this.FnPanel.Dock = System.Windows.Forms.DockStyle.Left;
			this.FnPanel.Location = new System.Drawing.Point(0, 0);
			this.FnPanel.Name = "FnPanel";
			this.FnPanel.Size = new System.Drawing.Size(96, 333);
			this.FnPanel.TabIndex = 0;
			// 
			// btnLock
			// 
			this.btnLock.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnLock.Location = new System.Drawing.Point(0, 115);
			this.btnLock.Name = "btnLock";
			this.btnLock.Size = new System.Drawing.Size(96, 23);
			this.btnLock.TabIndex = 6;
			this.btnLock.Text = "Lock File";
			this.btnLock.Click += new System.EventHandler(this.btnLock_Click);
			// 
			// btnFileInfo
			// 
			this.btnFileInfo.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnFileInfo.Location = new System.Drawing.Point(0, 92);
			this.btnFileInfo.Name = "btnFileInfo";
			this.btnFileInfo.Size = new System.Drawing.Size(96, 23);
			this.btnFileInfo.TabIndex = 5;
			this.btnFileInfo.Text = "File Info";
			this.btnFileInfo.Click += new System.EventHandler(this.btnFileInfo_Click);
			// 
			// btnUpload
			// 
			this.btnUpload.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnUpload.Location = new System.Drawing.Point(0, 69);
			this.btnUpload.Name = "btnUpload";
			this.btnUpload.Size = new System.Drawing.Size(96, 23);
			this.btnUpload.TabIndex = 4;
			this.btnUpload.Text = "Upload File";
			this.btnUpload.Click += new System.EventHandler(this.btnUpload_Click);
			// 
			// btnListFiles
			// 
			this.btnListFiles.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnListFiles.Location = new System.Drawing.Point(0, 46);
			this.btnListFiles.Name = "btnListFiles";
			this.btnListFiles.Size = new System.Drawing.Size(96, 23);
			this.btnListFiles.TabIndex = 3;
			this.btnListFiles.Text = "List Files";
			this.btnListFiles.Click += new System.EventHandler(this.btnListFiles_Click);
			// 
			// btnCreateDir
			// 
			this.btnCreateDir.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnCreateDir.Location = new System.Drawing.Point(0, 23);
			this.btnCreateDir.Name = "btnCreateDir";
			this.btnCreateDir.Size = new System.Drawing.Size(96, 23);
			this.btnCreateDir.TabIndex = 2;
			this.btnCreateDir.Text = "Create Dir";
			this.btnCreateDir.Click += new System.EventHandler(this.btnCreateDir_Click);
			// 
			// btnListDir
			// 
			this.btnListDir.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnListDir.Location = new System.Drawing.Point(0, 0);
			this.btnListDir.Name = "btnListDir";
			this.btnListDir.Size = new System.Drawing.Size(96, 23);
			this.btnListDir.TabIndex = 0;
			this.btnListDir.Text = "List Directorys";
			this.btnListDir.Click += new System.EventHandler(this.btnListDir_Click);
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(96, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 333);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// PnlMain
			// 
			this.PnlMain.Controls.Add(this.PnlData);
			this.PnlMain.Controls.Add(this.splitter2);
			this.PnlMain.Controls.Add(this.Messages);
			this.PnlMain.Dock = System.Windows.Forms.DockStyle.Fill;
			this.PnlMain.Location = new System.Drawing.Point(99, 0);
			this.PnlMain.Name = "PnlMain";
			this.PnlMain.Size = new System.Drawing.Size(541, 333);
			this.PnlMain.TabIndex = 2;
			// 
			// PnlData
			// 
			this.PnlData.Controls.Add(this.pnlFiles);
			this.PnlData.Controls.Add(this.splitter3);
			this.PnlData.Controls.Add(this.featuresLB);
			this.PnlData.Dock = System.Windows.Forms.DockStyle.Fill;
			this.PnlData.Location = new System.Drawing.Point(0, 0);
			this.PnlData.Name = "PnlData";
			this.PnlData.Size = new System.Drawing.Size(541, 266);
			this.PnlData.TabIndex = 2;
			// 
			// pnlFiles
			// 
			this.pnlFiles.Controls.Add(this.FilesLB);
			this.pnlFiles.Controls.Add(this.splitter4);
			this.pnlFiles.Controls.Add(this.Directorys);
			this.pnlFiles.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlFiles.Location = new System.Drawing.Point(0, 0);
			this.pnlFiles.Name = "pnlFiles";
			this.pnlFiles.Size = new System.Drawing.Size(541, 207);
			this.pnlFiles.TabIndex = 2;
			// 
			// FilesLB
			// 
			this.FilesLB.Dock = System.Windows.Forms.DockStyle.Fill;
			this.FilesLB.Location = new System.Drawing.Point(163, 0);
			this.FilesLB.Name = "FilesLB";
			this.FilesLB.Size = new System.Drawing.Size(378, 199);
			this.FilesLB.TabIndex = 2;
			// 
			// splitter4
			// 
			this.splitter4.Location = new System.Drawing.Point(160, 0);
			this.splitter4.Name = "splitter4";
			this.splitter4.Size = new System.Drawing.Size(3, 207);
			this.splitter4.TabIndex = 1;
			this.splitter4.TabStop = false;
			// 
			// Directorys
			// 
			this.Directorys.Dock = System.Windows.Forms.DockStyle.Left;
			this.Directorys.ImageIndex = -1;
			this.Directorys.Location = new System.Drawing.Point(0, 0);
			this.Directorys.Name = "Directorys";
			this.Directorys.SelectedImageIndex = -1;
			this.Directorys.Size = new System.Drawing.Size(160, 207);
			this.Directorys.TabIndex = 0;
			this.Directorys.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.Directorys_AfterSelect);
			// 
			// splitter3
			// 
			this.splitter3.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.splitter3.Location = new System.Drawing.Point(0, 207);
			this.splitter3.Name = "splitter3";
			this.splitter3.Size = new System.Drawing.Size(541, 3);
			this.splitter3.TabIndex = 1;
			this.splitter3.TabStop = false;
			// 
			// featuresLB
			// 
			this.featuresLB.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.featuresLB.Location = new System.Drawing.Point(0, 210);
			this.featuresLB.Name = "featuresLB";
			this.featuresLB.Size = new System.Drawing.Size(541, 56);
			this.featuresLB.TabIndex = 0;
			// 
			// splitter2
			// 
			this.splitter2.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.splitter2.Location = new System.Drawing.Point(0, 266);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(541, 3);
			this.splitter2.TabIndex = 1;
			this.splitter2.TabStop = false;
			// 
			// Messages
			// 
			this.Messages.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.Messages.Location = new System.Drawing.Point(0, 269);
			this.Messages.Multiline = true;
			this.Messages.Name = "Messages";
			this.Messages.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.Messages.Size = new System.Drawing.Size(541, 64);
			this.Messages.TabIndex = 0;
			this.Messages.Text = "";
			// 
			// openFileDlg
			// 
			this.openFileDlg.Title = "Scegli il file da inviare";
			// 
			// btnUnlock
			// 
			this.btnUnlock.Dock = System.Windows.Forms.DockStyle.Top;
			this.btnUnlock.Location = new System.Drawing.Point(0, 138);
			this.btnUnlock.Name = "btnUnlock";
			this.btnUnlock.Size = new System.Drawing.Size(96, 23);
			this.btnUnlock.TabIndex = 7;
			this.btnUnlock.Text = "Unlock File";
			this.btnUnlock.Click += new System.EventHandler(this.btnUnlock_Click);
			// 
			// TPClient
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(640, 333);
			this.Controls.Add(this.PnlMain);
			this.Controls.Add(this.splitter1);
			this.Controls.Add(this.FnPanel);
			this.Name = "TPClient";
			this.Text = "Team project client";
			this.Load += new System.EventHandler(this.TPClient_Load);
			this.FnPanel.ResumeLayout(false);
			this.PnlMain.ResumeLayout(false);
			this.PnlData.ResumeLayout(false);
			this.pnlFiles.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new TPClient());
		}

		#region Class utilityes
		private XmlDocument BuildRequest(string action)
		{
			XmlDocument doc = new XmlDocument();
			doc.Load(
#if DEBUG
				@"..\..\" +
#endif
			"RequestTemplate.xml");
			XmlDocument param = new XmlDocument();
			param.Load(
#if DEBUG
				@"..\..\" +
#endif
				action + ".xml");
			XmlNode node = doc.SelectSingleNode("//UserName");
			node.InnerText = "Simo";
			node = doc.SelectSingleNode("//ActionParameters");
			node.InnerXml = param.DocumentElement.InnerXml;
			node = node.SelectSingleNode("../Code");
			node.InnerText = action;
			return doc;
		}

		private void ClearTree()
		{
			Directorys.Nodes.Clear();
			Directorys.Nodes.Add("/");
		}
		private string AddSelectedPath(string name)
		{
			TreeNode nd = Directorys.SelectedNode;
			while(nd != null && nd.Text != "/")
			{
				name = nd.Text + "\\" + name;
				nd = nd.Parent;
			}
			return name;
		}
		#endregion
		private void btnListDir_Click(object sender, System.EventArgs e)
		{
			XmlDocument doc = BuildRequest("ListLocations");
			//MessageBox.Show(doc.DocumentElement.InnerXml);
			XmlNode node = doc.SelectSingleNode("//LocationName");
			string path = AddSelectedPath("");
			if(path == "") path = "\\";
			node.InnerText = path;
			WebInterface wi = new WebInterface();
			wi.Discover();
			try
			{
				string result = wi.PerformAction(doc.DocumentElement.OuterXml);
				doc.LoadXml(result);
				node = doc.SelectSingleNode("//Error");
				if (node != null)
				{
					Messages.Text += "Errore lista directory: " + node.InnerText + "\r\n";
				}
				else
				{
					TreeNode bNode = Directorys.SelectedNode;
					if(bNode == null) bNode = Directorys.Nodes[0];
					bNode.Nodes.Clear();
					foreach(XmlNode nd in doc.SelectNodes("//Location"))
					{
						bNode.Nodes.Add(nd.InnerText);
					}
					Messages.Text += "Operazione completata con successo\r\n";
				}
			}
			catch(Exception ee)
			{
				MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
			}

		}

		private void btnCreateDir_Click(object sender, System.EventArgs e)
		{
			string res;
			if(InputBox.Show("Creazione directory","Digita il nome della directory da creare...",out res)
				== DialogResult.OK)
			{
				res = AddSelectedPath(res);
				
				XmlDocument doc = BuildRequest("CreateLocation");
				XmlNode node = doc.SelectSingleNode("//LocationName");
				node.InnerText = res;
				WebInterface wi = new WebInterface();
				wi.Discover();
				try
				{
					string result = wi.PerformAction(doc.DocumentElement.OuterXml);
					doc.LoadXml(result);
					node = doc.SelectSingleNode("//Error");
					if (node != null)
					{
						Messages.Text += "Errore creazione directory: " + node.InnerText + "\r\n";
					}
					Messages.Text += "Operazione completata con successo\r\n";
				}
				catch(Exception ee)
				{
					MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
				}
			}
		}

		private void TPClient_Load(object sender, System.EventArgs e)
		{
			ClearTree();
		}

		private void btnListFiles_Click(object sender, System.EventArgs e)
		{
			string path = AddSelectedPath("");
			if(path == "") path = "\\";
			XmlDocument doc = BuildRequest("ListElements");
			XmlNode node = doc.SelectSingleNode("//LocationName");
			node.InnerText = path;
			WebInterface wi = new WebInterface();
			wi.Discover();
			try
			{
				string result = wi.PerformAction(doc.DocumentElement.OuterXml);
				doc.LoadXml(result);
				node = doc.SelectSingleNode("//Error");
				if (node != null)
				{
					Messages.Text += "Errore creazione directory: " + node.InnerText + "\r\n";
				}
				else
				{
					TreeNode bNode = Directorys.SelectedNode;
					FilesLB.Items.Clear();
					foreach(XmlNode nd in doc.SelectNodes("//Element"))
					{
						FilesLB.Items.Add(nd.InnerText);
					}
					Messages.Text += "Operazione completata con successo\r\n";
				}
			}
			catch(Exception ee)
			{
				MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
			}
		}

		private void btnUpload_Click(object sender, System.EventArgs e)
		{
			string app = Directory.GetCurrentDirectory();
			if(openFileDlg.ShowDialog(this) == DialogResult.OK)
			{
				FileInfo fi = new FileInfo(openFileDlg.FileName);
				Directory.SetCurrentDirectory(app);
				long l = fi.Length;
				byte[] fileData = new byte[l];
				Stream str = fi.OpenRead();
				int rd = str.Read(fileData,0,(int)l);
				if (rd != l)
				{
					Messages.Text += "Attenzione, letti " + rd.ToString() + " di " + l.ToString() + "\r\n";
				}
				XmlDocument doc = BuildRequest("FileStore");
				XmlNode node = doc.SelectSingleNode("//FileName");
				node.InnerText = fi.Name;
				node = doc.SelectSingleNode("//FilePath");
				node.InnerText = AddSelectedPath("");
				node = doc.SelectSingleNode("//FileData");
				node.InnerText = Convert.ToBase64String(fileData);
				WebInterface wi = new WebInterface();
				wi.Discover();
				try
				{
					string result = wi.PerformAction(doc.DocumentElement.OuterXml);
					doc.LoadXml(result);
					node = doc.SelectSingleNode("//Error");
					if (node != null)
					{
						Messages.Text += "Errore creazione directory: " + node.InnerText + "\r\n";
					}
					else
					{
						node = doc.SelectSingleNode("//Hash");
						if(!FilesLB.Items.Contains(fi.Name))FilesLB.Items.Add(fi.Name);
						FilesLB.SelectedItem = fi.Name;
						featuresLB.Items.Clear();
						featuresLB.Items.Add("Hash		" + node.InnerText);
					}
					Messages.Text += "Operazione completata con successo\r\n";
				}
				catch(Exception ee)
				{
					MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
				}
			}
		}

		private void Directorys_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			FilesLB.Items.Clear();
			featuresLB.Items.Clear();
		}

		private void btnFileInfo_Click(object sender, System.EventArgs e)
		{
			if(FilesLB.SelectedIndex < 0) 
			{
				MessageBox.Show(this,"Scegli un file prima");
				return;
			}
			DialogResult dlgres = MessageBox.Show(this,"Vuoi controllare una versione specifica?","Get File Info",
				MessageBoxButtons.YesNoCancel);
			if(dlgres == DialogResult.Cancel) return;
			XmlDocument doc = BuildRequest("GetFileInfo");
			XmlNode node = doc.SelectSingleNode("//FileHash");
			if(dlgres == DialogResult.Yes)
			{
				string txt = openFileDlg.Title;
				openFileDlg.Title = "Scegli il file da confrontare";
				string curDir = Directory.GetCurrentDirectory();
				dlgres = openFileDlg.ShowDialog(this);
				Directory.SetCurrentDirectory(curDir);
				openFileDlg.Title = txt;
				if(dlgres != DialogResult.OK) return;
				SHA1Managed HashP = new SHA1Managed();
				HashP.Initialize();
				Stream fs = openFileDlg.OpenFile();
				byte[] hash = HashP.ComputeHash(fs);
				string sHash = Convert.ToBase64String(hash);
				node.InnerText = sHash;
			}
			else
			{
				node.ParentNode.RemoveChild(node);
			}
			node = doc.SelectSingleNode("//FileName");
			node.InnerText = FilesLB.SelectedItem.ToString();
			node = doc.SelectSingleNode("//FilePath");
			node.InnerText = AddSelectedPath("");
			WebInterface wi = new WebInterface();
			wi.Discover();
			try
			{
				string result = wi.PerformAction(doc.DocumentElement.OuterXml);
				doc.LoadXml(result);
				node = doc.SelectSingleNode("//Error");
				if (node != null)
				{
					Messages.Text += "Errore lettura delle info: " + node.InnerText + "\r\n";
					return;
				}
				else
				{
					featuresLB.Items.Clear();
					XmlNode nd1 = doc.SelectSingleNode("//GetFileInfoResponse/File");
					node = nd1.SelectSingleNode("Hash");
					featuresLB.Items.Add("Hash: " + node.InnerText);
					node = nd1.SelectSingleNode("Uploader");
					featuresLB.Items.Add("Uploader: " + node.InnerText);
					node = nd1.SelectSingleNode("UploadTime");
					featuresLB.Items.Add("UploadTime: " + node.InnerText);
					node = doc.SelectSingleNode("//Status");
					if(node != null)
						featuresLB.Items.Add("Stato: " + node.InnerText);
					node = doc.SelectSingleNode("//History");
					if(node != null)
					{
						XmlNodeList ndL = node.SelectNodes("File");
						foreach(XmlNode nd in ndL)
						{
							node = nd.SelectSingleNode("Hash");
							featuresLB.Items.Add("Old-Hash: " + node.InnerText);
							node = nd.SelectSingleNode("Uploader");
							featuresLB.Items.Add("Old-Uploader: " + node.InnerText);
							node = nd.SelectSingleNode("UploadTime");
							featuresLB.Items.Add("Old-UploadTime: " + node.InnerText);
						}
						featuresLB.Items.Add("Stato: " + node.InnerText);
					}
					node = doc.SelectSingleNode("//Lock");
					if(node != null)
					{
						nd1 = node;
						node = nd1.SelectSingleNode("Owner");
						featuresLB.Items.Add("Lock-Owner: " + node.InnerText);
						node = nd1.SelectSingleNode("Time");
						featuresLB.Items.Add("Lock-LockTime: " + node.InnerText);
						node = nd1.SelectSingleNode("RequestID");
						featuresLB.Items.Add("Lock-Request: " + node.InnerText);
					}
				}
				Messages.Text += "Operazione completata con successo\r\n";
			}
			catch(Exception ee)
			{
				MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
			}
		}

		private void btnLock_Click(object sender, System.EventArgs e)
		{
			if(FilesLB.SelectedIndex < 0) 
			{
				MessageBox.Show(this,"Scegli un file prima");
				return;
			}
			XmlDocument doc = BuildRequest("LockFile");
			XmlNode node = doc.SelectSingleNode("//FileName");
			node.InnerText = FilesLB.SelectedItem.ToString();
			node = doc.SelectSingleNode("//FileHash");
			node.InnerText = "AF/58FBWBp49x3FtAcjm5M5C/H8=";
			node = doc.SelectSingleNode("//FilePath");
			node.InnerText = AddSelectedPath("");
			WebInterface wi = new WebInterface();
			wi.Discover();
			try
			{
				string result = wi.PerformAction(doc.DocumentElement.OuterXml);
				doc.LoadXml(result);
				node = doc.SelectSingleNode("//Error");
				if (node != null)
				{
					Messages.Text += "Errore durante il lock: " + node.InnerText + "\r\n";
					return;
				}
				else
				{
					featuresLB.Items.Add("Locked by YOU");
				}
				Messages.Text += "Operazione completata con successo\r\n";
			}
			catch(Exception ee)
			{
				MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
			}
		}

		private void btnUnlock_Click(object sender, System.EventArgs e)
		{
			if(FilesLB.SelectedIndex < 0) 
			{
				MessageBox.Show(this,"Scegli un file prima");
				return;
			}
			XmlDocument doc = BuildRequest("UnlockFile");
			XmlNode node = doc.SelectSingleNode("//FileName");
			node.InnerText = FilesLB.SelectedItem.ToString();
			node = doc.SelectSingleNode("//FilePath");
			node.InnerText = AddSelectedPath("");
			WebInterface wi = new WebInterface();
			wi.Discover();
			try
			{
				string result = wi.PerformAction(doc.DocumentElement.OuterXml);
				doc.LoadXml(result);
				node = doc.SelectSingleNode("//Error");
				if (node != null)
				{
					Messages.Text += "Errore durante l'unlock: " + node.InnerText + "\r\n";
					return;
				}
				else
				{
					featuresLB.Items.Clear();
				}
				Messages.Text += "Operazione completata con successo\r\n";
			}
			catch(Exception ee)
			{
				MessageBox.Show(ee.Message + "\n" + ee.StackTrace);
			}
		}
	}
}
