using System;
using System.Xml;
using System.Collections;

namespace Bertaccini.Utils
{
	[Serializable]
	public class TreeElement
	{
		protected TreeElement parent = null;
		protected ArrayList childs = new ArrayList();
		protected object node = null;

		public static TreeElement FromXmlNode(XmlNode rootNode)
		{
			Pair NameValue = new Pair(rootNode.Name,rootNode.Value);
			TreeElement root = new TreeElement(NameValue);
			foreach(XmlNode nd in rootNode.ChildNodes)
			{
				if(nd.NodeType == XmlNodeType.Element)
				{
					TreeElement el = FromXmlNode(nd);
					el.Parent = root;
				}
			}
			return root;
		}

		public TreeElement(object nodeCnt)
		{
			node = nodeCnt;
		}

		public TreeElement(object nodeCnt,TreeElement par)
		{
			node = nodeCnt;
			Parent = par;
		}

		public void AddChild(TreeElement te)
		{
			childs.Add(te);
		}
		public void RemoveChild(TreeElement te)
		{
			childs.Remove(te);
		}

		public TreeElement this[int childIndx]
		{
			get{return (TreeElement)childs[childIndx];}
		}
		public ArrayList Children
		{
			get{return childs;}
		}
		public TreeElement Parent
		{
			get{return parent;}
			set
			{
				if(parent != null)
					parent.RemoveChild(this);
				parent = value;
				parent.AddChild(this);
			}
		}
		public object Content
		{
			get{return node;}
		}
		public XmlDocument ToXmlDocument()
		{
			XmlDocument doc = new XmlDocument();
			doc.AppendChild(doc.CreateXmlDeclaration("1.0","UTF-8",""));
			XmlNode nd = this.ToNode(doc);
			doc.AppendChild(nd);
			return doc;
		}
		private XmlNode ToNode(XmlDocument doc)
		{
			Pair p = (Pair)Content;
			XmlElement el = doc.CreateElement((string)p.First);
			el.InnerText = (string) p.Second;
			foreach (TreeElement te in this.Children)
			{
				XmlNode nd  = te.ToNode(doc);
				el.AppendChild(nd);
			}
			return el;
		}
	}
}
